/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import com.lti.utils.ObjUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.Track;
import javax.media.control.BufferControl;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.filtergraph.CodecFormatPair;
import net.sf.fmj.filtergraph.CodecFormatPairProximityComparator;
import net.sf.fmj.filtergraph.CodecNode;
import net.sf.fmj.filtergraph.DemuxNode;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.filtergraph.FilterGraphNode;
import net.sf.fmj.filtergraph.MuxNode;
import net.sf.fmj.filtergraph.RendererNode;
import net.sf.fmj.utility.LoggerSingleton;

public final class FilterGraph {
    private static final int MAX_GRAPH_DEPTH = 10;
    private static final int TYPICAL_GRAPH_DEPTH = 0;
    private static final int BEST_FIRST_SEARCH_DEPTH = 8;
    private static final int BEST_FIRST_SEARCH_BREADTH = 5;
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    public static final int PROCESS_DEFAULT = 0;
    public static final int SUPPRESS_TRACK_READ = 1;
    private static final boolean SKIP_NON_FORMAT_CHANGING_CODECS = true;

    private FilterGraph() {
    }

    public static FilterGraphNode getTail(FilterGraphNode n) {
        if (n == null) {
            return n;
        }
        while (n.getNumDestLinks() > 0) {
            n = n.getDestLink(0).getDestNode();
        }
        return n;
    }

    public static FilterGraphNode getBeforeTail(FilterGraphNode n) {
        while (n.getNumDestLinks() > 0 && n.getDestLink(0).getDestNode().getNumDestLinks() > 0) {
            n = n.getDestLink(0).getDestNode();
        }
        return n;
    }

    public static void start(FilterGraphNode n) throws IOException {
        n.start();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            FilterGraphLink destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraph.start(destLink.getDestNode());
        }
    }

    public static void stop(FilterGraphNode n) throws IOException {
        n.stop();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            FilterGraphLink destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraph.stop(destLink.getDestNode());
        }
    }

    public static void open(FilterGraphNode n) throws ResourceUnavailableException {
        n.open();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            FilterGraphLink destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraph.open(destLink.getDestNode());
        }
    }

    private static String tabs(int i) {
        StringBuffer b = new StringBuffer();
        while (i-- > 0) {
            b.append('\t');
        }
        return b.toString();
    }

    public static void print(FilterGraphNode n, int tabs) {
        FilterGraph.print(new FilterGraphLink(n), tabs);
    }

    public static void print(FilterGraphLink link, int tabs) {
        FilterGraphNode n = link.getDestNode();
        String trackStr = "";
        if (link.getDestTrack() >= 0) {
            trackStr = "[Track " + link.getDestTrack() + " of] ";
        }
        n.print(logger, FilterGraph.tabs(tabs) + trackStr);
        for (int j = 0; j < n.getNumDestLinks(); ++j) {
            FilterGraphLink linkChild = n.getDestLink(j);
            if (linkChild == null) continue;
            FilterGraph.print(linkChild, tabs + 1);
        }
    }

    public static void process(FilterGraphNode n, Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int result = 0;
        do {
            if ((result = n.process(input, sourceTrackNumber, destTrackNumber, flags)) != 0 && result != 2) {
                return;
            }
            for (int i = 0; i < n.getNumDestLinks(); ++i) {
                FilterGraphLink linkDest;
                if (n instanceof DemuxNode && sourceTrackNumber >= 0 && i != sourceTrackNumber || (linkDest = n.getDestLink(i)) == null) continue;
                if (n.getOutputBuffer(i) == null) {
                    throw new NullPointerException("Buffer " + i + " is null, trackNumber=" + sourceTrackNumber + ", flags=" + flags);
                }
                Buffer b = n.getOutputBuffer(i);
                if (b.isDiscard()) continue;
                FilterGraph.process(linkDest.getDestNode(), b, -1, linkDest.getDestTrack(), flags);
            }
        } while (result == 2);
    }

    private static Renderer findRenderer(Format f) {
        String rendererClassName;
        int k;
        Vector renderers = PlugInManager.getPlugInList(f, null, 4);
        if (renderers.size() == 0) {
            logger.fine("No renderers found for: " + f);
        }
        for (k = 0; k < renderers.size(); ++k) {
            rendererClassName = (String)renderers.get(k);
            logger.fine("Found renderer for " + f + ": " + rendererClassName);
        }
        for (k = 0; k < renderers.size(); ++k) {
            rendererClassName = (String)renderers.get(k);
            logger.fine("Trying renderer for " + f + ": " + rendererClassName);
            Renderer renderer = (Renderer)FilterGraph.instantiate(rendererClassName);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    public static Multiplexer findMux(Format destFormat) {
        String muxClassName;
        int k;
        Vector muxs = PlugInManager.getPlugInList(null, destFormat, 5);
        if (muxs.size() == 0) {
            logger.fine("No muxs found for: " + destFormat);
        }
        for (k = 0; k < muxs.size(); ++k) {
            muxClassName = (String)muxs.get(k);
            logger.fine("Found mux for " + destFormat + ": " + muxClassName);
        }
        for (k = 0; k < muxs.size(); ++k) {
            muxClassName = (String)muxs.get(k);
            logger.fine("Trying mux for " + destFormat + ": " + muxClassName);
            Multiplexer mux = (Multiplexer)FilterGraph.instantiate(muxClassName);
            if (mux == null) continue;
            return mux;
        }
        return null;
    }

    public static List findMuxs() {
        Vector muxs = PlugInManager.getPlugInList(null, null, 5);
        if (muxs.size() == 0) {
            logger.fine("No muxs found");
        }
        for (int k = 0; k < muxs.size(); ++k) {
            String muxClassName = (String)muxs.get(k);
            logger.fine("Found mux: " + muxClassName);
        }
        ArrayList<Multiplexer> result = new ArrayList<Multiplexer>();
        for (int k = 0; k < muxs.size(); ++k) {
            String muxClassName = (String)muxs.get(k);
            logger.fine("Trying mux: " + muxClassName);
            Multiplexer mux = (Multiplexer)FilterGraph.instantiate(muxClassName);
            if (mux == null) continue;
            result.add(mux);
        }
        return result;
    }

    private static Format negotiate(Format f, Multiplexer dest, Format muxInputFormat, int muxDestTrack, PlugIn src) {
        if (muxInputFormat.matches(f)) {
            return muxInputFormat;
        }
        return null;
    }

    private static Format negotiate(Format f, Renderer dest, PlugIn src) {
        int iterations = 0;
        while (f != null) {
            if (iterations >= 1000) {
                logger.warning("negotiate iterated 1000 times, probably stuck in infinite loop - abandoning format negotiation");
                logger.warning("src=" + src);
                logger.warning("dest=" + dest);
                logger.warning("f=" + f);
                return null;
            }
            ++iterations;
            Format f2 = dest.setInputFormat(f);
            if (f2 == null) {
                logger.warning("Input format rejected by " + dest + ": " + f);
                return null;
            }
            if (!(src instanceof Codec)) {
                return f2;
            }
            Format f3 = ((Codec)src).setOutputFormat(f2);
            if (f2.equals(f3)) {
                return f3;
            }
            f = f3;
        }
        return null;
    }

    private static String indent(int depth) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private static FilterGraphNode findCodecPathTo(int destPlugInType, Format f, PlugIn from, Multiplexer mux, Format muxInputFormat, int muxDestTrack, int depth) {
        FilterGraphNode n;
        int cutoffDepth;
        for (cutoffDepth = 0; cutoffDepth < 0; ++cutoffDepth) {
            n = FilterGraph.findCodecPathTo(destPlugInType, f, from, new HashSet(), mux, muxInputFormat, muxDestTrack, depth, cutoffDepth, -1);
            if (n == null) continue;
            return n;
        }
        for (cutoffDepth = 0; cutoffDepth < 8; ++cutoffDepth) {
            n = FilterGraph.findCodecPathTo(destPlugInType, f, from, new HashSet(), mux, muxInputFormat, muxDestTrack, depth, cutoffDepth, 5);
            if (n == null) continue;
            logger.fine("Graph found with best-first search.");
            return n;
        }
        logger.fine("Graph not found with best-first search, trying incrementally deeper breadth-first searches");
        for (cutoffDepth = 0; cutoffDepth < 10; ++cutoffDepth) {
            n = FilterGraph.findCodecPathTo(destPlugInType, f, from, new HashSet(), mux, muxInputFormat, muxDestTrack, depth, cutoffDepth, -1);
            if (n == null) continue;
            return n;
        }
        logger.warning("Filter graph search depth at 10, abandoning deeper search");
        return null;
    }

    private static FilterGraphNode findCodecPathTo(int destPlugInType, Format f, PlugIn from, Set excludeFormatAtDepths, Multiplexer mux, Format muxInputFormat, int muxDestTrack, int depth, int cutoffDepth, int maxBestCodecs) {
        Format codecOutputFormat;
        CodecFormatPair codecFormatPair;
        Codec codec;
        int j;
        if (f == null) {
            throw new NullPointerException();
        }
        if (depth >= cutoffDepth) {
            return null;
        }
        if (excludeFormatAtDepths.contains(new FormatAtDepth(f, depth))) {
            return null;
        }
        if (destPlugInType == 4) {
            Format fAccepted;
            Renderer renderer = FilterGraph.findRenderer(f);
            if (renderer != null && (fAccepted = FilterGraph.negotiate(f, renderer, from)) != null) {
                BufferControl bufferControl = (BufferControl)renderer.getControl("javax.media.control.BufferControl");
                if (bufferControl != null) {
                    bufferControl.setBufferLength(2000L);
                }
                return new RendererNode(renderer, fAccepted);
            }
        } else if (destPlugInType == 5) {
            Format fAccepted = FilterGraph.negotiate(f, mux, muxInputFormat, muxDestTrack, from);
            if (fAccepted != null) {
                return new MuxNode(mux, fAccepted);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (depth >= cutoffDepth - 1) {
            return null;
        }
        Vector codecs = PlugInManager.getPlugInList(f, null, 2);
        for (int j2 = 0; j2 < codecs.size(); ++j2) {
            String codecClassName = (String)codecs.get(j2);
            logger.finest(FilterGraph.indent(depth) + "Found codec for " + f + ": " + codecClassName);
        }
        ArrayList<CodecFormatPair> codecFormatPairs = new ArrayList<CodecFormatPair>();
        for (j = 0; j < codecs.size(); ++j) {
            Format codecOutputFormat2;
            int codecOutputFormatIndex;
            String codecClassName = (String)codecs.get(j);
            logger.finer(FilterGraph.indent(depth) + "Trying " + codecClassName);
            codec = (Codec)FilterGraph.instantiate(codecClassName);
            if (codec == null) continue;
            Format[] codecOutputFormats = codec.getSupportedOutputFormats(f);
            for (codecOutputFormatIndex = 0; codecOutputFormatIndex < codecOutputFormats.length; ++codecOutputFormatIndex) {
                codecOutputFormat2 = codecOutputFormats[codecOutputFormatIndex];
                logger.finest(FilterGraph.indent(depth) + "Found Codec output format: " + codecOutputFormat2);
            }
            for (codecOutputFormatIndex = 0; codecOutputFormatIndex < codecOutputFormats.length; ++codecOutputFormatIndex) {
                codecOutputFormat2 = codecOutputFormats[codecOutputFormatIndex];
                if (codecOutputFormat2 == null) {
                    logger.finer(FilterGraph.indent(depth) + "Skipping null Codec (" + codec.getClass() + ") output format, input format: " + f);
                    continue;
                }
                if (codecOutputFormat2.equals(f)) {
                    logger.finest(FilterGraph.indent(depth) + "YES " + "Skipping Codec output format, same as input format: " + codecOutputFormat2);
                    continue;
                }
                codecFormatPairs.add(new CodecFormatPair((Codec)FilterGraph.instantiate(codecClassName), codecOutputFormat2));
            }
        }
        if (muxInputFormat != null) {
            Collections.sort(codecFormatPairs, new CodecFormatPairProximityComparator(muxInputFormat));
            if (maxBestCodecs > 1) {
                while (codecFormatPairs.size() > maxBestCodecs) {
                    codecFormatPairs.remove(maxBestCodecs);
                }
            }
            for (j = 0; j < codecFormatPairs.size(); ++j) {
                codecFormatPair = (CodecFormatPair)codecFormatPairs.get(j);
                codec = codecFormatPair.getCodec();
                codecOutputFormat = codecFormatPair.getFormat();
                logger.finer(FilterGraph.indent(depth) + j + ". Will try " + codec.getClass().getName() + " with output format: " + codecOutputFormat);
            }
        }
        for (j = 0; j < codecFormatPairs.size(); ++j) {
            codecFormatPair = (CodecFormatPair)codecFormatPairs.get(j);
            codec = codecFormatPair.getCodec();
            codecOutputFormat = codecFormatPair.getFormat();
            logger.finer(FilterGraph.indent(depth) + "Trying " + codec.getClass().getName() + " with output format: " + codecOutputFormat);
            Format fAccepted = codec.setInputFormat(f);
            if (fAccepted == null) {
                logger.warning("Codec " + codec + " rejected input format " + f);
                continue;
            }
            Format codecOutputFormatAccepted = codec.setOutputFormat(codecOutputFormat);
            if (codecOutputFormatAccepted == null) {
                logger.warning("Codec " + codec + " rejected output format " + codecOutputFormat);
                continue;
            }
            logger.finer(FilterGraph.indent(depth) + "ACCEPT " + codecOutputFormatAccepted);
            for (int i = depth; i <= cutoffDepth; ++i) {
                excludeFormatAtDepths.add(new FormatAtDepth(f, i));
            }
            FilterGraphNode tail = FilterGraph.findCodecPathTo(destPlugInType, codecOutputFormatAccepted, codec, excludeFormatAtDepths, mux, muxInputFormat, muxDestTrack, depth + 1, cutoffDepth, maxBestCodecs);
            if (tail == null) continue;
            CodecNode codecNode = new CodecNode(codec, fAccepted);
            codecNode.addDestLink(new FilterGraphLink(tail, muxDestTrack));
            return codecNode;
        }
        return null;
    }

    public static Demultiplexer getSourceCompatibleDemultiplexer(DataSource source) {
        logger.fine("Content type: " + source.getContentType());
        ContentDescriptor contentDescriptor = new ContentDescriptor(source.getContentType());
        Vector demuxs = PlugInManager.getPlugInList(contentDescriptor, null, 1);
        logger.fine("Num demux: " + demuxs.size());
        for (int i = 0; i < demuxs.size(); ++i) {
            String demuxClassName = (String)demuxs.get(i);
            logger.fine("Demux class name found: " + demuxClassName);
            Demultiplexer demux = (Demultiplexer)FilterGraph.instantiate(demuxClassName);
            if (demux == null) continue;
            try {
                demux.setSource(source);
            }
            catch (IncompatibleSourceException e) {
                logger.warning("Skipping demux " + demuxClassName + ": " + e.getMessage());
                continue;
            }
            catch (IOException e) {
                logger.warning("Skipping demux " + demuxClassName + ": " + e.getMessage());
                continue;
            }
            return demux;
        }
        return null;
    }

    public static DemuxNode buildGraphToRenderer(ContentDescriptor contentDescriptor, Demultiplexer demux) {
        return FilterGraph.buildGraphTo(4, contentDescriptor, demux, null, null, -1);
    }

    public static DemuxNode buildGraphToMux(ContentDescriptor contentDescriptor, Demultiplexer demux, Multiplexer mux, Format muxInputFormat, int muxDestTrack) {
        return FilterGraph.buildGraphTo(5, contentDescriptor, demux, mux, muxInputFormat, muxDestTrack);
    }

    private static DemuxNode buildGraphTo(int pluginType, ContentDescriptor contentDescriptor, Demultiplexer demux, Multiplexer mux, Format muxInputFormat, int muxDestTrack) {
        Track[] tracks;
        try {
            tracks = demux.getTracks();
        }
        catch (BadHeaderException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        if (tracks == null) {
            logger.warning("demux " + demux + ": " + "no tracks");
            return null;
        }
        DemuxNode demuxNode = new DemuxNode(contentDescriptor, demux, tracks);
        logger.fine("Number of tracks: " + demuxNode.getTracks().length);
        int tracksComplete = 0;
        for (int trackIndex = 0; trackIndex < demuxNode.getTracks().length; ++trackIndex) {
            Track t = demuxNode.getTracks()[trackIndex];
            logger.fine("Track format: " + t.getFormat());
            FilterGraphNode n = FilterGraph.findCodecPathTo(pluginType, t.getFormat(), demux, mux, muxInputFormat, muxDestTrack, 0);
            if (n == null) {
                demuxNode.addDestLink(null);
                continue;
            }
            demuxNode.addDestLink(new FilterGraphLink(n, muxDestTrack));
            ++tracksComplete;
        }
        if (tracksComplete > 0) {
            return demuxNode;
        }
        return null;
    }

    private static Object instantiate(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Unable to instantiate " + className + ": " + e.getMessage(), e);
            return null;
        }
    }

    private static class FormatAtDepth {
        private final Format f;
        private final int depth;

        public FormatAtDepth(Format f, int depth) {
            this.f = f;
            this.depth = depth;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatAtDepth)) {
                return false;
            }
            FormatAtDepth oCast = (FormatAtDepth)obj;
            return oCast.depth == this.depth && ObjUtils.equal(oCast.f, this.f);
        }

        public int hashCode() {
            int result = this.depth;
            if (this.f != null) {
                result += this.f.toString().hashCode();
            }
            return result;
        }
    }
}

