/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class FilterGraphNode {
    protected static final Logger logger = LoggerSingleton.logger;
    private List destLinks = new ArrayList();
    private List outputBuffers = new ArrayList();
    private final PlugIn plugIn;

    public FilterGraphNode(PlugIn plugIn) {
        this.plugIn = plugIn;
    }

    public int getNumDestLinks() {
        return this.destLinks.size();
    }

    public FilterGraphLink getDestLink(int i) {
        try {
            return (FilterGraphLink)this.destLinks.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Buffer getOutputBuffer(int i) {
        try {
            return (Buffer)this.outputBuffers.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setOutputBuffer(int i, Buffer b) {
        this.outputBuffers.set(i, b);
    }

    public void addDestLink(FilterGraphLink n) {
        this.destLinks.add(n);
        this.outputBuffers.add(null);
    }

    public abstract FilterGraphNode duplicate();

    public abstract void open() throws ResourceUnavailableException;

    public abstract int process(Buffer var1, int var2, int var3, int var4);

    protected FilterGraphNode propagateDuplicate(FilterGraphNode result) {
        for (int i = 0; i < this.getNumDestLinks(); ++i) {
            FilterGraphLink link = this.getDestLink(i);
            if (link == null) continue;
            result.addDestLink(new FilterGraphLink(link.getDestNode().duplicate(), link.getDestTrack()));
        }
        return result;
    }

    public void print(Logger logger, String prefix) {
        String inputFormatStr = this.getInputFormat() == null ? "" : this.getInputFormat().getClass().getSimpleName() + " [" + this.getInputFormat() + "]";
        logger.info(prefix + inputFormatStr);
        logger.info(prefix + this.getPlugIn().getClass().getName());
    }

    public abstract Format getInputFormat();

    public PlugIn getPlugIn() {
        return this.plugIn;
    }

    public void start() throws IOException {
    }

    public void stop() {
    }
}

