/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.filtergraph.FilterGraphNode;

public class MuxNode
extends FilterGraphNode {
    private final Format inputFormat;
    private final Multiplexer mux;

    public MuxNode(Multiplexer mux, Format inputFormat) {
        super(mux);
        this.inputFormat = inputFormat;
        this.mux = mux;
    }

    public FilterGraphNode duplicate() {
        return this.propagateDuplicate(new MuxNode(this.getMultiplexer(), this.getInputFormat()));
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Multiplexer getMultiplexer() {
        return this.mux;
    }

    public void open() throws ResourceUnavailableException {
        this.getMultiplexer().open();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if ((processResult = this.getMultiplexer().process(input, destTrackNumber)) != 0) {
            if (processResult == 4) {
                logger.finer("Multiplexer process result: " + processResult);
            } else {
                logger.warning("Multiplexer process result: " + processResult);
            }
        }
        return processResult;
    }

    public void addDestLink(FilterGraphLink n) {
        throw new UnsupportedOperationException();
    }
}

