/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.util.logging.Level;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.filtergraph.FilterGraphNode;
import net.sf.fmj.media.SleepHelper;

public class RendererNode
extends FilterGraphNode {
    private final Renderer renderer;
    private final Format inputFormat;
    private boolean prefetched;
    private final SleepHelper sleepHelper = new SleepHelper();

    public RendererNode(Renderer renderer, Format inputFormat) {
        super(renderer);
        this.renderer = renderer;
        this.inputFormat = inputFormat;
    }

    public FilterGraphNode duplicate() {
        return this.propagateDuplicate(new RendererNode(this.getRenderer(), this.getInputFormat()));
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public void setPrefetched(boolean prefetched) {
        this.prefetched = prefetched;
    }

    public boolean isPrefetched() {
        return this.prefetched;
    }

    public void open() throws ResourceUnavailableException {
        this.getRenderer().open();
        this.sleepHelper.reset();
    }

    public void stop() {
        this.getRenderer().stop();
        this.sleepHelper.reset();
    }

    public void start() {
        this.sleepHelper.reset();
        this.getRenderer().start();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        Renderer renderer = this.getRenderer();
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if (renderer instanceof Prefetchable) {
            Prefetchable rendererAsPrefetchable = (Prefetchable)((Object)renderer);
            if (!this.isPrefetched() && rendererAsPrefetchable.isPrefetched()) {
                if (renderer instanceof Clock) {
                    Clock rendererAsClock = (Clock)((Object)renderer);
                    rendererAsClock.syncStart(new Time(rendererAsClock.getMediaNanoseconds()));
                }
                this.setPrefetched(true);
            }
        }
        do {
            int oldOffset = input.getOffset();
            try {
                this.sleepHelper.sleep(input.getTimeStamp());
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return 1;
            }
            processResult = renderer.process(input);
            if (processResult == 2) {
                logger.fine("processResult == Renderer.INPUT_BUFFER_NOT_CONSUMED");
                logger.fine("oldOffset = " + oldOffset);
                logger.fine("newoffset = " + input.getOffset());
                break;
            }
            if (processResult == 0) continue;
            logger.warning("Renderer process result (loop): " + processResult);
        } while (processResult == 2);
        if (processResult != 0) {
            logger.warning("Renderer process result: " + processResult);
            return processResult;
        }
        return 0;
    }

    public void addDestLink(FilterGraphLink n) {
        throw new UnsupportedOperationException();
    }
}

