/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gst.media.content.unknown;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.StandardControlPanel;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import org.gstreamer.GMainLoop;
import org.gstreamer.Gst;
import org.gstreamer.PlayBin;
import org.gstreamer.swing.GstVideoComponent;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private PlayBin playbin;
    private GstVideoComponent videoComponent;
    private static boolean gstInitialized;

    private static void initGstreamer() {
        if (gstInitialized) {
            return;
        }
        logger.info("Initializing gstreamer");
        try {
            Gst.init((String)"FMJ GStreamer Handler", (String[])new String[0]);
            Thread t = new Thread(){

                public void run() {
                    new GMainLoop().run();
                }
            };
            t.setDaemon(true);
            t.start();
            gstInitialized = true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to initialize gstreamer: " + t);
        }
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        Handler.initGstreamer();
        if (!gstInitialized) {
            throw new IncompatibleSourceException("Unable to initialize gstreamer");
        }
        super.setSource(source);
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        String path = URLUtils.extractValidPathFromFileUrl(this.getSource().getLocator().toExternalForm());
        URI uri = Handler.parseURI(path);
        this.playbin = new PlayBin(uri.toString());
        this.playbin.setURI(uri);
        this.videoComponent = new GstVideoComponent();
        this.playbin.setVideoSink(this.videoComponent.getElement());
        this.videoComponent.setPreferredSize(new Dimension(640, 480));
        return true;
    }

    private static URI parseURI(String uri) {
        try {
            URI u = new URI(uri);
            if (u.getScheme() == null) {
                throw new URISyntaxException(uri, "Invalid URI scheme");
            }
            return u;
        }
        catch (URISyntaxException e) {
            File f = new File(uri);
            if (!f.exists()) {
                throw new IllegalArgumentException("Invalid URI/file " + uri, e);
            }
            return f.toURI();
        }
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime " + t.getNanoseconds());
        this.playbin.setPosition(new org.gstreamer.Time(t.getNanoseconds()));
    }

    public float doPlayerSetRate(float rate) {
        logger.info("Handler.doPlayerSetRate " + rate);
        return rate;
    }

    public boolean doPlayerStop() {
        this.playbin.stop();
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        logger.info("Handler.doPlayerSyncStart" + t);
        if (!this.playbin.isPlaying()) {
            this.playbin.play();
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        long durationNanos = this.playbin.getDuration().longValue();
        if (durationNanos <= 0L) {
            return DURATION_UNKNOWN;
        }
        return new Time(durationNanos);
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        return new Time(this.playbin.getPosition().longValue());
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.videoComponent;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = new StandardControlPanel(this, 67);
            this.setControlPanelComponent(c);
        }
        return c;
    }
}

