/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.media.MimeTable;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static final MimeTable defaultMimeTable = new MimeTable();

    protected MimeManager() {
    }

    private static void put(String ext, String type) {
        defaultMimeTable.addMimeType(ext, type);
    }

    public static final boolean addMimeType(String fileExtension, String mimeType) {
        if (defaultMimeTable.getMimeType(fileExtension) != null) {
            logger.warning("Cannot override default mime-table entries");
            return false;
        }
        Registry.getInstance().addMimeType(fileExtension, mimeType);
        return true;
    }

    public static final boolean removeMimeType(String fileExtension) {
        return Registry.getInstance().removeMimeType(fileExtension);
    }

    public static final String getMimeType(String fileExtension) {
        String result = Registry.getInstance().getMimeType(fileExtension);
        if (result != null) {
            return result;
        }
        result = defaultMimeTable.getMimeType(fileExtension);
        return result;
    }

    public static final Hashtable<String, String> getMimeTable() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.putAll(defaultMimeTable.getMimeTable());
        result.putAll(Registry.getInstance().getMimeTable());
        return result;
    }

    public static final Hashtable getDefaultMimeTable() {
        return defaultMimeTable.getMimeTable();
    }

    public static final String getDefaultExtension(String mimeType) {
        String result = Registry.getInstance().getDefaultExtension(mimeType);
        if (result != null) {
            return result;
        }
        return defaultMimeTable.getDefaultExtension(mimeType);
    }

    public static final List<String> getExtensions(String mimeType) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(defaultMimeTable.getExtensions(mimeType));
        result.addAll(Registry.getInstance().getExtensions(mimeType));
        return result;
    }

    public static void commit() {
        try {
            Registry.getInstance().commit();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    static {
        MimeManager.put("mvr", "application/mvr");
        MimeManager.put("aif", "audio/x_aiff");
        MimeManager.put("aiff", "audio/x_aiff");
        MimeManager.put("midi", "audio/midi");
        MimeManager.put("jmx", "application/x_jmx");
        MimeManager.put("mpv", "video/mpeg");
        MimeManager.put("mpg", "video/mpeg");
        MimeManager.put("wav", "audio/x_wav");
        MimeManager.put("mp3", "audio/mpeg");
        MimeManager.put("mpa", "audio/mpeg");
        MimeManager.put("mp2", "audio/mpeg");
        MimeManager.put("spl", "application/futuresplash");
        MimeManager.put("viv", "video/vivo");
        MimeManager.put("au", "audio/basic");
        MimeManager.put("g729", "audio/g729");
        MimeManager.put("mov", "video/quicktime");
        MimeManager.put("avi", "video/x_msvideo");
        MimeManager.put("g728", "audio/g728");
        MimeManager.put("cda", "audio/cdaudio");
        MimeManager.put("g729a", "audio/g729a");
        MimeManager.put("gsm", "audio/x_gsm");
        MimeManager.put("mid", "audio/midi");
        MimeManager.put("swf", "application/x-shockwave-flash");
        MimeManager.put("rmf", "audio/rmf");
        boolean jmfDefaults = false;
        try {
            jmfDefaults = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!jmfDefaults) {
            MimeManager.put("ogg", "audio/ogg");
            MimeManager.put("ogx", "application/ogg");
            MimeManager.put("oga", "audio/ogg");
            MimeManager.put("ogv", "video/ogg");
            MimeManager.put("spx", "audio/ogg");
            MimeManager.put("flac", "application/flac");
            MimeManager.put("anx", "application/annodex");
            MimeManager.put("axa", "audio/annodex");
            MimeManager.put("axv", "video/annodex");
            MimeManager.put("xspf", "application/xspf+xml ");
            MimeManager.put("asf", "video/x-ms-asf");
            MimeManager.put("asx", "video/x-ms-asf");
            MimeManager.put("wma", "audio/x-ms-wma");
            MimeManager.put("wax", "audio/x-ms-wax");
            MimeManager.put("wmv", "video/x-ms-wmv");
            MimeManager.put("wvx", "video/x-ms-wvx");
            MimeManager.put("wm", "video/x-ms-wm");
            MimeManager.put("wmx", "video/x-ms-wmx");
            MimeManager.put("wmz", "application/x-ms-wmz");
            MimeManager.put("wmd", "application/x-ms-wmd");
            MimeManager.put("mpeg4", "video/mpeg");
            MimeManager.put("mp4", "video/mpeg");
            MimeManager.put("3gp", "video/3gpp");
            MimeManager.put("3g2", "video/3gpp");
            MimeManager.put("m2v", "video/mp2p");
            MimeManager.put("flv", "video/x-flv");
        }
    }
}

