/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.sun.media.format.WavAudioFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.pim.PlugInManager;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.utility.OSUtils;
import net.sf.fmj.utility.PlugInUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryDefaults {
    public static final int JMF = 1;
    public static final int FMJ = 2;
    public static final int THIRD_PARTY = 4;
    public static final int ALL = 7;

    public static void registerAll(int flags) {
        RegistryDefaults.registerProtocolPrefixList(flags);
        RegistryDefaults.registerContentPrefixList(flags);
        RegistryDefaults.registerPlugins(flags);
    }

    public static void unRegisterAll(int flags) {
        RegistryDefaults.unRegisterProtocolPrefixList(flags);
        RegistryDefaults.unRegisterContentPrefixList(flags);
        RegistryDefaults.unRegisterPlugins(flags);
    }

    public static void registerProtocolPrefixList(int flags) {
        Vector v = PackageManager.getProtocolPrefixList();
        List<String> add = RegistryDefaults.protocolPrefixList(flags);
        for (String s : add) {
            if (v.contains(s)) continue;
            v.add(s);
        }
        PackageManager.setProtocolPrefixList(v);
    }

    public static void registerContentPrefixList(int flags) {
        Vector v = PackageManager.getContentPrefixList();
        List<String> add = RegistryDefaults.contentPrefixList(flags);
        for (String s : add) {
            if (v.contains(s)) continue;
            v.add(s);
        }
        PackageManager.setContentPrefixList(v);
    }

    public static void unRegisterProtocolPrefixList(int flags) {
        Vector v = PackageManager.getProtocolPrefixList();
        List<String> add = RegistryDefaults.protocolPrefixList(flags);
        for (String s : add) {
            if (!v.contains(s)) continue;
            v.remove(s);
        }
        PackageManager.setProtocolPrefixList(v);
    }

    public static void unRegisterContentPrefixList(int flags) {
        Vector v = PackageManager.getContentPrefixList();
        List<String> add = RegistryDefaults.contentPrefixList(flags);
        for (String s : add) {
            if (!v.contains(s)) continue;
            v.remove(s);
        }
        PackageManager.setContentPrefixList(v);
    }

    public static List<String> protocolPrefixList(int flags) {
        ArrayList<String> protocolPrefixList = new ArrayList<String>();
        if ((flags & 1) != 0) {
            protocolPrefixList.add("javax");
            protocolPrefixList.add("com.sun");
            protocolPrefixList.add("com.ibm");
        }
        if ((flags & 2) != 0) {
            if (OSUtils.isMacOSX()) {
                protocolPrefixList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                protocolPrefixList.add("net.sf.fmj.ds");
            }
            if (OSUtils.isLinux()) {
                protocolPrefixList.add("net.sf.fmj.gst");
            }
            protocolPrefixList.add("net.sf.fmj");
        }
        if ((flags & 4) != 0) {
            protocolPrefixList.add("com.omnividea");
        }
        return protocolPrefixList;
    }

    public static List<String> contentPrefixList(int flags) {
        ArrayList<String> contentPrefixList = new ArrayList<String>();
        if ((flags & 1) != 0) {
            contentPrefixList.add("javax");
            contentPrefixList.add("com.sun");
            contentPrefixList.add("com.ibm");
        }
        if ((flags & 2) != 0) {
            if (OSUtils.isMacOSX()) {
                contentPrefixList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                contentPrefixList.add("net.sf.fmj.ds");
            }
            if (OSUtils.isLinux()) {
                contentPrefixList.add("net.sf.fmj.gst");
            }
            contentPrefixList.add("net.sf.fmj");
        }
        if ((flags & 4) != 0) {
            // empty if block
        }
        return contentPrefixList;
    }

    public static void registerPlugins(int flags) {
        if ((flags & 1) != 0) {
            PlugInManager.addPlugIn("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("audio.mpeg"), new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.audio.WavParser", new Format[]{new ContentDescriptor("audio.x_wav")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.audio.AuParser", new Format[]{new ContentDescriptor("audio.basic")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.audio.AiffParser", new Format[]{new ContentDescriptor("audio.x_aiff")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.audio.GsmParser", new Format[]{new ContentDescriptor("audio.x_gsm")}, new Format[0], 1);
        }
        if ((flags & 2) != 0) {
            PlugInManager.addPlugIn("net.sf.fmj.media.parser.RawPushBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1);
        }
        if ((flags & 1) != 0) {
            PlugInManager.addPlugIn("com.sun.media.parser.RawStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.RawBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.RawPullStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.RawPullBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.video.QuicktimeParser", new Format[]{new ContentDescriptor("video.quicktime")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.parser.video.AviParser", new Format[]{new ContentDescriptor("video.x_msvideo")}, new Format[0], 1);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.mpa.JavaDecoder", new Format[]{new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.video.cinepak.JavaDecoder", new Format[]{new VideoFormat("cvid", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.video.h263.JavaDecoder", new Format[]{new VideoFormat("h263", null, -1, Format.byteArray, -1.0f), new VideoFormat("h263/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.video.colorspace.JavaRGBConverter", new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.video.colorspace.JavaRGBToYUV", new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, -1, -1, -1, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, -1, -1)}, new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.PCMToPCM", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.rc.RCModule", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.rc.RateCvrt", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.msadpcm.JavaDecoder", new Format[]{new AudioFormat("msadpcm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ulaw.JavaDecoder", new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.alaw.JavaDecoder", new Format[]{new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.dvi.JavaDecoder", new Format[]{new AudioFormat("dvi/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.g723.JavaDecoder", new Format[]{new AudioFormat("g723", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("g723/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.gsm.JavaDecoder", new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("gsm/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.gsm.JavaDecoder_ms", new Format[]{new AudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ima4.JavaDecoder", new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ima4.JavaDecoder_ms", new Format[]{new AudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ulaw.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.dvi.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("dvi/rtp", -1.0, 4, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.gsm.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.gsm.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ima4.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.ima4.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.ulaw.Packetizer", new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.ulaw.DePacketizer", new Format[]{new AudioFormat("ULAW/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.mpa.Packetizer", new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.audio.mpa.DePacketizer", new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.gsm.Packetizer", new Format[]{new AudioFormat("gsm", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm/rtp", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, 2);
            PlugInManager.addPlugIn("com.ibm.media.codec.audio.g723.Packetizer", new Format[]{new AudioFormat("g723", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("g723/rtp", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, 2);
        }
        if ((flags & 2) != 0) {
            PlugInManager.addPlugIn("net.sf.fmj.media.codec.video.jpeg.Packetizer", new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2);
        }
        if ((flags & 1) != 0) {
            PlugInManager.addPlugIn("com.sun.media.codec.video.jpeg.Packetizer", new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2);
        }
        if ((flags & 2) != 0) {
            PlugInManager.addPlugIn("net.sf.fmj.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)}, 2);
        }
        if ((flags & 1) != 0) {
            PlugInManager.addPlugIn("com.sun.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.video.mpeg.Packetizer", new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2);
            PlugInManager.addPlugIn("com.sun.media.codec.video.mpeg.DePacketizer", new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, 2);
        }
        if ((flags & 1) != 0) {
            PlugInManager.addPlugIn("com.sun.media.renderer.audio.JavaSoundRenderer", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4);
            PlugInManager.addPlugIn("com.sun.media.renderer.audio.SunAudioRenderer", new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4);
            PlugInManager.addPlugIn("com.sun.media.renderer.video.AWTRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4);
            PlugInManager.addPlugIn("com.sun.media.renderer.video.LightWeightRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4);
            PlugInManager.addPlugIn("com.sun.media.renderer.video.JPEGRenderer", new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)}, new Format[0], 4);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.RawBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.RawSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.RTPSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw.rtp")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.audio.GSMMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_gsm")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.audio.MPEGMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.mpeg")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.audio.WAVMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_wav")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.audio.AIFFMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_aiff")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.audio.AUMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.basic")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.video.AVIMux", new Format[0], new Format[]{new FileTypeDescriptor("video.x_msvideo")}, 5);
            PlugInManager.addPlugIn("com.sun.media.multiplexer.video.QuicktimeMux", new Format[0], new Format[]{new FileTypeDescriptor("video.quicktime")}, 5);
        }
        if ((flags & 2) != 0) {
            PlugInUtility.registerPlugIn("net.sf.fmj.media.renderer.video.SimpleSwingRenderer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.renderer.video.SimpleAWTRenderer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.renderer.video.Java2dRenderer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.parser.JavaSoundParser");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.JavaSoundCodec");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.renderer.audio.JavaSoundRenderer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.ulaw.Decoder");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.ulaw.Encoder");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.ulaw.DePacketizer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.ulaw.Packetizer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.RateConverter");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.alaw.Decoder");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.alaw.Encoder");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.alaw.DePacketizer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.audio.alaw.Packetizer");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.video.jpeg.JpegEncoder");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.parser.RawPushBufferParser");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.multiplexer.RTPSyncBufferMux");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.multiplexer.RawBufferMux");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.multiplexer.audio.AIFFMux");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.multiplexer.audio.AUMux");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.multiplexer.audio.WAVMux");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.codec.video.ImageScaler");
            PlugInUtility.registerPlugIn("net.sf.fmj.ffmpeg_java.FFMPEGParser");
            PlugInUtility.registerPlugIn("net.sf.fmj.theora_java.NativeOggParser");
            PlugInUtility.registerPlugIn("net.sf.fmj.theora_java.JavaOggParser");
            PlugInUtility.registerPlugIn("net.sf.fmj.media.parser.MultipartMixedReplaceParser");
            PlugInUtility.registerPlugIn("net.java.sip.communicator.impl.media.codec.audio.speex.JavaEncoder");
            PlugInUtility.registerPlugIn("net.java.sip.communicator.impl.media.codec.audio.speex.JavaDecoder");
            PlugInUtility.registerPlugIn("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaEncoder");
            PlugInUtility.registerPlugIn("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaDecoder");
        }
        if ((flags & 4) != 0) {
            PlugInUtility.registerPlugIn("com.omnividea.media.parser.video.Parser");
            PlugInUtility.registerPlugIn("com.omnividea.media.codec.video.NativeDecoder");
            PlugInUtility.registerPlugIn("com.omnividea.media.codec.audio.NativeDecoder");
            PlugInUtility.registerPlugIn("com.omnividea.media.codec.video.JavaDecoder");
        }
        if ((flags & 2) != 0 && PlugInManager.removePlugIn("com.ibm.media.parser.video.MpegParser", 1)) {
            PlugInManager.addPlugIn("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("video.mpeg")}, new Format[0], 1);
        }
    }

    public static void unRegisterPlugins(int flags) {
        int[] types;
        for (int type : types = new int[]{5, 2, 3, 4, 5}) {
            Vector<String> v = PlugInManager.getPlugInList(null, null, type);
            Iterator<String> i$ = v.iterator();
            while (i$.hasNext()) {
                String o;
                String className = o = i$.next();
                boolean remove = false;
                if ((flags & 1) != 0 && (className.startsWith("com.ibm.") || className.startsWith("com.sun.") || className.startsWith("javax.media."))) {
                    remove = true;
                }
                if ((flags & 2) != 0 && (className.startsWith("net.sf.fmj") || className.startsWith("net.java.sip.communicator.impl.media."))) {
                    remove = true;
                }
                if ((flags & 4) != 0 && className.startsWith("com.omnividea.media.")) {
                    remove = true;
                }
                if (!remove) continue;
                PlugInManager.removePlugIn(className, type);
            }
        }
    }
}

