/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.cdp.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDevicePlugger {
    private static final Logger logger = LoggerSingleton.logger;

    public void addCaptureDevices() {
        try {
            CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
            CaptureSystem system = factory.createCaptureSystem();
            system.init();
            List list = system.getCaptureDeviceInfoList();
            for (int i = 0; i < list.size(); ++i) {
                com.lti.civil.CaptureDeviceInfo civilInfo = (com.lti.civil.CaptureDeviceInfo)list.get(i);
                CaptureDeviceInfo jmfInfo = new CaptureDeviceInfo(civilInfo.getDescription(), new MediaLocator("civil:" + civilInfo.getDeviceID()), new Format[]{new RGBFormat()});
                if (CaptureDeviceManager.getDevice(jmfInfo.getName()) == null) {
                    CaptureDeviceManager.addDevice(jmfInfo);
                    logger.fine("CaptureDevicePlugger: Added " + jmfInfo.getLocator());
                    continue;
                }
                logger.fine("CaptureDevicePlugger: Already present, skipping " + jmfInfo.getLocator());
            }
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
    }
}

