/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.UnsignedUtils;

public class RateConverter
extends AbstractCodec {
    private static final boolean ONLY_CHANGE_1_PARAMETER = false;
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final double[] sampleRateValues = new double[]{8000.0, 11025.0, 22050.0, 44100.0, 48000.0};
    private static final int[] sampleSizesInBits = new int[]{8, 16, 24, 32};
    private static final int[] endianValues = new int[]{1, 0};
    private static final int[] signedValues = new int[]{1, 0};
    private static final int[] channelsValues = new int[]{1, 2};
    private static final boolean TRACE = false;
    private final Averager[] averagers = new Averager[]{new Averager(), new Averager()};

    public String getName() {
        return "Rate Converter";
    }

    public RateConverter() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    }

    public Format[] getSupportedOutputFormats(Format input) {
        int i;
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("LINEAR") || inputCast.getDataType() != null && inputCast.getDataType() != Format.byteArray) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        ArrayList<AudioFormat> resultList = new ArrayList<AudioFormat>();
        double[] sampleRateValues = new double[RateConverter.sampleRateValues.length + 1];
        sampleRateValues[0] = inputCast.getSampleRate();
        for (i = 0; i < RateConverter.sampleRateValues.length; ++i) {
            sampleRateValues[i + 1] = RateConverter.sampleRateValues[i];
        }
        for (i = 0; i < sampleRateValues.length; ++i) {
            double sampleRate = sampleRateValues[i];
            boolean sampleRateChanged = sampleRate != inputCast.getSampleRate();
            for (int j = 0; j < sampleSizesInBits.length; ++j) {
                int sampleSizeInBits = sampleSizesInBits[j];
                boolean sampleSizeInBitsChanged = sampleSizeInBits != inputCast.getSampleSizeInBits();
                for (int k = 0; k < endianValues.length; ++k) {
                    int endian = sampleSizeInBits <= 8 ? inputCast.getEndian() : endianValues[k];
                    boolean endianChanged = sampleSizeInBits > 8 && inputCast.getSampleSizeInBits() > 8 && endian != inputCast.getEndian();
                    for (int m = 0; m < signedValues.length; ++m) {
                        int signed = signedValues[m];
                        boolean signedChanged = signed != inputCast.getSigned();
                        for (int n = 0; n < channelsValues.length; ++n) {
                            AudioFormat f;
                            int channels = channelsValues[n];
                            boolean channelsChanged = channels != inputCast.getChannels();
                            int numChanged = 0;
                            if (sampleRateChanged) {
                                ++numChanged;
                            }
                            if (sampleSizeInBitsChanged) {
                                ++numChanged;
                            }
                            if (endianChanged) {
                                ++numChanged;
                            }
                            if (signedChanged) {
                                ++numChanged;
                            }
                            if (channelsChanged) {
                                ++numChanged;
                            }
                            if (numChanged < 1 || resultList.contains(f = new AudioFormat("LINEAR", sampleRate, sampleSizeInBits, channels, endian, signed, channels * sampleSizeInBits, sampleRate, Format.byteArray))) continue;
                            resultList.add(f);
                        }
                    }
                }
            }
        }
        Format[] result = new Format[resultList.size()];
        for (int i2 = 0; i2 < resultList.size(); ++i2) {
            result[i2] = (Format)resultList.get(i2);
        }
        return result;
    }

    public void open() {
        for (Averager a : this.averagers) {
            a.reset();
        }
    }

    public void close() {
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        if (!inputBuffer.getFormat().equals(this.inputFormat)) {
            throw new RuntimeException("Expected inputBuffer.getFormat().equals(inputFormat): [" + inputBuffer.getFormat() + "] [" + this.inputFormat + "]");
        }
        AudioFormat inputAudioFormat = (AudioFormat)inputBuffer.getFormat();
        AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
        boolean sampleRateChanged = inputAudioFormat.getSampleRate() != outputAudioFormat.getSampleRate();
        boolean sampleSizeInBitsChanged = inputAudioFormat.getSampleSizeInBits() != outputAudioFormat.getSampleSizeInBits();
        boolean endianChanged = outputAudioFormat.getSampleSizeInBits() > 8 && inputAudioFormat.getSampleSizeInBits() > 8 && inputAudioFormat.getEndian() != outputAudioFormat.getEndian();
        boolean signedChanged = inputAudioFormat.getSigned() != outputAudioFormat.getSigned();
        boolean channelsChanged = inputAudioFormat.getChannels() != outputAudioFormat.getChannels();
        int numChanged = 0;
        if (sampleRateChanged) {
            ++numChanged;
        }
        if (sampleSizeInBitsChanged) {
            ++numChanged;
        }
        if (endianChanged) {
            ++numChanged;
        }
        if (signedChanged) {
            ++numChanged;
        }
        if (channelsChanged) {
            ++numChanged;
        }
        if (outputAudioFormat.getSampleSizeInBits() % 8 != 0) {
            throw new RuntimeException("RateConverter only supports output sample sizes that are a multiple of 8: " + outputAudioFormat.getSampleSizeInBits());
        }
        if (inputAudioFormat.getSampleSizeInBits() % 8 != 0) {
            throw new RuntimeException("RateConverter only supports input sample sizes that are a multiple of 8: " + inputAudioFormat.getSampleSizeInBits());
        }
        if (inputAudioFormat.getSampleSizeInBits() > 8 && inputAudioFormat.getEndian() == -1) {
            throw new RuntimeException("RateConverter (input format) requires endian to be specified if sample size in bits is greater than 8");
        }
        if (outputAudioFormat.getSampleSizeInBits() > 8 && outputAudioFormat.getEndian() == -1) {
            throw new RuntimeException("RateConverter (output format) requires endian to be specified if sample size in bits is greater than 8");
        }
        double sampleRateRatio = outputAudioFormat.getSampleRate() / inputAudioFormat.getSampleRate();
        int sampleRateRatioWhole = (int)sampleRateRatio;
        double sampleRateRatioRemainder = sampleRateRatio - (double)sampleRateRatioWhole;
        double sampleRateInverseRatio = inputAudioFormat.getSampleRate() / outputAudioFormat.getSampleRate();
        int sampleRateInverseRatioWhole = (int)sampleRateInverseRatio;
        int sampleRateInverseRatioCeil = (int)Math.ceil(sampleRateInverseRatio);
        double sampleRateAveragingErrorIncrement = ((double)sampleRateInverseRatioCeil - sampleRateInverseRatio) / sampleRateInverseRatio;
        int inputSampleSizeInBytes = inputAudioFormat.getSampleSizeInBits() / 8;
        int inputSamples = inputBuffer.getLength() / inputSampleSizeInBytes;
        int outputSampleSizeInBytes = outputAudioFormat.getSampleSizeInBits() / 8;
        int requiredOutputBufferLength = sampleRateChanged ? (int)((double)(inputSamples * outputSampleSizeInBytes) * Math.ceil(sampleRateRatio)) : (sampleSizeInBitsChanged ? inputSamples * outputSampleSizeInBytes : inputBuffer.getLength());
        boolean stereoToMono = false;
        boolean monoToStereo = false;
        int outputChannelRepeatCount = 1;
        if (channelsChanged) {
            if (inputAudioFormat.getChannels() == 2 && outputAudioFormat.getChannels() == 1) {
                stereoToMono = true;
            } else if (inputAudioFormat.getChannels() == 1 && outputAudioFormat.getChannels() == 2) {
                outputChannelRepeatCount = 2;
                monoToStereo = true;
            } else {
                throw new RuntimeException("Unsupported number of channels");
            }
        }
        if (stereoToMono) {
            requiredOutputBufferLength /= 2;
        } else if (monoToStereo) {
            requiredOutputBufferLength *= 2;
        }
        byte[] outputBufferData = (byte[])outputBuffer.getData();
        if (outputBufferData == null || outputBufferData.length < requiredOutputBufferLength) {
            outputBufferData = new byte[requiredOutputBufferLength];
            outputBuffer.setData(outputBufferData);
        }
        byte[] inputBufferData = (byte[])inputBuffer.getData();
        long outputSignedUnsignedDifference = 1 << outputAudioFormat.getSampleSizeInBits() - 1;
        long outputUnsignedMax = (1 << outputAudioFormat.getSampleSizeInBits()) - 1;
        long inputSignedUnsignedDifference = 1 << inputAudioFormat.getSampleSizeInBits() - 1;
        long inputUnsignedMax = (1 << inputAudioFormat.getSampleSizeInBits()) - 1;
        long inputSignedMax = (1 << inputAudioFormat.getSampleSizeInBits() - 1) - 1;
        long inputSignedMin = (inputSignedMax + 1L) * -1L;
        double accumulatedRateChangeError = 0.0;
        int outputSampleIndex = 0;
        for (int i = 0; i < inputSamples; ++i) {
            boolean doOutput;
            Averager a;
            long inputSampleLongWithSign;
            if (stereoToMono && i % 2 == 1) continue;
            int byteOffsetOfSample = inputBuffer.getOffset() + i * inputSampleSizeInBytes;
            int inputSampleLiteral = RateConverter.getSample(inputBufferData, byteOffsetOfSample, inputSampleSizeInBytes, inputAudioFormat.getEndian());
            long inputSampleLongWithoutSign = UnsignedUtils.uIntToLong(inputSampleLiteral);
            if (inputAudioFormat.getSigned() == 0) {
                inputSampleLongWithSign = inputSampleLongWithoutSign;
            } else if (inputAudioFormat.getSigned() == 1) {
                inputSampleLongWithSign = inputSampleLongWithoutSign > inputSignedMax ? inputSampleLongWithoutSign - inputUnsignedMax - 1L : inputSampleLongWithoutSign;
            } else {
                throw new RuntimeException("input format signed not specified");
            }
            long outputSampleLongWithSign = outputAudioFormat.getSigned() == 1 && inputAudioFormat.getSigned() == 0 ? inputSampleLongWithSign - inputSignedUnsignedDifference : (outputAudioFormat.getSigned() == 0 && inputAudioFormat.getSigned() == 1 ? inputSampleLongWithSign + inputSignedUnsignedDifference : inputSampleLongWithSign);
            if (sampleRateRatio == 1.0) {
                long outputSampleLongWithoutSign = RateConverter.getOutputSampleLongWithoutSign(outputSampleLongWithSign, inputUnsignedMax, inputAudioFormat, outputAudioFormat);
                for (int c = 0; c < outputChannelRepeatCount; ++c) {
                    RateConverter.putSample(outputSampleLongWithoutSign, outputBufferData, outputSampleIndex++ * outputSampleSizeInBytes, outputSampleSizeInBytes, outputAudioFormat.getEndian());
                }
                continue;
            }
            if (sampleRateRatio > 1.0) {
                double[] sampleWeights;
                double sampleWeight;
                int outputChannel = outputAudioFormat.getChannels() == 1 ? 0 : i % 2;
                a = this.averagers[outputChannel];
                if (a.numAccumulatedSamples + 1.0 > 1.0) {
                    sampleWeight = sampleRateInverseRatio - a.numAccumulatedSamples;
                    double sampleWeight2 = 1.0 - sampleWeight;
                    sampleWeights = new double[]{sampleWeight, sampleWeight2};
                } else {
                    sampleWeight = 1.0;
                    sampleWeights = new double[]{1.0};
                }
                for (double sampleWeight2 : sampleWeights) {
                    a.accumulatedSample += (double)outputSampleLongWithSign * sampleWeight2;
                    a.numAccumulatedSamples += sampleWeight2;
                    int repeatCount = (int)(a.numAccumulatedSamples * sampleRateRatio);
                    if (repeatCount <= 0) continue;
                    long outputSampleLongWithSignAvg = Math.round(a.accumulatedSample / a.numAccumulatedSamples);
                    long outputSampleLongWithoutSign = RateConverter.getOutputSampleLongWithoutSign(outputSampleLongWithSignAvg, inputUnsignedMax, inputAudioFormat, outputAudioFormat);
                    for (int j = 0; j < repeatCount; ++j) {
                        for (int c = 0; c < outputChannelRepeatCount; ++c) {
                            RateConverter.putSample(outputSampleLongWithoutSign, outputBufferData, outputSampleIndex++ * outputSampleSizeInBytes, outputSampleSizeInBytes, outputAudioFormat.getEndian());
                        }
                        double oldAccumulatedSamples = a.numAccumulatedSamples;
                        a.numAccumulatedSamples -= sampleRateInverseRatio;
                        a.accumulatedSample = a.accumulatedSample * a.numAccumulatedSamples / oldAccumulatedSamples;
                    }
                }
                continue;
            }
            if (!(sampleRateInverseRatio > 1.0)) continue;
            int outputChannel = outputAudioFormat.getChannels() == 1 ? 0 : i % 2;
            a = this.averagers[outputChannel];
            double sampleWeight = (a.numAccumulatedSamples + 1.0) * sampleRateRatio > 1.0 ? sampleRateInverseRatio - a.numAccumulatedSamples : 1.0;
            a.accumulatedSample += (double)outputSampleLongWithSign * sampleWeight;
            a.numAccumulatedSamples += sampleWeight;
            boolean bl = doOutput = a.numAccumulatedSamples * sampleRateRatio >= 1.0;
            if (!doOutput) continue;
            long outputSampleLongWithSignAvg = Math.round(a.accumulatedSample / a.numAccumulatedSamples);
            a.accumulatedSample = (double)outputSampleLongWithSignAvg * (1.0 - sampleWeight);
            a.numAccumulatedSamples = 1.0 - sampleWeight;
            long outputSampleLongWithoutSign = RateConverter.getOutputSampleLongWithoutSign(outputSampleLongWithSignAvg, inputUnsignedMax, inputAudioFormat, outputAudioFormat);
            for (int c = 0; c < outputChannelRepeatCount; ++c) {
                RateConverter.putSample(outputSampleLongWithoutSign, outputBufferData, outputSampleIndex++ * outputSampleSizeInBytes, outputSampleSizeInBytes, outputAudioFormat.getEndian());
            }
        }
        outputBuffer.setLength(outputSampleIndex * outputSampleSizeInBytes);
        outputBuffer.setOffset(0);
        outputBuffer.setFormat(this.outputFormat);
        boolean result = false;
        return 0;
    }

    private double fractional(double d) {
        return d - Math.floor(d);
    }

    private static long getOutputSampleLongWithoutSign(long outputSampleLongWithSign, long inputUnsignedMax, AudioFormat inputAudioFormat, AudioFormat outputAudioFormat) {
        long outputSampleLongWithoutSign = outputSampleLongWithSign >= 0L ? outputSampleLongWithSign : inputUnsignedMax + 1L + outputSampleLongWithSign;
        return RateConverter.getOutputSampleLongWithoutSign(outputSampleLongWithoutSign, inputAudioFormat, outputAudioFormat);
    }

    private static long getOutputSampleLongWithoutSign(long outputSampleLongWithoutSign, AudioFormat inputAudioFormat, AudioFormat outputAudioFormat) {
        if (outputAudioFormat.getSampleSizeInBits() > inputAudioFormat.getSampleSizeInBits()) {
            outputSampleLongWithoutSign <<= outputAudioFormat.getSampleSizeInBits() - inputAudioFormat.getSampleSizeInBits();
        } else if (inputAudioFormat.getSampleSizeInBits() > outputAudioFormat.getSampleSizeInBits()) {
            outputSampleLongWithoutSign >>= inputAudioFormat.getSampleSizeInBits() - outputAudioFormat.getSampleSizeInBits();
        }
        return outputSampleLongWithoutSign;
    }

    private static int getSample(byte[] inputBufferData, int byteOffsetOfSample, int inputSampleSizeInBytes, int inputEndian) {
        int sample = 0;
        for (int j = 0; j < inputSampleSizeInBytes; ++j) {
            int offsetWithinSample = inputEndian == 1 ? j : inputSampleSizeInBytes - 1 - j;
            byte b = inputBufferData[byteOffsetOfSample + offsetWithinSample];
            sample <<= 8;
            sample |= b & 0xFF;
        }
        return sample;
    }

    private static void putSample(long sampleLong, byte[] inputBufferData, int byteOffsetOfSample, int outputSampleSizeInBytes, int outputEndian) {
        int sample = (int)sampleLong;
        for (int j = 0; j < outputSampleSizeInBytes; ++j) {
            int offsetWithinSample = outputEndian == 0 ? j : outputSampleSizeInBytes - 1 - j;
            byte b = (byte)(sample >> 8 * j & 0xFF);
            inputBufferData[byteOffsetOfSample + offsetWithinSample] = b;
            continue;
        }
    }

    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    public Format setOutputFormat(Format arg0) {
        return super.setOutputFormat(arg0);
    }

    private static class Averager {
        public double accumulatedSample = 0.0;
        public double numAccumulatedSamples = 0.0;

        private Averager() {
        }

        public void reset() {
            this.accumulatedSample = 0.0;
            this.numAccumulatedSamples = 0.0;
        }
    }
}

