/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.util.BufferToImage;

public class JpegEncoder
extends AbstractCodec
implements Codec {
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("rgb", null, -1, Format.byteArray, -1.0f), new VideoFormat("rgb", null, -1, Format.intArray, -1.0f)};
    private final Format[] supportedOutputFormats = new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)};
    private BufferToImage bufferToImage;

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat inputCast = (VideoFormat)input;
        Format[] result = new Format[]{new VideoFormat("jpeg", inputCast.getSize(), -1, Format.byteArray, -1.0f)};
        return result;
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }

    public int process(Buffer input, Buffer output) {
        BufferedImage image = (BufferedImage)this.bufferToImage.createImage(input);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
            param.setQuality(0.74f, true);
            JPEGImageEncoder jpeg = JPEGCodec.createJPEGEncoder((OutputStream)os, (JPEGEncodeParam)param);
            jpeg.encode(image);
            os.close();
            byte[] ba = os.toByteArray();
            output.setData(ba);
            output.setOffset(0);
            output.setLength(ba.length);
            return 0;
        }
        catch (IOException e) {
            output.setDiscard(true);
            output.setLength(0);
            return 1;
        }
    }
}

