/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import net.sf.fmj.utility.ByteUtils;

public class JpegRTPHeader {
    public static final int HEADER_SIZE = 8;
    private final byte typeSpecific;
    private final int fragmentOffset;
    private final byte type;
    private final byte q;
    private final byte width;
    private final byte height;
    private static final int BITS_PER_BYTE = 8;
    private static final int MAX_SIGNED_BYTE = 127;
    private static final int MAX_BYTE = 255;
    private static final int MAX_BYTE_PLUS1 = 256;

    public JpegRTPHeader(byte typeSpecific, int fragmentOffset, byte type, byte q, byte width, byte height) {
        this.typeSpecific = typeSpecific;
        this.fragmentOffset = fragmentOffset;
        this.type = type;
        this.q = q;
        this.width = width;
        this.height = height;
    }

    public static JpegRTPHeader parse(byte[] data, int offset) {
        int i = offset;
        byte typeSpecific = data[i++];
        int fragmentOffset = 0;
        for (int j = 0; j < 3; ++j) {
            fragmentOffset <<= 8;
            fragmentOffset += data[i++] & 0xFF;
        }
        byte type = data[i++];
        byte q = data[i++];
        byte width = data[i++];
        byte height = data[i++];
        return new JpegRTPHeader(typeSpecific, fragmentOffset, type, q, width, height);
    }

    public byte[] toBytes() {
        byte[] data = new byte[8];
        int i = 0;
        data[i++] = this.typeSpecific;
        JpegRTPHeader.encode3ByteIntBE(this.fragmentOffset, data, i);
        i += 3;
        data[i++] = this.type;
        data[i++] = this.q;
        data[i++] = this.width;
        data[i++] = this.height;
        return data;
    }

    private static void encode3ByteIntBE(int value, byte[] ba, int offset) {
        int length = 3;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + (length - i - 1)] = (byte)byteValue;
            value >>= 8;
        }
    }

    public int getWidthInPixels() {
        return ByteUtils.uByteToInt(this.width) * 8;
    }

    public int getHeightInPixels() {
        return ByteUtils.uByteToInt(this.height) * 8;
    }

    public int getWidthInBlocks() {
        return ByteUtils.uByteToInt(this.width);
    }

    public int getHeightInBlocks() {
        return ByteUtils.uByteToInt(this.height);
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public int getQ() {
        return ByteUtils.uByteToInt(this.q);
    }

    public int getType() {
        return ByteUtils.uByteToInt(this.type);
    }

    public int getTypeSpecific() {
        return ByteUtils.uByteToInt(this.typeSpecific);
    }

    public String toString() {
        return "typeSpecific=" + this.getTypeSpecific() + " fragmentOffset=" + this.getFragmentOffset() + " type=" + this.getType() + " q=" + this.getQ() + " w=" + this.getWidthInPixels() + " h=" + this.getHeightInPixels();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JpegRTPHeader)) {
            return false;
        }
        JpegRTPHeader oCast = (JpegRTPHeader)o;
        return this.typeSpecific == oCast.typeSpecific && this.fragmentOffset == oCast.fragmentOffset && this.type == oCast.type && this.q == oCast.q && this.width == oCast.width && this.height == oCast.height;
    }

    public int hashCode() {
        return this.typeSpecific + this.fragmentOffset + this.type + this.q + this.width + this.height;
    }
}

