/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;

public class Packetizer
extends AbstractPacketizer {
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f)};
    private final Format[] supportedOutputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private static final int PACKET_SIZE = 1000;

    public String getName() {
        return "JPEG/RTP Packetizer";
    }

    public Packetizer() {
        this.inputFormats = this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat inputCast = (VideoFormat)input;
        Format[] result = new Format[]{new VideoFormat("jpeg/rtp", inputCast.getSize(), -1, Format.byteArray, -1.0f)};
        return result;
    }

    public void open() {
        this.setPacketSize(1000);
        this.setDoNotSpanInputBuffers(true);
    }

    public void close() {
    }

    protected int doBuildPacketHeader(Buffer inputBuffer, byte[] packetBuffer) {
        VideoFormat format = (VideoFormat)this.inputFormat;
        int width = format.getSize().width;
        int height = format.getSize().height;
        byte typeSpecific = 0;
        byte type = 0;
        byte q = 0;
        byte widthInBlocks = (byte)(width / 8);
        byte heightInBlocks = (byte)(height / 8);
        JpegRTPHeader jpegRTPHeader = new JpegRTPHeader(typeSpecific, inputBuffer.getOffset(), type, q, widthInBlocks, heightInBlocks);
        byte[] bytes = jpegRTPHeader.toBytes();
        System.arraycopy(bytes, 0, packetBuffer, 0, bytes.length);
        return bytes.length;
    }

    public int process(Buffer input, Buffer output) {
        int result = super.process(input, output);
        if (result == 0) {
            output.setFlags(output.getFlags() | 0x800);
        }
        return result;
    }
}

