/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

public class RFC2035 {
    private static final int[] jpeg_luma_quantizer = new int[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
    private static final int[] jpeg_chroma_quantizer = new int[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final byte[] lum_dc_codelens = new byte[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] lum_dc_symbols = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] lum_ac_codelens = new byte[]{0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final byte[] lum_ac_symbols = new byte[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    private static final byte[] chm_dc_codelens = new byte[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] chm_dc_symbols = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] chm_ac_codelens = new byte[]{0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final byte[] chm_ac_symbols = new byte[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};

    private static void MakeTables(int q, byte[] lum_q, byte[] chr_q) {
        int factor = q;
        if (q < 1) {
            factor = 1;
        }
        if (q > 99) {
            factor = 99;
        }
        q = q < 50 ? 5000 / factor : 200 - factor * 2;
        for (int i = 0; i < 64; ++i) {
            int lq = (jpeg_luma_quantizer[i] * q + 50) / 100;
            int cq = (jpeg_chroma_quantizer[i] * q + 50) / 100;
            if (lq < 1) {
                lq = 1;
            } else if (lq > 255) {
                lq = 255;
            }
            lum_q[i] = (byte)lq;
            if (cq < 1) {
                cq = 1;
            } else if (cq > 255) {
                cq = 255;
            }
            chr_q[i] = (byte)cq;
        }
    }

    private static int MakeQuantHeader(byte[] p, int i, byte[] qt, int tableNo) {
        p[i++] = -1;
        p[i++] = -37;
        p[i++] = 0;
        p[i++] = 67;
        p[i++] = (byte)tableNo;
        System.arraycopy(qt, 0, p, i, 64);
        return i += 64;
    }

    private static int MakeHuffmanHeader(byte[] p, int i, byte[] codelens, int ncodes, byte[] symbols, int nsymbols, int tableNo, int tableClass) {
        p[i++] = -1;
        p[i++] = -60;
        p[i++] = 0;
        p[i++] = (byte)(3 + ncodes + nsymbols);
        p[i++] = (byte)(tableClass << 4 | tableNo);
        System.arraycopy(codelens, 0, p, i, ncodes);
        System.arraycopy(symbols, 0, p, i += ncodes, nsymbols);
        return i += nsymbols;
    }

    public static int MakeHeaders(boolean includeSOI, byte[] p, int i, int type, int q, int w, int h) {
        byte[] lqt = new byte[64];
        byte[] cqt = new byte[64];
        w <<= 3;
        h <<= 3;
        RFC2035.MakeTables(q, lqt, cqt);
        if (includeSOI) {
            p[i++] = -1;
            p[i++] = -40;
        }
        i = RFC2035.MakeQuantHeader(p, i, lqt, 0);
        i = RFC2035.MakeQuantHeader(p, i, cqt, 1);
        i = RFC2035.MakeHuffmanHeader(p, i, lum_dc_codelens, lum_dc_codelens.length, lum_dc_symbols, lum_dc_symbols.length, 0, 0);
        i = RFC2035.MakeHuffmanHeader(p, i, lum_ac_codelens, lum_ac_codelens.length, lum_ac_symbols, lum_ac_symbols.length, 0, 1);
        i = RFC2035.MakeHuffmanHeader(p, i, chm_dc_codelens, chm_dc_codelens.length, chm_dc_symbols, chm_dc_symbols.length, 1, 0);
        i = RFC2035.MakeHuffmanHeader(p, i, chm_ac_codelens, chm_ac_codelens.length, chm_ac_symbols, chm_ac_symbols.length, 1, 1);
        p[i++] = -1;
        p[i++] = -64;
        p[i++] = 0;
        p[i++] = 17;
        p[i++] = 8;
        p[i++] = (byte)(h >> 8);
        p[i++] = (byte)h;
        p[i++] = (byte)(w >> 8);
        p[i++] = (byte)w;
        p[i++] = 3;
        p[i++] = 0;
        p[i++] = type == 0 ? 33 : 34;
        p[i++] = 0;
        p[i++] = 1;
        p[i++] = 17;
        p[i++] = 1;
        p[i++] = 2;
        p[i++] = 17;
        p[i++] = 1;
        p[i++] = -1;
        p[i++] = -38;
        p[i++] = 0;
        p[i++] = 12;
        p[i++] = 3;
        p[i++] = 0;
        p[i++] = 0;
        p[i++] = 1;
        p[i++] = 17;
        p[i++] = 2;
        p[i++] = 17;
        p[i++] = 0;
        p[i++] = 63;
        p[i++] = 0;
        return i;
    }
}

