/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.content.unknown;

import com.lti.utils.synchronization.CloseableThread;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.StandardControlPanel;
import net.sf.fmj.filtergraph.DemuxNode;
import net.sf.fmj.filtergraph.FilterGraph;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.filtergraph.MuxNode;
import net.sf.fmj.filtergraph.RendererNode;
import net.sf.fmj.media.AbstractProcessor;
import net.sf.fmj.utility.LoggerSingleton;

public class Handler
extends AbstractProcessor {
    protected static final int PLAYER = 1;
    protected static final int PROCESSOR = 2;
    private final int mode;
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private Time duration;
    private Component visualComponent;
    private TrackThread[] trackThreads;
    private static final boolean TRACE = true;
    private DemuxNode root;
    private Demultiplexer demux;
    private int numTracks;
    private Track[] tracks;
    private Multiplexer mux;
    private Format[] muxInputFormats;
    private Time demuxDuration = DURATION_UNKNOWN;
    private boolean demuxOpenedAndStarted;
    private boolean firstStart = true;
    private TrackControl[] trackControls;

    public Handler() {
        this(1);
    }

    public Handler(int mode) {
        this.mode = mode;
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        this.demux = FilterGraph.getSourceCompatibleDemultiplexer(source);
        if (this.demux == null) {
            throw new IncompatibleSourceException("Unable to build filter graph for: " + source);
        }
        this.demuxDuration = this.demux.getDuration();
        super.setSource(source);
    }

    private boolean getDemuxTracks() {
        if (this.tracks != null) {
            return true;
        }
        try {
            if (!this.openAndStartDemux()) {
                return false;
            }
            this.tracks = this.demux.getTracks();
            this.numTracks = this.tracks.length;
        }
        catch (BadHeaderException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        return true;
    }

    private boolean openAndStartDemux() {
        if (this.demuxOpenedAndStarted) {
            return true;
        }
        try {
            this.demux.open();
            this.demux.start();
            this.demuxOpenedAndStarted = true;
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            try {
                this.closeDemux();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
            }
            return false;
        }
    }

    private void closeDemux() {
        if (this.demux != null) {
            this.demux.close();
        }
        this.demuxOpenedAndStarted = false;
    }

    public void doPlayerClose() {
        this.closeDemux();
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    private int getVideoTrackIndex() {
        int trackIndex = -1;
        for (int i = 0; i < this.root.getTracks().length; ++i) {
            if (!(this.root.getTracks()[i].getFormat() instanceof VideoFormat)) continue;
            trackIndex = i;
            break;
        }
        return trackIndex;
    }

    private int getAudioTrackIndex() {
        int trackIndex = -1;
        for (int i = 0; i < this.root.getTracks().length; ++i) {
            if (!(this.root.getTracks()[i].getFormat() instanceof AudioFormat)) continue;
            trackIndex = i;
            break;
        }
        return trackIndex;
    }

    public boolean doPlayerRealize() {
        GainControl gainControl;
        Renderer renderer;
        RendererNode rendererNode;
        RendererNode rendererNode2;
        try {
            if (!this.openAndStartDemux()) {
                this.postControllerErrorEvent("Failed to openAndStartDemux");
                return false;
            }
            if (this.mode == 1) {
                this.root = FilterGraph.buildGraphToRenderer(new ContentDescriptor(this.getSource().getContentType()), this.demux);
            } else {
                this.buildMux();
                int muxTrack = 0;
                this.root = FilterGraph.buildGraphToMux(new ContentDescriptor(this.getSource().getContentType()), this.demux, this.mux, this.muxInputFormats[muxTrack], muxTrack);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            this.closeDemux();
            this.postControllerErrorEvent("" + e);
            return false;
        }
        if (this.root == null) {
            logger.fine("unable to find a filter graph to connect from demux to renderer/mux");
            this.closeDemux();
            this.postControllerErrorEvent("unable to find a filter graph to connect from demux to renderer/mux");
            return false;
        }
        logger.fine("Filter graph:");
        FilterGraph.print(this.root, 1);
        int videoTrackIndex = this.getVideoTrackIndex();
        if (this.mode == 1 && videoTrackIndex >= 0 && (rendererNode2 = (RendererNode)FilterGraph.getTail(this.root.getDestLink(videoTrackIndex).getDestNode())) != null) {
            VideoRenderer videoRenderer = (VideoRenderer)rendererNode2.getRenderer();
            VideoFormat videoRendererInputFormat = (VideoFormat)rendererNode2.getInputFormat();
            this.visualComponent = videoRenderer.getComponent();
            this.visualComponent.setSize(videoRendererInputFormat.getSize());
            videoRenderer.setBounds(new Rectangle(videoRendererInputFormat.getSize()));
        }
        int audioTrackIndex = this.getAudioTrackIndex();
        if (this.mode == 1 && audioTrackIndex >= 0 && (rendererNode = (RendererNode)FilterGraph.getTail(this.root.getDestLink(audioTrackIndex).getDestNode())) != null && (renderer = rendererNode.getRenderer()) instanceof Clock) {
            Clock rendererAsClock = (Clock)((Object)renderer);
            try {
                TimeBase timeBase = rendererAsClock.getTimeBase();
                rendererAsClock.setTimeBase(timeBase);
            }
            catch (IncompatibleTimeBaseException e) {
                logger.log(Level.WARNING, "" + e, e);
                this.postControllerErrorEvent("" + e);
                return false;
            }
        }
        try {
            for (int i = 0; i < this.root.getNumDestLinks(); ++i) {
                FilterGraphLink link = this.root.getDestLink(i);
                if (link == null) continue;
                FilterGraph.open(link.getDestNode());
            }
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        if (this.mode == 1 && audioTrackIndex >= 0 && (rendererNode = (RendererNode)FilterGraph.getTail(this.root.getDestLink(audioTrackIndex).getDestNode())) != null && (gainControl = (GainControl)(renderer = rendererNode.getRenderer()).getControl(GainControl.class.getName())) != null) {
            this.setGainControl(gainControl);
        }
        logger.fine("Starting filter graph(s)");
        try {
            FilterGraph.start(this.root);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        this.trackThreads = new TrackThread[this.root.getNumDestLinks()];
        for (int i = 0; i < this.root.getNumDestLinks(); ++i) {
            if (this.root.getDestLink(i) == null) continue;
            DemuxNode rootCopy = (DemuxNode)this.root.duplicate();
            this.trackThreads[i] = new TrackThread(rootCopy, i, videoTrackIndex == i ? 1 : 0);
            if (videoTrackIndex != i) continue;
            FilterGraph.process(rootCopy, null, videoTrackIndex, -1, 0);
        }
        return true;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = new StandardControlPanel(this, 67);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    private void checkAllTracksEOM() {
        for (int i = 0; i < this.trackThreads.length; ++i) {
            if (this.trackThreads[i].isEOM()) continue;
            return;
        }
        try {
            this.endOfMedia();
        }
        catch (ClockStoppedException e) {
            this.postEvent(new InternalErrorEvent(this, "Controller not in Started state at EOM"));
        }
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime" + t);
        this.root.getDemux().setPosition(t, 0);
    }

    public float doPlayerSetRate(float rate) {
        logger.info("Handler.doPlayerSetRate " + rate);
        if (rate == 0.0f) {
            return this.getRate();
        }
        if (rate < 0.0f) {
            return this.getRate();
        }
        return rate;
    }

    public boolean doPlayerStop() {
        logger.info("Handler.doPlayerStop");
        if (this.trackThreads == null) {
            return true;
        }
        ArrayList<TrackThread> waitUntilClosed = new ArrayList<TrackThread>();
        for (int i = 0; i < this.trackThreads.length; ++i) {
            TrackThread t = this.trackThreads[i];
            if (t == null || !t.isAlive()) continue;
            t.close();
            waitUntilClosed.add(t);
        }
        for (TrackThread t : waitUntilClosed) {
            try {
                t.waitUntilClosed();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return false;
            }
        }
        try {
            FilterGraph.stop(this.root);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            this.postControllerErrorEvent("" + e);
            return false;
        }
        return true;
    }

    public boolean doPlayerSyncStart(Time time) {
        int i;
        logger.info("Handler.doPlayerSyncStart " + time + " " + this.getState());
        if (this.firstStart) {
            this.firstStart = false;
        } else {
            logger.fine("Starting filter graph(s)");
            try {
                FilterGraph.start(this.root);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                this.postControllerErrorEvent("" + e);
                return false;
            }
            this.trackThreads = new TrackThread[this.root.getNumDestLinks()];
            for (i = 0; i < this.root.getNumDestLinks(); ++i) {
                if (this.root.getDestLink(i) == null) continue;
                DemuxNode rootCopy = (DemuxNode)this.root.duplicate();
                this.trackThreads[i] = new TrackThread(rootCopy, i, 0);
            }
        }
        for (i = 0; i < this.trackThreads.length; ++i) {
            TrackThread t = this.trackThreads[i];
            if (t == null) continue;
            t.start();
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 200 || this.root == null) {
            logger.fine("getPlayerDuration: returning demuxDuration");
            return this.demuxDuration;
        }
        Time duration = null;
        Track[] tracks = this.root.getTracks();
        for (int i = 0; i < tracks.length; ++i) {
            try {
                Time d = tracks[i].getDuration();
                logger.fine("Track " + i + " has duration of " + d.getNanoseconds());
                if (duration == null) {
                    duration = d;
                    continue;
                }
                if (d == DURATION_UNKNOWN) {
                    duration = d;
                    break;
                }
                if (duration == DURATION_UNBOUNDED || d != DURATION_UNBOUNDED && d.getNanoseconds() <= duration.getNanoseconds()) continue;
                duration = d;
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
        if (duration == null) {
            logger.fine("getPlayerDuration: returning DURATION_UNKNOWN (2)");
            return DURATION_UNKNOWN;
        }
        logger.fine("getPlayerDuration: returning " + duration.getNanoseconds());
        return duration;
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public boolean doConfigure() {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 300) {
            throw new NotRealizedError("Cannot call getDataOutput on an unrealized Processor.");
        }
        MuxNode muxNode = (MuxNode)FilterGraph.getTail(this.root.getDestLink(0).getDestNode());
        return muxNode.getMultiplexer().getDataOutput();
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 180) {
            throw new NotConfiguredError("Cannot call getTrackControls on an unconfigured Processor.");
        }
        if (this.trackControls == null) {
            try {
                if (!this.getDemuxTracks()) {
                    throw new RuntimeException("Unable to get demux tracks");
                }
                Track[] tracks = this.demux.getTracks();
                this.trackControls = new TrackControl[tracks.length];
                for (int trackNum = 0; trackNum < tracks.length; ++trackNum) {
                    this.trackControls[trackNum] = new MyTrackControl(trackNum);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (BadHeaderException e) {
                throw new RuntimeException(e);
            }
        }
        return this.trackControls;
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        if (this.mode == 1) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() < 180) {
            throw new NotConfiguredError("Cannot call getSupportedContentDescriptors on an unconfigured Processor.");
        }
        List muxs = FilterGraph.findMuxs();
        ArrayList<ContentDescriptor> result = new ArrayList<ContentDescriptor>();
        for (int i = 0; i < muxs.size(); ++i) {
            Multiplexer mux = (Multiplexer)muxs.get(i);
            ContentDescriptor[] f = mux.getSupportedOutputContentDescriptors(null);
            for (int j = 0; j < f.length; ++j) {
                result.add(f[j]);
            }
        }
        ContentDescriptor[] arrayResult = new ContentDescriptor[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            arrayResult[i] = (ContentDescriptor)result.get(i);
        }
        return arrayResult;
    }

    private void buildMux() {
        if (this.mux != null) {
            return;
        }
        if (!this.getDemuxTracks()) {
            throw new RuntimeException("Unable to get demux tracks");
        }
        this.mux = FilterGraph.findMux(this.outputContentDescriptor);
        if (this.mux == null) {
            throw new RuntimeException("Unable to find mux for " + this.outputContentDescriptor);
        }
        this.mux.setNumTracks(this.numTracks);
        this.mux.setContentDescriptor(this.outputContentDescriptor);
        this.muxInputFormats = new Format[this.numTracks];
        for (int i = 0; i < this.numTracks; ++i) {
            this.muxInputFormats[i] = this.mux.setInputFormat(this.tracks[i].getFormat(), i);
        }
    }

    static /* synthetic */ void access$000(Handler x0) {
        x0.checkAllTracksEOM();
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ void access$200(Handler x0, String x1) {
        x0.postControllerErrorEvent(x1);
    }

    private class MyTrackControl
    implements TrackControl {
        private final int trackNum;
        private boolean enabled = true;

        public MyTrackControl(int trackNum) {
            this.trackNum = trackNum;
        }

        public void setCodecChain(Codec[] codecs) throws UnsupportedPlugInException, NotConfiguredError {
        }

        public void setRenderer(Renderer renderer) throws UnsupportedPlugInException, NotConfiguredError {
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            if (!Handler.this.getDemuxTracks()) {
                throw new RuntimeException("Unable to get demux tracks");
            }
            if (Handler.this.muxInputFormats == null) {
                return Handler.this.tracks[this.trackNum].getFormat();
            }
            return Handler.this.muxInputFormats[this.trackNum];
        }

        public Format[] getSupportedFormats() {
            Handler.this.buildMux();
            return Handler.this.mux.getSupportedInputFormats();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Format setFormat(Format format) {
            Handler.this.buildMux();
            ((Handler)Handler.this).muxInputFormats[this.trackNum] = Handler.this.mux.setInputFormat(format, this.trackNum);
            return Handler.this.muxInputFormats[this.trackNum];
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class TrackThread
    extends CloseableThread {
        private final int trackNumber;
        private final DemuxNode root;
        private final int firstFlags;
        private long nanoseconds;
        private boolean eom = false;

        public TrackThread(DemuxNode root, int trackNumber, int firstFlags) {
            this.setName("TrackThread for track " + trackNumber);
            this.root = root;
            this.trackNumber = trackNumber;
            this.firstFlags = firstFlags;
        }

        public void close() {
            this.setClosing();
        }

        private Buffer readAndProcessNextFrame(int flags) {
            FilterGraph.process(this.root, null, this.trackNumber, -1, flags);
            Buffer b = this.root.getOutputBuffer(this.trackNumber);
            if (b == null) {
                throw new NullPointerException();
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                try {
                    rate = Handler.this.getRate();
                    try {
                        penultimateNode = FilterGraph.getBeforeTail(this.root.getDestLink(this.trackNumber).getDestNode());
                        first = true;
                        inputEOM = false;
lbl7:
                        // 4 sources

                        while (true) {
                            if (this.isClosing()) {
                                break;
                            }
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    catch (Exception e) {
                        Handler.access$100().log(Level.WARNING, "" + e, e);
                        Handler.access$200(Handler.this, "" + e);
                        break block13;
                    }
                }
                catch (Throwable var7_8) {
                    this.setClosed();
                    throw var7_8;
                }
                this.setClosed();
                return;
lbl-1000:
                // 1 sources

                {
                    flags = first != false ? this.firstFlags : (inputEOM != false ? 1 : 0);
                    b = this.readAndProcessNextFrame(flags);
                    if (!this.isClosing()) ** GOTO lbl-1000
                }
                this.setClosed();
                return;
lbl-1000:
                // 1 sources

                {
                    if (first) {
                        first = false;
                    }
                    if (b.isEOM()) {
                        inputEOM = true;
                    }
                    if (b.isDiscard() || !(penultimateNode instanceof RendererNode) && !(penultimateNode instanceof MuxNode) && (b = penultimateNode.getOutputBuffer(0)) == null) ** GOTO lbl7
                    if (b.isEOM()) {
                        this.eom = true;
                        Handler.access$000(Handler.this);
                        break block13;
                    }
                    if (b.isDiscard()) ** GOTO lbl7
                    this.nanoseconds = b.getTimeStamp();
                    ** continue;
                }
            }
            this.setClosed();
        }

        public boolean isEOM() {
            return this.eom;
        }
    }
}

