/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.AbstractMultiplexer;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class RawBufferMux
extends AbstractMultiplexer {
    private final boolean TRACE = false;
    private static final Logger logger = LoggerSingleton.logger;
    private RawBufferDataSource dataOutput;
    private ProducerConsumerQueue[] queues;
    private RawBufferSourceStream[] streams;
    private final ContentDescriptor contentDescriptor;

    protected RawBufferMux(ContentDescriptor contentDescriptor) {
        this.contentDescriptor = contentDescriptor;
    }

    public RawBufferMux() {
        this(new ContentDescriptor("raw"));
    }

    public DataSource getDataOutput() {
        if (this.dataOutput == null) {
            this.dataOutput = new RawBufferDataSource();
        }
        return this.dataOutput;
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new VideoFormat(null, null, -1, Format.byteArray, -1.0f)};
    }

    public void close() {
        super.close();
        if (this.dataOutput != null) {
            try {
                this.dataOutput.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.dataOutput.disconnect();
        }
    }

    public void open() throws ResourceUnavailableException {
        super.open();
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] inputs) {
        return new ContentDescriptor[]{this.contentDescriptor};
    }

    public int process(Buffer buffer, int trackID) {
        try {
            this.queues[trackID].put((Buffer)buffer.clone());
            if (buffer.isEOM()) {
                logger.fine("EOM, finished");
            }
            if (this.dataOutput != null) {
                this.dataOutput.notifyDataAvailable(trackID);
            }
            return 0;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int setNumTracks(int numTracks) {
        int track;
        numTracks = super.setNumTracks(numTracks);
        this.queues = new ProducerConsumerQueue[numTracks];
        for (track = 0; track < numTracks; ++track) {
            this.queues[track] = new ProducerConsumerQueue();
        }
        this.streams = new RawBufferSourceStream[numTracks];
        for (track = 0; track < numTracks; ++track) {
            this.streams[track] = new RawBufferSourceStream(this.queues[track]);
        }
        return numTracks;
    }

    public Format setInputFormat(Format format, int trackID) {
        if (this.streams != null) {
            this.streams[trackID].setFormat(format);
        }
        return super.setInputFormat(format, trackID);
    }

    private class RawBufferSourceStream
    implements PushBufferStream {
        private final ProducerConsumerQueue queue;
        private boolean eos;
        private Format format;
        private BufferTransferHandler transferHandler;

        public RawBufferSourceStream(ProducerConsumerQueue queue) {
            this.queue = queue;
        }

        public boolean endOfStream() {
            return this.eos;
        }

        public ContentDescriptor getContentDescriptor() {
            return RawBufferMux.this.outputContentDescriptor;
        }

        public long getContentLength() {
            return 0L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        void setFormat(Format f) {
            this.format = f;
        }

        public Format getFormat() {
            return this.format;
        }

        public void read(Buffer buffer) throws IOException {
            try {
                Buffer next = (Buffer)this.queue.get();
                if (next == null || next.isEOM()) {
                    this.eos = true;
                }
                if (next != null) {
                    if (buffer.getData() == null) {
                        buffer.copy(next, false);
                    } else {
                        Object originalData = buffer.getData();
                        int originalOffset = buffer.getOffset();
                        int originalLength = buffer.getLength();
                        buffer.copy(next, false);
                        buffer.setData(originalData);
                        buffer.setOffset(originalOffset);
                        if (next.getLength() > 0) {
                            if (next.getLength() > originalLength) {
                                throw new IllegalArgumentException("Buffer passed in has length: " + buffer.getLength() + "; needs to be at least: " + next.getLength());
                            }
                            System.arraycopy(next.getData(), next.getOffset(), originalData, originalOffset, next.getLength());
                        }
                    }
                } else {
                    System.out.println("RawBufferMux EOS");
                    System.out.flush();
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    buffer.setOffset(0);
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.transferHandler = transferHandler;
        }

        public void notifyDataAvailable() {
            if (this.transferHandler != null) {
                this.transferHandler.transferData(this);
            }
        }
    }

    private class RawBufferDataSource
    extends PushBufferDataSource {
        private RawBufferDataSource() {
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        public void connect() throws IOException {
        }

        public void disconnect() {
        }

        public String getContentType() {
            return RawBufferMux.this.outputContentDescriptor.getContentType();
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public void notifyDataAvailable(int track) {
            RawBufferMux.this.streams[track].notifyDataAvailable();
        }
    }
}

