/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import com.lti.utils.synchronization.CloseableThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import net.sf.fmj.media.multiplexer.InputStreamPushSourceStream;
import net.sf.fmj.media.multiplexer.StreamPipe;
import net.sf.fmj.utility.IOUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class StreamCopyPushDataSource
extends PushDataSource {
    private static final Logger logger = LoggerSingleton.logger;
    private final ContentDescriptor outputContentDescriptor;
    private final int numTracks;
    private final InputStream[] inputStreams;
    private final Format[] inputFormats;
    private InputStreamPushSourceStream[] pushSourceStreams;
    private WriterThread[] writerThreads;

    public StreamCopyPushDataSource(ContentDescriptor outputContentDescriptor, int numTracks, InputStream[] inputStreams, Format[] inputFormats) {
        this.outputContentDescriptor = outputContentDescriptor;
        this.numTracks = numTracks;
        this.inputStreams = inputStreams;
        this.inputFormats = inputFormats;
    }

    public PushSourceStream[] getStreams() {
        System.out.println(this.getClass().getSimpleName() + " getStreams");
        return this.pushSourceStreams;
    }

    public void connect() throws IOException {
        System.out.println(this.getClass().getSimpleName() + " connect");
        this.pushSourceStreams = new InputStreamPushSourceStream[this.numTracks];
        this.writerThreads = new WriterThread[this.numTracks];
        for (int track = 0; track < this.numTracks; ++track) {
            StreamPipe p = new StreamPipe();
            this.pushSourceStreams[track] = new InputStreamPushSourceStream(this.outputContentDescriptor, p.getInputStream());
            this.writerThreads[track] = new WriterThread(track, this.inputStreams[track], p.getOutputStream(), this.inputFormats[track]);
        }
    }

    public void notifyDataAvailable(int track) {
        this.pushSourceStreams[track].notifyDataAvailable();
    }

    public void disconnect() {
        System.out.println(this.getClass().getSimpleName() + " disconnect");
    }

    public String getContentType() {
        System.out.println(this.getClass().getSimpleName() + " getContentType");
        return this.outputContentDescriptor.getContentType();
    }

    public Object getControl(String controlType) {
        System.out.println(this.getClass().getSimpleName() + " getControl");
        return null;
    }

    public Object[] getControls() {
        System.out.println(this.getClass().getSimpleName() + " getControls");
        return new Object[0];
    }

    public Time getDuration() {
        System.out.println(this.getClass().getSimpleName() + " getDuration");
        return Time.TIME_UNKNOWN;
    }

    public void start() throws IOException {
        System.out.println(this.getClass().getSimpleName() + " start");
        for (int track = 0; track < this.numTracks; ++track) {
            this.writerThreads[track].start();
        }
    }

    public void stop() throws IOException {
        int track;
        System.out.println(this.getClass().getSimpleName() + " stop");
        for (track = 0; track < this.numTracks; ++track) {
            this.writerThreads[track].close();
        }
        try {
            for (track = 0; track < this.numTracks; ++track) {
                this.writerThreads[track].waitUntilClosed();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public void waitUntilFinished() throws InterruptedException {
        for (int track = 0; track < this.numTracks; ++track) {
            this.writerThreads[track].waitUntilClosed();
        }
    }

    protected void write(InputStream in, OutputStream out, int track) throws IOException {
        IOUtils.copyStream(in, out);
    }

    private class WriterThread
    extends CloseableThread {
        private final int trackID;
        private final InputStream in;
        private final OutputStream out;
        private Format format;

        public WriterThread(int trackID, InputStream in, OutputStream out, Format format) {
            this.trackID = trackID;
            this.in = in;
            this.out = out;
            this.format = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                StreamCopyPushDataSource.this.write(this.in, this.out, this.trackID);
                this.out.close();
            }
            catch (InterruptedIOException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            finally {
                this.setClosed();
            }
        }
    }
}

