/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sf.fmj.media.multiplexer.AbstractStreamCopyMux;
import net.sf.fmj.media.multiplexer.StreamCopyPushDataSource;
import net.sf.fmj.media.renderer.audio.JavaSoundRenderer;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class JavaSoundMux
extends AbstractStreamCopyMux {
    private static final Logger logger = LoggerSingleton.logger;
    private final AudioFileFormat.Type audioFileFormatType;

    public JavaSoundMux(FileTypeDescriptor fileTypeDescriptor, AudioFileFormat.Type audioFileFormatType) {
        super(fileTypeDescriptor);
        this.audioFileFormatType = audioFileFormatType;
    }

    protected StreamCopyPushDataSource createInputStreamPushDataSource(ContentDescriptor outputContentDescriptor, int numTracks, InputStream[] inputStreams, Format[] inputFormats) {
        return new MyPushDataSource(outputContentDescriptor, numTracks, inputStreams, inputFormats);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR")};
    }

    protected void write(InputStream in, OutputStream out, javax.sound.sampled.AudioFormat javaSoundFormat) throws IOException {
        long lengthInFrames = Integer.MAX_VALUE;
        AudioInputStream ais = new AudioInputStream(in, javaSoundFormat, Integer.MAX_VALUE);
        AudioFileFormat.Type targetFileFormatType = this.audioFileFormatType;
        AudioSystem.write(ais, targetFileFormatType, out);
    }

    private class MyPushDataSource
    extends StreamCopyPushDataSource {
        final javax.sound.sampled.AudioFormat[] javaSoundFormats;

        public MyPushDataSource(ContentDescriptor outputContentDescriptor, int numTracks, InputStream[] inputStreams, Format[] inputFormats) {
            super(outputContentDescriptor, numTracks, inputStreams, inputFormats);
            this.javaSoundFormats = new javax.sound.sampled.AudioFormat[numTracks];
            for (int track = 0; track < numTracks; ++track) {
                this.javaSoundFormats[track] = JavaSoundRenderer.convertFormat((AudioFormat)inputFormats[track]);
            }
        }

        protected void write(InputStream in, OutputStream out, int track) throws IOException {
            JavaSoundMux.this.write(in, out, this.javaSoundFormats[track]);
        }
    }
}

