/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import com.lti.utils.synchronization.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Track;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class RawPushBufferParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("raw")};
    private PushBufferDataSource source;
    private PushBufferStreamTrack[] tracks;
    private static final boolean USE_BUFFER_TRANSFER_HANDLER = true;
    private static final int POLL_INTERVAL = 1000;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushBufferDataSource)source;
    }

    public void start() throws IOException {
        this.source.start();
        if (this.tracks == null) {
            PushBufferStream[] streams = this.source.getStreams();
            this.tracks = new PushBufferStreamTrack[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                this.tracks[i] = new PushBufferStreamTrack(streams[i]);
            }
        }
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    private class PushBufferStreamTrack
    extends AbstractTrack
    implements BufferTransferHandler {
        private final PushBufferStream stream;
        private SynchronizedBoolean dataAvailable = new SynchronizedBoolean();

        public PushBufferStreamTrack(PushBufferStream stream) {
            this.stream = stream;
            stream.setTransferHandler(this);
        }

        public Format getFormat() {
            return this.stream.getFormat();
        }

        public void transferData(PushBufferStream stream) {
            this.dataAvailable.setValue(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            block8: {
                try {
                    try {
                        SynchronizedBoolean synchronizedBoolean = this.dataAvailable;
                        synchronized (synchronizedBoolean) {
                            this.dataAvailable.waitUntil(true, 1000);
                            this.dataAvailable.setValue(false);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                    this.stream.read(buffer);
                }
                catch (IOException e) {
                    buffer.setEOM(true);
                    buffer.setDiscard(true);
                    buffer.setLength(0);
                    if (e instanceof InterruptedIOException) break block8;
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
        }
    }
}

