/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import com.lti.utils.synchronization.ThreadGroupMgr;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.utility.FPSCounter;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private CaptureSystem system;
    private String deviceId;
    private CaptureStream captureStream;
    private MyPushBufferStream pushBufferStream;
    private VideoFormat outputVideoFormat = null;
    private boolean connected;
    private static final int BUFFER_QUEUE_SIZE = 2;
    private final ProducerConsumerQueue bufferQueue = new ProducerConsumerQueue(2);
    private static final boolean TRACE_FPS = false;
    private static final String CONTENT_TYPE = "raw";
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private boolean enabled = true;

    public void connect() throws IOException {
        logger.fine("connect");
        if (this.connected) {
            return;
        }
        try {
            CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
            this.system = factory.createCaptureSystem();
            this.system.init();
            logger.fine("Opening " + this.getLocator().getRemainder());
            int ordinal = DataSource.ordinal(this.getLocator().getRemainder());
            if (ordinal >= 0) {
                this.deviceId = this.deviceIdFromOrdinal(ordinal);
                if (this.deviceId == null) {
                    throw new IOException("Unable to convert ordinal " + ordinal + " to a capture device");
                }
            } else {
                this.deviceId = this.getLocator().getRemainder();
            }
            this.captureStream = this.system.openCaptureDeviceStream(this.deviceId);
            this.captureStream.getVideoFormat();
            this.outputVideoFormat = DataSource.convertCivilFormat(this.captureStream.getVideoFormat());
            this.captureStream.setObserver((CaptureObserver)new MyCaptureObserver());
            this.pushBufferStream = new MyPushBufferStream();
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        this.connected = true;
    }

    private static int ordinal(String remainder) {
        try {
            if (remainder.startsWith("/")) {
                remainder = remainder.substring(1);
            }
            return Integer.parseInt(remainder);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String deviceIdFromOrdinal(int index) throws CaptureException {
        List list = this.system.getCaptureDeviceInfoList();
        if (index < 0 || index >= list.size()) {
            return null;
        }
        com.lti.civil.CaptureDeviceInfo info = (com.lti.civil.CaptureDeviceInfo)list.get(index);
        return info.getDeviceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.fine("disconnect");
        if (!this.connected) {
            return;
        }
        if (this.pushBufferStream != null) {
            this.pushBufferStream.dispose();
        }
        try {
            this.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        if (this.captureStream != null) {
            try {
                this.captureStream.dispose();
            }
            catch (CaptureException e) {
                logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            }
            finally {
                this.captureStream = null;
            }
        }
        this.connected = false;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public void start() throws IOException {
        logger.fine("start");
        if (this.started.getValue()) {
            logger.warning("Civil DataSource.start called while already started, ignoring");
            return;
        }
        try {
            this.captureStream.start();
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        this.started.setValue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        logger.fine("stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.captureStream != null) {
                this.captureStream.stop();
            }
            ProducerConsumerQueue producerConsumerQueue = this.bufferQueue;
            synchronized (producerConsumerQueue) {
                while (!this.bufferQueue.isEmpty()) {
                    this.bufferQueue.get();
                }
            }
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("" + e);
        }
        finally {
            this.started.setValue(false);
        }
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        if (this.pushBufferStream == null) {
            return new PushBufferStream[0];
        }
        return new PushBufferStream[]{this.pushBufferStream};
    }

    public static VideoFormat convertCivilFormat(com.lti.civil.VideoFormat civilVideoFormat) {
        int bitsPerPixel;
        if (civilVideoFormat.getFormatType() == 1) {
            bitsPerPixel = 24;
        } else if (civilVideoFormat.getFormatType() == 2) {
            bitsPerPixel = 32;
        } else {
            throw new IllegalArgumentException();
        }
        int red = 3;
        int green = 2;
        int blue = 1;
        float fps = civilVideoFormat.getFPS();
        float frameRate = fps < 0.0f ? -1.0f : fps;
        return new RGBFormat(new Dimension(civilVideoFormat.getWidth(), civilVideoFormat.getHeight()), -1, byte[].class, frameRate, bitsPerPixel, red, green, blue);
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo(this.deviceId, this.getLocator(), new Format[]{this.outputVideoFormat});
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new CivilFormatControl()};
    }

    private class CivilFormatControl
    implements FormatControl {
        private CivilFormatControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return DataSource.this.outputVideoFormat;
        }

        public Format[] getSupportedFormats() {
            return new Format[]{DataSource.this.outputVideoFormat};
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean enabled) {
            DataSource.this.enabled = enabled;
        }

        public Format setFormat(Format format) {
            DataSource.this.outputVideoFormat = (VideoFormat)format;
            return DataSource.this.outputVideoFormat;
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        private final SynchronizedObjectHolder transferHandlerHolder = new SynchronizedObjectHolder();
        private NotifyTransferHandlerThread notifyTransferHandlerThread;

        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            if (DataSource.this.outputVideoFormat == null) {
                logger.warning("outputVideoFormat == null, video format unknown.");
            }
            return DataSource.this.outputVideoFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            Buffer nextBuffer = null;
            try {
                ProducerConsumerQueue producerConsumerQueue = DataSource.this.bufferQueue;
                synchronized (producerConsumerQueue) {
                    nextBuffer = (Buffer)DataSource.this.bufferQueue.get();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("" + e);
            }
            buffer.copy(nextBuffer);
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.transferHandlerHolder.setObject(transferHandler);
        }

        void notifyTransferHandlerSync() {
            BufferTransferHandler handler = (BufferTransferHandler)this.transferHandlerHolder.getObject();
            if (handler != null) {
                handler.transferData(this);
            }
        }

        void notifyTransferHandlerAsync() throws InterruptedException {
            if (this.notifyTransferHandlerThread == null) {
                this.notifyTransferHandlerThread = new NotifyTransferHandlerThread(ThreadGroupMgr.getDefaultThreadGroup(), "NotifyTransferHandlerThread for " + DataSource.this);
                this.notifyTransferHandlerThread.start();
            }
            this.notifyTransferHandlerThread.notifyTransferHandlerAsync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            if (this.notifyTransferHandlerThread != null) {
                this.notifyTransferHandlerThread.close();
                try {
                    this.notifyTransferHandlerThread.waitUntilClosed();
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
                finally {
                    this.notifyTransferHandlerThread = null;
                }
            }
        }

        class NotifyTransferHandlerThread
        extends CloseableThread {
            private final ProducerConsumerQueue q;

            public NotifyTransferHandlerThread(ThreadGroup group, String threadName) {
                super(group, threadName);
                this.q = new ProducerConsumerQueue();
            }

            public void notifyTransferHandlerAsync() throws InterruptedException {
                this.q.put(Boolean.TRUE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (!this.isClosing()) {
                        if (this.q.get() == null) {
                            break;
                        }
                        MyPushBufferStream.this.notifyTransferHandlerSync();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.setClosed();
                }
            }
        }
    }

    private class MyCaptureObserver
    implements CaptureObserver {
        private long firstImageTimestamp = -1L;
        private final FPSCounter fpsCounter = new FPSCounter();

        private MyCaptureObserver() {
        }

        public void onError(CaptureStream sender, CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewImage(CaptureStream sender, Image image) {
            if (DataSource.this.started.getValue()) {
                VideoFormat format = DataSource.convertCivilFormat(image.getFormat());
                Buffer buffer = new Buffer();
                buffer.setData(image.getBytes());
                buffer.setOffset(0);
                if (this.firstImageTimestamp < 0L) {
                    this.firstImageTimestamp = image.getTimestamp();
                }
                if (image.getTimestamp() >= 0L) {
                    buffer.setTimeStamp((image.getTimestamp() - this.firstImageTimestamp) * 1000000L);
                }
                buffer.setLength(image.getBytes().length);
                buffer.setFormat(format);
                try {
                    ProducerConsumerQueue producerConsumerQueue = DataSource.this.bufferQueue;
                    synchronized (producerConsumerQueue) {
                        if (DataSource.this.bufferQueue.isFull()) {
                            DataSource.this.bufferQueue.get();
                        }
                        DataSource.this.bufferQueue.put(buffer);
                    }
                    if (DataSource.this.pushBufferStream != null) {
                        DataSource.this.pushBufferStream.notifyTransferHandlerAsync();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

