/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.javasound;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.sf.fmj.media.protocol.javasound.AudioFormatComparator;
import net.sf.fmj.media.protocol.javasound.JavaSoundUrlParser;
import net.sf.fmj.media.renderer.audio.JavaSoundRenderer;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private MyPushBufferStream pushBufferStream;
    private TargetDataLine targetDataLine;
    private AudioInputStream audioInputStream;
    private javax.sound.sampled.AudioFormat javaSoundAudioFormat;
    private AudioFormat jmfAudioFormat;
    private boolean connected;
    private static final String CONTENT_TYPE = "raw";
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Format[] formatsArray;
    private boolean enabled = true;

    private void setJavaSoundAudioFormat(javax.sound.sampled.AudioFormat f) {
        this.javaSoundAudioFormat = f;
        this.jmfAudioFormat = JavaSoundRenderer.convertFormat(this.javaSoundAudioFormat);
    }

    private void setJMFAudioFormat(AudioFormat f) {
        this.jmfAudioFormat = f;
        this.javaSoundAudioFormat = JavaSoundRenderer.convertFormat(this.jmfAudioFormat);
    }

    public void connect() throws IOException {
        logger.fine("connect");
        if (this.connected) {
            return;
        }
        try {
            if (this.jmfAudioFormat == null) {
                if (this.getSupportedFormats().length <= 0) {
                    throw new IOException("No supported formats available");
                }
                AudioFormat initialAudioFormat = null;
                try {
                    AudioFormat parsedAudioFormat = JavaSoundUrlParser.parse(this.getLocator().toExternalForm());
                    for (int i = 0; i < this.getSupportedFormats().length; ++i) {
                        if (!this.getSupportedFormats()[i].matches(parsedAudioFormat)) continue;
                        initialAudioFormat = (AudioFormat)this.getSupportedFormats()[i];
                        break;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
                if (initialAudioFormat == null) {
                    initialAudioFormat = (AudioFormat)this.getSupportedFormats()[0];
                }
                this.setJMFAudioFormat(initialAudioFormat);
            }
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.javaSoundAudioFormat);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            this.targetDataLine.open(this.javaSoundAudioFormat);
            this.audioInputStream = new AudioInputStream(this.targetDataLine);
            this.pushBufferStream = new MyPushBufferStream();
        }
        catch (LineUnavailableException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IOException("" + e);
        }
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.fine("disconnect");
        if (!this.connected) {
            return;
        }
        try {
            this.stop();
            if (this.targetDataLine != null) {
                this.targetDataLine.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        finally {
            this.targetDataLine = null;
            this.audioInputStream = null;
            this.pushBufferStream = null;
        }
        this.connected = false;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public void start() throws IOException {
        logger.fine("start");
        if (this.started.getValue()) {
            return;
        }
        this.targetDataLine.start();
        this.pushBufferStream.startAvailabilityThread();
        this.started.setValue(true);
    }

    public void stop() throws IOException {
        logger.fine("stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.pushBufferStream != null) {
                this.pushBufferStream.stopAvailabilityThread();
            }
            if (this.targetDataLine != null) {
                this.targetDataLine.stop();
                this.targetDataLine.flush();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.started.setValue(false);
        }
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        return new PushBufferStream[]{this.pushBufferStream};
    }

    private long bytesToNanos(long bytes) {
        if (this.javaSoundAudioFormat.getFrameSize() > 0 && this.javaSoundAudioFormat.getFrameRate() > 0.0f) {
            long frames = bytes / (long)this.javaSoundAudioFormat.getFrameSize();
            double seconds = (float)frames / this.javaSoundAudioFormat.getFrameRate();
            double nanos = DataSource.secondsToNanos(seconds);
            return (long)nanos;
        }
        return -1L;
    }

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    private Format[] getSupportedFormats() {
        if (this.formatsArray != null) {
            return this.formatsArray;
        }
        this.formatsArray = DataSource.querySupportedFormats();
        return this.formatsArray;
    }

    public static Format[] querySupportedFormats() {
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, null);
        Line.Info[] infos = AudioSystem.getTargetLineInfo(info);
        for (int i = 0; i < infos.length; ++i) {
            DataLine.Info iCast = (DataLine.Info)infos[i];
            for (int j = 0; j < iCast.getFormats().length; ++j) {
                javax.sound.sampled.AudioFormat javaSoundAudioFormat = iCast.getFormats()[j];
                AudioFormat jmfAudioFormat = JavaSoundRenderer.convertFormat(javaSoundAudioFormat);
                if (jmfAudioFormat.getFrameRate() == -1.0) {
                    double[] commonSampleRates = new double[]{44100.0, 22050.0, 11025.0, 8000.0};
                    for (int k = 0; k < commonSampleRates.length; ++k) {
                        double sampleRate = commonSampleRates[k];
                        AudioFormat jmfAudioFormatSpecific = new AudioFormat(jmfAudioFormat.getEncoding(), sampleRate, jmfAudioFormat.getSampleSizeInBits(), jmfAudioFormat.getChannels(), jmfAudioFormat.getEndian(), jmfAudioFormat.getSigned(), jmfAudioFormat.getFrameSizeInBits(), jmfAudioFormat.getChannels() == -1 ? -1.0 : sampleRate * (double)jmfAudioFormat.getChannels(), jmfAudioFormat.getDataType());
                        if (formats.contains(jmfAudioFormatSpecific)) continue;
                        formats.add(jmfAudioFormatSpecific);
                    }
                    continue;
                }
                if (formats.contains(jmfAudioFormat)) continue;
                formats.add(jmfAudioFormat);
            }
        }
        Collections.sort(formats, Collections.reverseOrder(new AudioFormatComparator()));
        Format[] formatsArray = new Format[formats.size()];
        for (int i = 0; i < formats.size(); ++i) {
            formatsArray[i] = (Format)formats.get(i);
        }
        return formatsArray;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo("JavaSound audio capture", new MediaLocator("javasound://44100"), this.getSupportedFormats());
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new JavaSoundFormatControl()};
    }

    private class JavaSoundFormatControl
    implements FormatControl {
        private JavaSoundFormatControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        public Format[] getSupportedFormats() {
            return DataSource.this.getSupportedFormats();
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean enabled) {
            DataSource.this.enabled = enabled;
        }

        public Format setFormat(Format format) {
            DataSource.this.setJMFAudioFormat((AudioFormat)format);
            return DataSource.this.jmfAudioFormat;
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        int bufferSize = 10000;
        long totalBytesRead = 0L;
        private AvailabilityThread availabilityThread;
        private final SynchronizedObjectHolder transferHandlerHolder = new SynchronizedObjectHolder();

        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            MyPushBufferStream myPushBufferStream = this;
            synchronized (myPushBufferStream) {
                int actuallyRead;
                if (!DataSource.this.started.getValue()) {
                    buffer.setOffset(0);
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    return;
                }
                byte[] data = (byte[])buffer.getData();
                if (data == null || data.length < this.bufferSize) {
                    data = new byte[this.bufferSize];
                    buffer.setData(data);
                }
                if ((actuallyRead = DataSource.this.audioInputStream.read(data, 0, this.bufferSize)) < 0) {
                    buffer.setEOM(true);
                    buffer.setDiscard(true);
                    buffer.setOffset(0);
                    buffer.setLength(0);
                } else {
                    this.totalBytesRead += (long)actuallyRead;
                    buffer.setLength(actuallyRead);
                    buffer.setOffset(0);
                    buffer.setFormat(DataSource.this.jmfAudioFormat);
                    if (DataSource.this.javaSoundAudioFormat.getFrameSize() > 0 && DataSource.this.javaSoundAudioFormat.getFrameRate() > 0.0f) {
                        buffer.setTimeStamp(DataSource.this.bytesToNanos(this.totalBytesRead));
                        buffer.setDuration(DataSource.this.bytesToNanos(actuallyRead));
                    }
                }
            }
        }

        public void startAvailabilityThread() {
            this.availabilityThread = new AvailabilityThread();
            this.availabilityThread.setName("AvailabilityThread for " + this);
            this.availabilityThread.start();
        }

        public void stopAvailabilityThread() throws InterruptedException {
            if (this.availabilityThread == null) {
                return;
            }
            this.availabilityThread.close();
            this.availabilityThread.waitUntilClosed();
            this.availabilityThread = null;
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.transferHandlerHolder.setObject(transferHandler);
        }

        void notifyTransferHandler() {
            BufferTransferHandler handler = (BufferTransferHandler)this.transferHandlerHolder.getObject();
            if (handler != null) {
                handler.transferData(this);
            }
        }

        private class AvailabilityThread
        extends CloseableThread {
            private AvailabilityThread() {
            }

            public void close() {
                this.setClosing();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (!this.isClosing()) {
                        int available;
                        MyPushBufferStream myPushBufferStream = MyPushBufferStream.this;
                        synchronized (myPushBufferStream) {
                            try {
                                available = DataSource.this.audioInputStream.available();
                            }
                            catch (IOException e) {
                                logger.log(Level.WARNING, "" + e, e);
                                continue;
                            }
                        }
                        if (available > 0) {
                            MyPushBufferStream.this.notifyTransferHandler();
                            continue;
                        }
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    this.setClosed();
                }
            }
        }
    }
}

