/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.rtp;

import com.lti.utils.synchronization.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.media.Time;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import net.sf.fmj.media.datasink.rtp.RTPBonusFormatsMgr;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PushBufferDataSource {
    private static final Logger logger = LoggerSingleton.logger;
    private RTPManager rtpManager;
    private javax.media.protocol.DataSource dataSource;
    private static final int DATA_RECEIVED_TIMEOUT = 20000;
    private final SynchronizedBoolean dataSourceSet = new SynchronizedBoolean();

    public void connect() throws IOException {
        URI uri;
        try {
            uri = new URI(this.getLocator().toExternalForm());
        }
        catch (URISyntaxException e) {
            throw new IOException("Malformed RTP URI: " + this.getLocator().toExternalForm());
        }
        String proto = uri.getScheme();
        if (!"rtp".equalsIgnoreCase(proto)) {
            throw new IOException("Invalid protocol: expected \"rtp\"");
        }
        String addr = uri.getHost();
        int port = uri.getPort();
        this.rtpManager = RTPManager.newInstance();
        RTPBonusFormatsMgr.addBonusFormats(this.rtpManager);
        this.rtpManager.addReceiveStreamListener(new MyReceiveStreamListener());
        SessionAddress localSessionAddress = new SessionAddress(InetAddress.getLocalHost(), port);
        SessionAddress remoteSessionAddress = new SessionAddress(InetAddress.getByName(addr), port);
        try {
            this.rtpManager.initialize(localSessionAddress);
            this.rtpManager.addTarget(remoteSessionAddress);
        }
        catch (InvalidSessionAddressException e) {
            throw new IOException("" + e);
        }
        try {
            this.dataSourceSet.waitUntil(true, 20000);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("" + e);
        }
        if (!this.dataSourceSet.getValue()) {
            throw new IOException("Timeout");
        }
        if (!(this.dataSource instanceof PushBufferDataSource)) {
            throw new IOException("Expected dataSource to be instanceof PushBufferDataSource");
        }
        this.dataSource.connect();
        logger.fine("Connected datasource");
    }

    public PushBufferStream[] getStreams() {
        return ((PushBufferDataSource)this.dataSource).getStreams();
    }

    public void disconnect() {
        this.dataSource.disconnect();
        this.rtpManager.dispose();
    }

    public String getContentType() {
        return this.dataSource.getContentType();
    }

    public Object getControl(String controlType) {
        return this.dataSource.getControl(controlType);
    }

    public Object[] getControls() {
        return this.dataSource.getControls();
    }

    public Time getDuration() {
        return this.dataSource.getDuration();
    }

    public void start() throws IOException {
        this.dataSource.start();
    }

    public void stop() throws IOException {
        this.dataSource.stop();
    }

    private class MyReceiveStreamListener
    implements ReceiveStreamListener {
        private MyReceiveStreamListener() {
        }

        public void update(ReceiveStreamEvent event) {
            if (event instanceof NewReceiveStreamEvent) {
                logger.fine("NewReceiveStreamEvent: " + event);
                NewReceiveStreamEvent eCast = (NewReceiveStreamEvent)event;
                DataSource.this.dataSource = eCast.getReceiveStream().getDataSource();
                DataSource.this.dataSourceSet.setValue(true);
            }
        }
    }
}

