/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;

public class JavaSoundGainControl
implements GainControl {
    private final FloatControl masterGainControl;
    private final BooleanControl muteControl;
    private final float max;
    private final float min;
    private final float range;
    private final boolean gainUnitsDb;
    private final List listeners = new ArrayList();

    public JavaSoundGainControl(FloatControl masterGainControl, BooleanControl muteControl) {
        this.masterGainControl = masterGainControl;
        this.muteControl = muteControl;
        if (masterGainControl != null) {
            this.min = masterGainControl.getMinimum();
            this.max = masterGainControl.getMaximum();
            this.gainUnitsDb = masterGainControl.getUnits().equals("dB");
        } else {
            this.max = 0.0f;
            this.min = 0.0f;
            this.gainUnitsDb = false;
        }
        this.range = this.max - this.min;
    }

    public Component getControlComponent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGainChangeListener(GainChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public float getDB() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return this.masterGainControl.getValue();
        }
        return JavaSoundGainControl.levelToDb(this.getLevel());
    }

    private static float levelToDb(float level) {
        return (float)(Math.log10(level) * 20.0);
    }

    private static float dBToLevel(float db) {
        return (float)Math.pow(10.0, (double)db / 20.0);
    }

    public float getLevel() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return JavaSoundGainControl.dBToLevel(this.masterGainControl.getValue());
        }
        float value = this.masterGainControl.getValue();
        return (value - this.min) / this.range;
    }

    public boolean getMute() {
        if (this.muteControl == null) {
            return false;
        }
        return this.muteControl.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGainChangeListener(GainChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListenersGainChangeEvent() {
        GainChangeEvent event = new GainChangeEvent(this, this.getMute(), this.getDB(), this.getLevel());
        this.notifyListenersGainChangeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersGainChangeEvent(GainChangeEvent event) {
        ArrayList listenersCopy = new ArrayList();
        List list = this.listeners;
        synchronized (list) {
            listenersCopy.addAll(this.listeners);
        }
        for (int i = 0; i < listenersCopy.size(); ++i) {
            GainChangeListener listener = (GainChangeListener)listenersCopy.get(i);
            listener.gainChange(event);
        }
    }

    public float setDB(float gain) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(gain);
        } else {
            this.setLevel(JavaSoundGainControl.dBToLevel(gain));
        }
        float result = this.getDB();
        this.notifyListenersGainChangeEvent();
        return result;
    }

    public float setLevel(float level) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(JavaSoundGainControl.levelToDb(level));
        } else {
            level = this.min + level * this.range;
            this.masterGainControl.setValue(level);
        }
        float result = this.getLevel();
        this.notifyListenersGainChangeEvent();
        return result;
    }

    public void setMute(boolean mute) {
        if (this.muteControl == null) {
            return;
        }
        this.muteControl.setValue(mute);
        this.notifyListenersGainChangeEvent();
    }
}

