/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import javazoom.spi.mpeg.sampled.file.MpegEncoding;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFormat;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import net.sf.fmj.media.codec.audio.alaw.Decoder;
import net.sf.fmj.media.renderer.audio.CustomEncoding;
import net.sf.fmj.media.renderer.audio.JavaSoundGainControl;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.ObjectCollection;

public class JavaSoundRenderer
implements Renderer {
    private static final Logger logger = LoggerSingleton.logger;
    private String name = "FMJ Audio Renderer";
    private Mixer mixer;
    private SourceDataLine sourceLine;
    private AudioFormat inputFormat;
    private javax.sound.sampled.AudioFormat sampledFormat;
    private final ObjectCollection controls = new ObjectCollection();
    private Codec codec;
    private final Buffer codecBuffer = new Buffer();
    private Format[] supportedInputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final boolean NON_BLOCKING = false;

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format setInputFormat(Format format) {
        logger.info("Setting input format to: " + format);
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.inputFormat = (AudioFormat)format;
        return this.inputFormat;
    }

    public Object getControl(String controlType) {
        return this.controls.getControl(controlType);
    }

    public Object[] getControls() {
        return this.controls.getControls();
    }

    public void open() throws ResourceUnavailableException {
        javax.sound.sampled.AudioFormat audioFormat = JavaSoundRenderer.convertFormat(this.inputFormat);
        logger.info("opening with javax.sound format: " + audioFormat);
        try {
            if (!this.inputFormat.getEncoding().equals("LINEAR")) {
                logger.info("JavaSoundRenderer: Audio format is not linear, creating conversion");
                if (this.inputFormat.getEncoding().equals("ULAW")) {
                    this.codec = new net.sf.fmj.media.codec.audio.ulaw.Decoder();
                } else if (this.inputFormat.getEncoding().equals("alaw")) {
                    this.codec = new Decoder();
                } else {
                    throw new ResourceUnavailableException("Unsupported input format encoding: " + this.inputFormat.getEncoding());
                }
                this.codec.setInputFormat(this.inputFormat);
                Format[] outputFormats = this.codec.getSupportedOutputFormats(this.inputFormat);
                if (outputFormats.length < 1) {
                    throw new ResourceUnavailableException("Unable to get an output format for input format: " + this.inputFormat);
                }
                AudioFormat codecOutputFormat = (AudioFormat)outputFormats[0];
                this.codec.setOutputFormat(codecOutputFormat);
                audioFormat = JavaSoundRenderer.convertFormat(codecOutputFormat);
                this.codec.open();
                logger.info("JavaSoundRenderer: Audio format is not linear, created conversion from " + this.inputFormat + " to " + codecOutputFormat);
            }
            this.sourceLine = JavaSoundRenderer.getSourceDataLine(audioFormat);
            this.sourceLine.open(audioFormat);
            FloatControl gainFloatControl = null;
            BooleanControl muteBooleanControl = null;
            try {
                gainFloatControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                muteBooleanControl = (BooleanControl)this.sourceLine.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JavaSoundGainControl gainControl = new JavaSoundGainControl(gainFloatControl, muteBooleanControl);
            this.controls.addControl(gainControl);
            this.logControls(this.sourceLine.getControls());
        }
        catch (LineUnavailableException e) {
            throw new ResourceUnavailableException(e.getMessage());
        }
    }

    private static SourceDataLine getSourceDataLine(javax.sound.sampled.AudioFormat format) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        return (SourceDataLine)AudioSystem.getLine(info);
    }

    public void close() {
        logger.info("closing...");
        this.controls.clear();
        if (this.codec != null) {
            this.codec.close();
            this.codec = null;
        }
        this.sourceLine.close();
        this.sourceLine = null;
    }

    public void reset() {
        logger.info("resetting...");
    }

    public void start() {
        logger.info("starting...");
        this.sourceLine.start();
    }

    public void stop() {
        logger.info("stopping...");
        this.sourceLine.stop();
    }

    public int process(Buffer buffer) {
        int n;
        if (this.codec != null) {
            int codecResult = this.codec.process(buffer, this.codecBuffer);
            if (codecResult == 1) {
                return 1;
            }
            if (codecResult == 4) {
                return 0;
            }
            buffer = this.codecBuffer;
        }
        int length = buffer.getLength();
        int offset = buffer.getOffset();
        Format format = buffer.getFormat();
        Class type = format.getDataType();
        if (type != Format.byteArray) {
            return 1;
        }
        byte[] data = (byte[])buffer.getData();
        boolean bufferNotConsumed = false;
        int newBufferLength = 0;
        int newBufferOffset = 0;
        if (length == 0) {
            logger.finer("Buffer has zero length, flags = " + buffer.getFlags());
        }
        while (length > 0 && (n = this.sourceLine.write(data, offset, length)) < length) {
            if (n == 0) {
                logger.warning("sourceLine.write returned 0, offset=" + offset + "; length=" + length + "; available=" + this.sourceLine.available() + "; frame size in bytes" + this.sourceLine.getFormat().getFrameSize() + "; sourceLine.isActive() = " + this.sourceLine.isActive() + "; " + this.sourceLine.isOpen() + "; sourceLine.isRunning()=" + this.sourceLine.isRunning());
                return 1;
            }
            offset += n;
            length -= n;
        }
        if (bufferNotConsumed) {
            buffer.setLength(newBufferLength);
            buffer.setOffset(newBufferOffset);
            return 2;
        }
        if (buffer.isEOM()) {
            this.sourceLine.drain();
        }
        return 0;
    }

    public int hashCode() {
        return super.hashCode() ^ 0xAD;
    }

    public static AudioFormat convertFormat(javax.sound.sampled.AudioFormat format) {
        AudioFormat.Encoding encoding = format.getEncoding();
        int channels = format.getChannels();
        float frameRate = format.getFrameRate();
        int frameSize = format.getFrameSize() < 0 ? format.getFrameSize() : format.getFrameSize() * 8;
        float sampleRate = format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int endian = format.isBigEndian() ? 1 : 0;
        int signed = -1;
        String encodingString = "LINEAR";
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            signed = 1;
            encodingString = "LINEAR";
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            signed = 0;
            encodingString = "LINEAR";
        } else {
            encodingString = encoding == AudioFormat.Encoding.ALAW ? "alaw" : (encoding == AudioFormat.Encoding.ULAW ? "ULAW" : encoding.toString());
        }
        AudioFormat jmfFormat = new AudioFormat(encodingString, sampleRate, sampleSize, channels, endian, signed, frameSize, frameRate, AudioFormat.byteArray);
        return jmfFormat;
    }

    private static AudioFormat.Encoding toMpegEncoding(String encodingStr) {
        AudioFormat.Encoding[] mpegEncodings = new AudioFormat.Encoding[]{MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3, MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3, MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3};
        for (int i = 0; i < mpegEncodings.length; ++i) {
            if (!encodingStr.equals(mpegEncodings[i].toString())) continue;
            return mpegEncodings[i];
        }
        return null;
    }

    private static AudioFormat.Encoding toVorbisEncoding(String encodingStr) {
        AudioFormat.Encoding[] vorbisEncodings = new AudioFormat.Encoding[]{VorbisEncoding.VORBISENC};
        for (int i = 0; i < vorbisEncodings.length; ++i) {
            if (!encodingStr.equals(vorbisEncodings[i].toString())) continue;
            return vorbisEncodings[i];
        }
        return null;
    }

    public static javax.sound.sampled.AudioFormat convertFormat(AudioFormat format) {
        javax.sound.sampled.AudioFormat sampledFormat;
        AudioFormat.Encoding encoding;
        String encodingString = format.getEncoding();
        int channels = format.getChannels();
        double frameRate = format.getFrameRate();
        int frameSize = format.getFrameSizeInBits() / 8;
        double sampleRate = format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        boolean endian = format.getEndian() == 1;
        int signed = format.getSigned();
        if ("LINEAR".equals(encodingString)) {
            switch (signed) {
                case 1: {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    break;
                }
                case 0: {
                    encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    break;
                }
                default: {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    break;
                }
            }
        } else {
            encoding = "alaw".equals(encodingString) ? AudioFormat.Encoding.ALAW : ("ULAW".equals(encodingString) ? AudioFormat.Encoding.ULAW : (JavaSoundRenderer.toMpegEncoding(encodingString) != null ? JavaSoundRenderer.toMpegEncoding(encodingString) : (JavaSoundRenderer.toVorbisEncoding(encodingString) != null ? JavaSoundRenderer.toVorbisEncoding(encodingString) : new CustomEncoding(encodingString))));
        }
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            sampledFormat = new javax.sound.sampled.AudioFormat((float)sampleRate, sampleSize, channels, true, endian);
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            sampledFormat = new javax.sound.sampled.AudioFormat((float)sampleRate, sampleSize, channels, false, endian);
        } else {
            if (encoding instanceof MpegEncoding) {
                return new MpegAudioFormat(encoding, (float)sampleRate, sampleSize, channels, frameSize, (float)frameRate, endian, new HashMap());
            }
            if (encoding instanceof VorbisEncoding) {
                return new VorbisAudioFormat(encoding, (float)sampleRate, sampleSize, channels, frameSize, (float)frameRate, endian, new HashMap());
            }
            sampledFormat = new javax.sound.sampled.AudioFormat(encoding, (float)sampleRate, sampleSize, channels, frameSize, (float)frameRate, endian);
        }
        return sampledFormat;
    }

    private static List getMixers() {
        Vector<Mixer> mixers = new Vector<Mixer>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            mixers.add(mixer);
        }
        return mixers;
    }

    private static void getMixer(String name) {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
        }
    }

    private void logControls(Control[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            logger.info("control: " + control);
            Control.Type controlType = control.getType();
            if (!(controlType instanceof CompoundControl.Type)) continue;
            this.logControls(((CompoundControl)control).getMemberControls());
        }
    }
}

