/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RTCPSenderInfo {
    public static final int SIZE = 20;
    private static final long MSB_0_BASE_TIME = 2085978496000L;
    private static final long MSB_1_BASE_TIME = -2208988800000L;
    private long ntpTimestampMSW = 0L;
    private long ntpTimestampLSW = 0L;
    private long rtpTimestamp = 0L;
    private long packetCount = 0L;
    private long octetCount = 0L;

    public RTCPSenderInfo(byte[] rtcpPacket, int offset, int length) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(rtcpPacket, offset, length));
        this.ntpTimestampMSW = (long)stream.readInt() & 0xFFFFFFFFL;
        this.ntpTimestampLSW = (long)stream.readInt() & 0xFFFFFFFFL;
        this.rtpTimestamp = (long)stream.readInt() & 0xFFFFFFFFL;
        this.packetCount = (long)stream.readInt() & 0xFFFFFFFFL;
        this.octetCount = (long)stream.readInt() & 0xFFFFFFFFL;
    }

    public String toString() {
        String buf = "";
        buf = buf + "ntp_ts=" + this.getNtpTimestampMSW();
        buf = buf + " " + this.getNtpTimestampLSW();
        buf = buf + " rtp_ts=" + this.getRtpTimestamp();
        buf = buf + " packet_ct=" + this.getPacketCount();
        buf = buf + " octect_ct=" + this.getOctetCount();
        return buf;
    }

    public long getTimestamp() {
        long seconds = this.ntpTimestampMSW;
        long fraction = this.ntpTimestampLSW;
        fraction = Math.round(1000.0 * (double)fraction / 4.294967296E9);
        long msb = seconds & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + seconds * 1000L + fraction;
        }
        return -2208988800000L + seconds * 1000L + fraction;
    }

    public double getNtpTimestampSecs() {
        return (double)this.getTimestamp() / 1000.0;
    }

    public long getNtpTimestampMSW() {
        return this.ntpTimestampMSW;
    }

    public long getNtpTimestampLSW() {
        return this.ntpTimestampLSW;
    }

    public long getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public long getOctetCount() {
        return this.octetCount;
    }

    public long getPacketCount() {
        return this.packetCount;
    }
}

