/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import java.io.IOException;
import java.util.Timer;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPReceptionStats;

public abstract class RTPDataStream
implements PushBufferStream,
RTPControl {
    protected Format format = null;
    protected double clockRate = 90000.0;
    protected BufferTransferHandler handler = null;
    protected Timer timer = new Timer();
    protected long ssrc = 0L;
    protected int threshold = 100;
    protected Object[] controls = new Object[0];
    protected RTPReceptionStats receptionStats = new RTPReceptionStats();
    protected long jitter = 0L;
    private long lastDelay = -1L;
    private long lastRTPReceiveTime = -1L;
    private long lastRTPTimestamp = -1L;
    protected long firstSequence = -1L;
    protected long lastSequence = -1L;

    public RTPDataStream(long ssrc, Format format) {
        this.ssrc = ssrc;
        this.format = format;
    }

    protected abstract void addPacket(RTPHeader var1, byte[] var2, int var3, int var4);

    public Format getFormat() {
        return this.format;
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.handler = transferHandler;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("raw.rtp");
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return false;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        if (controlType.equals("javax.media.rtp.RTPControl")) {
            return this;
        }
        return null;
    }

    public abstract void read(Buffer var1) throws IOException;

    public void addFormat(Format fmt, int payload) {
    }

    public ReceptionStats getReceptionStats() {
        return this.receptionStats;
    }

    public GlobalReceptionStats getGlobalStats() {
        return null;
    }

    public Format[] getFormatList() {
        return new Format[0];
    }

    public Format getFormat(int payload) {
        return this.format;
    }

    public Component getControlComponent() {
        return null;
    }

    protected void calculateJitter(long rtpTimestamp) {
        if (this.lastRTPReceiveTime == -1L) {
            this.lastRTPReceiveTime = System.currentTimeMillis();
            this.lastRTPTimestamp = rtpTimestamp;
        } else if (this.lastDelay == -1L) {
            this.lastRTPReceiveTime = System.currentTimeMillis();
            this.lastRTPTimestamp = rtpTimestamp;
            long expChange = (long)((double)(System.currentTimeMillis() - this.lastRTPReceiveTime) * this.clockRate);
            long actualChange = rtpTimestamp - this.lastRTPTimestamp;
            this.lastDelay = expChange - actualChange;
        } else {
            this.lastRTPReceiveTime = System.currentTimeMillis();
            this.lastRTPTimestamp = rtpTimestamp;
            long expChange = (long)((double)(System.currentTimeMillis() - this.lastRTPReceiveTime) * this.clockRate);
            long actualChange = rtpTimestamp - this.lastRTPTimestamp;
            long delay = expChange - actualChange;
            long delaydiff = Math.abs(delay - this.lastDelay);
            this.lastDelay = delay;
            this.jitter += (delaydiff - this.jitter) / 16L;
        }
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public long getFirstSequence() {
        return this.firstSequence;
    }
}

