/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import net.sf.fmj.media.rtp.RTPReceptionStats;

public class RTPJitterBuffer {
    private Buffer[] queue = null;
    private int[] nextPos = null;
    private int[] prevPos = null;
    private int firstElement = -1;
    private int lastElement = 0;
    private int[] emptyPos = null;
    private int maxEmpty = 0;
    private RTPReceptionStats statistics = null;
    private long lastSequenceSent = -1L;

    public RTPJitterBuffer(int size) {
        this.queue = new Buffer[size];
        this.nextPos = new int[size];
        this.prevPos = new int[size];
        this.emptyPos = new int[size];
        for (int i = 1; i <= size; ++i) {
            this.emptyPos[i - 1] = size - i;
            this.nextPos[i - 1] = -1;
            this.prevPos[i - 1] = -1;
        }
        this.maxEmpty = size - 1;
    }

    public void setStatistics(RTPReceptionStats statistics) {
        this.statistics = statistics;
    }

    public synchronized boolean add(Buffer data) {
        if (this.firstElement == -1) {
            int pos = this.emptyPos[this.maxEmpty];
            --this.maxEmpty;
            this.queue[pos] = data;
            this.nextPos[pos] = -1;
            this.prevPos[pos] = -1;
            this.firstElement = pos;
            this.lastElement = pos;
            return true;
        }
        if (this.maxEmpty < 0) {
            if (this.statistics != null) {
                this.statistics.addPDUInvalid();
            }
            return false;
        }
        int pos = this.lastElement;
        long sequence = data.getSequenceNumber();
        if (65535L - this.queue[pos].getSequenceNumber() < 100L && sequence < this.queue[pos].getSequenceNumber()) {
            pos = this.lastElement;
        } else {
            while (pos != -1 && this.queue[pos].getSequenceNumber() > sequence) {
                int prev = this.prevPos[pos];
                if (prev >= 0 && this.queue[pos].getSequenceNumber() < this.queue[prev].getSequenceNumber()) {
                    pos = -1;
                    continue;
                }
                pos = prev;
            }
            if (pos != this.lastElement && this.statistics != null) {
                this.statistics.addPDUMisOrd();
            }
            if (pos == -1) {
                if (this.statistics != null) {
                    this.statistics.addPDUInvalid();
                }
                return false;
            }
            if (this.queue[pos].getSequenceNumber() == sequence) {
                if (this.statistics != null) {
                    this.statistics.addPDUDuplicate();
                }
                return false;
            }
        }
        int newPos = this.emptyPos[this.maxEmpty];
        int next = this.nextPos[pos];
        if (next != -1) {
            this.prevPos[next] = newPos;
        }
        this.nextPos[pos] = newPos;
        --this.maxEmpty;
        this.queue[newPos] = data;
        this.nextPos[newPos] = next;
        this.prevPos[newPos] = pos;
        if (next == -1) {
            this.lastElement = newPos;
        }
        return true;
    }

    public synchronized Buffer remove() {
        if (this.firstElement != -1) {
            Buffer value = this.queue[this.firstElement];
            ++this.maxEmpty;
            this.emptyPos[this.maxEmpty] = this.firstElement;
            this.firstElement = this.nextPos[this.firstElement];
            if (this.firstElement != -1) {
                this.prevPos[this.firstElement] = -1;
            }
            if (this.statistics != null) {
                this.statistics.addPDUProcessed();
            }
            long seq = value.getSequenceNumber();
            if (this.lastSequenceSent == -1L) {
                this.lastSequenceSent = seq;
            } else if (seq < this.lastSequenceSent && seq != 0L && this.lastSequenceSent != 65535L) {
                if (this.statistics != null) {
                    this.statistics.addPDULost((int)(seq + 65535L - this.lastSequenceSent));
                }
            } else if (this.lastSequenceSent + 1L != seq && this.statistics != null) {
                this.statistics.addPDULost((int)(seq - this.lastSequenceSent));
            }
            this.lastSequenceSent = seq;
            return value;
        }
        return null;
    }

    public synchronized long peekTimeStamp() {
        if (this.firstElement != -1) {
            return this.queue[this.firstElement].getTimeStamp();
        }
        return -1L;
    }

    public synchronized int size() {
        return this.queue.length - this.maxEmpty - 1;
    }
}

