/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.HashMap;
import java.util.Vector;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPReport;
import net.sf.fmj.media.rtp.RTPDataSource;
import net.sf.fmj.media.rtp.RTPRemoteParticipant;

public class RTPReceiveStream
implements ReceiveStream {
    private DataSource dataSource = null;
    private long ssrc = 0L;
    private SenderReport lastSenderReport = null;
    private RTPRemoteParticipant participant = null;
    private long lastSRReportTime = 0L;
    private HashMap sourceDescriptions = new HashMap();

    public RTPReceiveStream(DataSource dataSource, long ssrc) {
        this.dataSource = dataSource;
        this.ssrc = ssrc;
    }

    public ReceptionStats getSourceReceptionStats() {
        return ((RTPDataSource)this.dataSource).getSourceReceptionStats();
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public SenderReport getSenderReport() {
        return this.lastSenderReport;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setParticipant(RTPRemoteParticipant participant) {
        this.participant = participant;
    }

    public void setReport(Report lastReport) {
        if (lastReport instanceof SenderReport) {
            this.lastSRReportTime = System.currentTimeMillis();
            this.lastSenderReport = (SenderReport)lastReport;
        }
        Vector sdes = lastReport.getSourceDescription();
        for (int i = 0; i < sdes.size(); ++i) {
            SourceDescription sdesItem = (SourceDescription)sdes.get(i);
            this.sourceDescriptions.put(new Integer(sdesItem.getType()), sdesItem);
        }
        if (lastReport instanceof RTCPReport) {
            ((RTCPReport)lastReport).sourceDescriptions = new Vector(this.sourceDescriptions.values());
        }
    }

    public long getLastSRReportTime() {
        return this.lastSRReportTime;
    }

    public long getLastSRReportTimestampLSW() {
        if (this.lastSenderReport == null) {
            return 0L;
        }
        return this.lastSenderReport.getNTPTimeStampLSW();
    }

    public long getLastSRReportTimestampMSW() {
        if (this.lastSenderReport == null) {
            return 0L;
        }
        return this.lastSenderReport.getNTPTimeStampMSW();
    }
}

