/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.Participant;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPLocalParticipant;
import net.sf.fmj.media.rtp.RTPTransmissionStats;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPSendStream
implements SendStream,
SourceTransferHandler,
BufferTransferHandler {
    private static final Logger logger = LoggerSingleton.logger;
    private long ssrc = 0L;
    private DataSource dataSource = null;
    private OutputDataStream rtpDataStream = null;
    private HashMap sourceDescriptions = new HashMap();
    private int sdesSize = 0;
    private int index = 0;
    private int format = 0;
    private double clockRate = 90000.0;
    private boolean started = false;
    private RTPLocalParticipant participant = null;
    private byte[] buffer = new byte[0];
    private int lastSequence = (int)(Math.random() * 65535.0);
    private long lastSendTime = -1L;
    private long lastTimestamp = (long)(Math.random() * 2.147483647E9);
    private byte header0 = (byte)-128;
    private RTPTransmissionStats stats = new RTPTransmissionStats();
    private static final int MAX_PUSHBUFFER_DATA_SIZE = 2048;

    public RTPSendStream(long ssrc, DataSource dataSource, OutputDataStream rtpDataStream, int index, RTPLocalParticipant participant, int format, double clockRate) {
        this.ssrc = ssrc;
        this.dataSource = dataSource;
        this.rtpDataStream = rtpDataStream;
        this.index = index;
        this.participant = participant;
        this.format = format;
        this.clockRate = clockRate;
        this.addSourceDescription(new SourceDescription(1, participant.getCNAME(), 1, false));
        this.addSourceDescription(new SourceDescription(2, participant.getCNAME(), 1, false));
    }

    public void addSourceDescription(SourceDescription sdes) {
        SourceDescription oldSdes = (SourceDescription)this.sourceDescriptions.get(new Integer(sdes.getType()));
        if (oldSdes != null) {
            this.sdesSize -= oldSdes.getDescription().length();
            this.sdesSize -= 2;
        }
        this.sourceDescriptions.put(new Integer(sdes.getType()), sdes);
        this.sdesSize += 2;
        this.sdesSize += sdes.getDescription().length();
    }

    public void setSourceDescription(SourceDescription[] sourceDesc) {
        for (int i = 0; i < sourceDesc.length; ++i) {
            this.addSourceDescription(sourceDesc[i]);
        }
    }

    public void close() {
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }

    public void stop() throws IOException {
        if (this.started) {
            this.dataSource.stop();
        }
        this.started = false;
    }

    public void start() throws IOException {
        if (!this.started) {
            if (this.dataSource instanceof PushBufferDataSource) {
                PushBufferStream[] streams = ((PushBufferDataSource)this.dataSource).getStreams();
                streams[this.index].setTransferHandler(this);
            } else if (this.dataSource instanceof PushDataSource) {
                PushSourceStream[] streams = ((PushDataSource)this.dataSource).getStreams();
                streams[this.index].setTransferHandler(this);
            }
            this.dataSource.start();
        }
    }

    public int setBitRate(int bitRate) {
        return -1;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public SenderReport getSenderReport() {
        return null;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void writeHeaderToBuffer(boolean marker, long timestamp) {
        this.buffer[0] = this.header0;
        this.buffer[1] = (byte)(this.format & 0xFF);
        if (marker) {
            this.buffer[1] = (byte)(this.buffer[1] | 0x80);
        }
        ++this.lastSequence;
        if (this.lastSequence > 65535) {
            this.lastSequence = 0;
        }
        this.buffer[2] = (byte)(this.lastSequence >> 8 & 0xFF);
        this.buffer[3] = (byte)(this.lastSequence & 0xFF);
        this.buffer[4] = (byte)(timestamp >> 24 & 0xFFL);
        this.buffer[5] = (byte)(timestamp >> 16 & 0xFFL);
        this.buffer[6] = (byte)(timestamp >> 8 & 0xFFL);
        this.buffer[7] = (byte)(timestamp & 0xFFL);
        this.buffer[8] = (byte)(this.ssrc >> 24 & 0xFFL);
        this.buffer[9] = (byte)(this.ssrc >> 16 & 0xFFL);
        this.buffer[10] = (byte)(this.ssrc >> 8 & 0xFFL);
        this.buffer[11] = (byte)(this.ssrc & 0xFFL);
    }

    public void transferData(PushSourceStream stream) {
        if (!stream.endOfStream()) {
            int size = stream.getMinimumTransferSize();
            if (this.buffer.length < size + 12) {
                this.buffer = new byte[size + 12];
            }
            try {
                int length = stream.read(this.buffer, 12, this.buffer.length - 12);
                if (length > 0) {
                    long time = System.currentTimeMillis();
                    if (this.lastSendTime != -1L) {
                        this.lastTimestamp = (long)((double)this.lastTimestamp + (double)(time - this.lastSendTime) * this.clockRate / 1000.0);
                    }
                    this.lastSendTime = time;
                    this.writeHeaderToBuffer(false, this.lastTimestamp);
                    this.rtpDataStream.write(this.buffer, 0, length + 12);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }

    public void transferData(PushBufferStream stream) {
        if (!stream.endOfStream()) {
            try {
                Buffer recvBuffer = new Buffer();
                if (this.buffer.length < 2060) {
                    this.buffer = new byte[2060];
                }
                recvBuffer.setData(this.buffer);
                recvBuffer.setOffset(12);
                recvBuffer.setLength(this.buffer.length - 12);
                stream.read(recvBuffer);
                if (recvBuffer.getLength() > 0) {
                    long time = System.currentTimeMillis();
                    if (this.lastSendTime != -1L) {
                        this.lastTimestamp = (long)((double)this.lastTimestamp + (double)(time - this.lastSendTime) * this.clockRate / 1000.0);
                    }
                    this.lastSendTime = time;
                    this.writeHeaderToBuffer((recvBuffer.getFlags() & 0x800) != 0, recvBuffer.getTimeStamp());
                    if (recvBuffer.getData() != this.buffer) {
                        System.arraycopy(recvBuffer.getData(), recvBuffer.getOffset(), this.buffer, 12, recvBuffer.getLength());
                    }
                    this.rtpDataStream.write(this.buffer, 0, recvBuffer.getLength() + 12);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }

    public Vector getSourceDescription() {
        return new Vector(this.sourceDescriptions.values());
    }

    public int getSdesSize() {
        return this.sdesSize;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }
}

