/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.SourceStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPHandler;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTCPReceiverReport;
import net.sf.fmj.media.rtp.RTCPReport;
import net.sf.fmj.media.rtp.RTCPSenderReport;
import net.sf.fmj.media.rtp.RTPDataSource;
import net.sf.fmj.media.rtp.RTPDataStream;
import net.sf.fmj.media.rtp.RTPGlobalReceptionStats;
import net.sf.fmj.media.rtp.RTPGlobalTransmissionStats;
import net.sf.fmj.media.rtp.RTPHandler;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPLocalParticipant;
import net.sf.fmj.media.rtp.RTPReceiveStream;
import net.sf.fmj.media.rtp.RTPReceptionStats;
import net.sf.fmj.media.rtp.RTPRemoteParticipant;
import net.sf.fmj.media.rtp.RTPSendStream;
import net.sf.fmj.media.rtp.RTPSocketAdapter;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int MIN_RTCP_INTERVAL = 5000;
    private HashMap formatMap = new HashMap();
    private Vector receiveStreamListeners = new Vector();
    private Vector remoteListeners = new Vector();
    private Vector sendStreamListeners = new Vector();
    private Vector sessionListeners = new Vector();
    private RTPLocalParticipant localParticipant = null;
    private HashMap activeParticipants = new HashMap();
    private HashMap inactiveParticipants = new HashMap();
    private RTPGlobalReceptionStats globalReceptionStats = new RTPGlobalReceptionStats();
    private RTPGlobalTransmissionStats globalTransmissionStats = new RTPGlobalTransmissionStats();
    private HashMap receiveStreams = new HashMap();
    private HashMap sendStreams = new HashMap();
    private HashMap ignoredStreams = new HashMap();
    private HashMap senders = new HashMap();
    private double rtcpReceiverBandwidthFraction = 0.0375;
    private double rtcpSenderBandwidthFraction = 0.0125;
    private SessionAddress localAddress = null;
    private HashMap targets = new HashMap();
    private RTPHandler rtpHandler = null;
    private RTCPHandler rtcpHandler = null;
    private Integer eventLock = new Integer(0);
    private boolean eventLocked = false;
    private boolean done = false;
    private Timer rtcpTimer = new Timer();
    private long lastRTCPSendTime = -1L;
    private int averageRTCPSize = 0;
    protected static long ssrc = (long)(Math.random() * 2.147483647E9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEventLock() {
        Integer n = this.eventLock;
        synchronized (n) {
            while (this.eventLocked) {
                try {
                    this.eventLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.eventLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEventLock() {
        Integer n = this.eventLock;
        synchronized (n) {
            this.eventLocked = false;
            this.eventLock.notifyAll();
        }
    }

    public RTPSessionMgr() {
        String user = System.getProperty("user.name");
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.localParticipant = new RTPLocalParticipant(user + "@" + host);
        this.addFormat(new AudioFormat("ULAW/rtp", 8000.0, 8, 1), 0);
        this.addFormat(new AudioFormat("gsm/rtp", 8000.0, -1, 1), 3);
        this.addFormat(new AudioFormat("g723/rtp", 8000.0, -1, 1), 4);
        this.addFormat(new AudioFormat("dvi/rtp", 8000.0, 4, 1), 5);
        this.addFormat(new AudioFormat("mpegaudio/rtp"), 14);
        this.addFormat(new AudioFormat("g728/rtp", 8000.0, -1, 1), 15);
        this.addFormat(new AudioFormat("dvi/rtp", 11025.0, 4, 1), 16);
        this.addFormat(new AudioFormat("dvi/rtp", 22050.0, 4, 1), 17);
        this.addFormat(new AudioFormat("g729/rtp", 8000.0, -1, 1), 18);
        this.addFormat(new VideoFormat("jpeg/rtp"), 26);
        this.addFormat(new VideoFormat("h261/rtp"), 31);
        this.addFormat(new VideoFormat("mpeg/rtp"), 32);
        this.addFormat(new VideoFormat("h263/rtp"), 34);
        this.addFormat(new VideoFormat("h263-1998/rtp"), 42);
    }

    public static boolean formatSupported(Format f) {
        RTPSessionMgr mgr = new RTPSessionMgr();
        for (Integer id : mgr.formatMap.keySet()) {
            Format testFormat = (Format)mgr.formatMap.get(id);
            if (!testFormat.matches(f)) continue;
            return true;
        }
        return false;
    }

    public Format getFormat(int payload) {
        return (Format)this.formatMap.get(new Integer(payload));
    }

    public void addFormat(Format format, int payload) {
        this.formatMap.put(new Integer(payload), format);
    }

    public void addReceiveStreamListener(ReceiveStreamListener listener) {
        this.receiveStreamListeners.add(listener);
    }

    public void addRemoteListener(RemoteListener listener) {
        this.remoteListeners.add(listener);
    }

    public void addSendStreamListener(SendStreamListener listener) {
        this.sendStreamListeners.add(listener);
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeReceiveStreamListener(ReceiveStreamListener listener) {
        this.receiveStreamListeners.remove(listener);
    }

    public void removeRemoteListener(RemoteListener listener) {
        this.remoteListeners.remove(listener);
    }

    public void removeSendStreamListener(SendStreamListener listener) {
        this.sendStreamListeners.remove(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public Vector getActiveParticipants() {
        Vector participants = new Vector(this.activeParticipants.values());
        if (this.localParticipant.isActive()) {
            participants.add(this.localParticipant);
        }
        return participants;
    }

    public Vector getAllParticipants() {
        Vector<Object> participants = new Vector<Object>();
        participants.addAll(this.activeParticipants.values());
        participants.addAll(this.inactiveParticipants.values());
        participants.add(this.localParticipant);
        return participants;
    }

    public LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public Vector getPassiveParticipants() {
        Vector participants = new Vector(this.inactiveParticipants.values());
        if (!this.localParticipant.isActive()) {
            participants.add(this.localParticipant);
        }
        return participants;
    }

    public Vector getRemoteParticipants() {
        Vector participants = new Vector();
        participants.addAll(this.activeParticipants.values());
        participants.addAll(this.inactiveParticipants.values());
        return participants;
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.globalReceptionStats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.globalTransmissionStats;
    }

    public Vector getReceiveStreams() {
        return new Vector(this.receiveStreams.values());
    }

    public Vector getSendStreams() {
        return new Vector(this.sendStreams.values());
    }

    public void initialize(SessionAddress localAddress) throws IOException {
        String user = System.getProperty("user.name");
        this.initialize(new SessionAddress[]{localAddress}, new SourceDescription[]{new SourceDescription(1, user + "@" + InetAddress.getLocalHost().getHostName(), 1, false), new SourceDescription(2, user + "@" + InetAddress.getLocalHost().getHostName(), 3, false)}, 0.05, 0.25, null);
    }

    public void initialize(SessionAddress[] localAddresses, SourceDescription[] sourceDescription, double rtcpBandwidthFraction, double rtcpSenderBandwidthFraction, EncryptionInfo encryptionInfo) {
        this.rtcpSenderBandwidthFraction = rtcpBandwidthFraction * rtcpBandwidthFraction;
        this.rtcpReceiverBandwidthFraction = rtcpBandwidthFraction - this.rtcpSenderBandwidthFraction;
        this.localParticipant = new RTPLocalParticipant("");
        this.localParticipant.setSourceDescription(sourceDescription);
        this.localAddress = localAddresses[0];
        this.start();
    }

    public void addTarget(SessionAddress remoteAddress) throws IOException {
        RTPSocketAdapter socket = new RTPSocketAdapter(this.localAddress.getDataAddress(), remoteAddress.getDataAddress(), remoteAddress.getDataPort(), remoteAddress.getTimeToLive());
        this.rtpHandler = new RTPHandler(this);
        this.rtcpHandler = new RTCPHandler(this);
        socket.getControlInputStream().setTransferHandler(this.rtcpHandler);
        socket.getDataInputStream().setTransferHandler(this.rtpHandler);
        this.targets.put(remoteAddress, socket);
    }

    public void initialize(RTPConnector connector) {
        try {
            this.rtpHandler = new RTPHandler(this);
            this.rtcpHandler = new RTCPHandler(this);
            connector.getControlInputStream().setTransferHandler(this.rtcpHandler);
            connector.getDataInputStream().setTransferHandler(this.rtpHandler);
            this.targets.put(null, connector);
            this.start();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public void removeTarget(SessionAddress remoteAddress, String reason) {
        RTPConnector connector = (RTPConnector)this.targets.get(remoteAddress);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        try {
            Vector sendStreams = this.localParticipant.getStreams();
            output.writeByte(128);
            output.writeByte(201);
            output.writeShort(1);
            output.writeInt((int)(ssrc & 0xFFFFFFFFFFFFFFFFL));
            output.writeByte(0x80 | sendStreams.size() + 1 & 0x1F);
            output.writeByte(203);
            output.writeShort(sendStreams.size() + 1);
            output.writeInt((int)(ssrc & 0xFFFFFFFFFFFFFFFFL));
            for (int i = 0; i < sendStreams.size(); ++i) {
                output.writeInt((int)(((RTPSendStream)sendStreams.get(i)).getSSRC() & 0xFFFFFFFFFFFFFFFFL));
            }
            output.close();
            bytes.close();
            byte[] data = bytes.toByteArray();
            OutputDataStream out = connector.getControlOutputStream();
            out.write(data, 0, data.length);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        if (connector != null) {
            this.targets.remove(remoteAddress);
        }
    }

    public void removeTargets(String reason) {
        for (SessionAddress addr : this.targets.keySet()) {
            this.removeTarget(addr, reason);
        }
    }

    public SendStream createSendStream(DataSource dataSource, int streamIndex) throws UnsupportedFormatException, IOException {
        SourceStream stream;
        int format = -1;
        Format fmt = null;
        double clockRate = 90000.0;
        if (dataSource instanceof PushBufferDataSource) {
            stream = ((PushBufferDataSource)dataSource).getStreams()[streamIndex];
            fmt = stream.getFormat();
        } else if (dataSource instanceof PullBufferDataSource) {
            stream = ((PullBufferDataSource)dataSource).getStreams()[streamIndex];
            fmt = stream.getFormat();
        } else {
            throw new IOException("Cannot use stream sources");
        }
        for (Integer id : this.formatMap.keySet()) {
            Format testFormat = (Format)this.formatMap.get(id);
            if (!testFormat.matches(fmt)) continue;
            format = id;
        }
        if (format == -1) {
            throw new UnsupportedFormatException(fmt);
        }
        if (fmt instanceof AudioFormat) {
            clockRate = ((AudioFormat)fmt).getSampleRate();
        }
        Iterator iterator = this.targets.values().iterator();
        RTPConnector connector = (RTPConnector)iterator.next();
        OutputDataStream stream2 = connector.getDataOutputStream();
        return new RTPSendStream((long)(Math.random() * 2.147483647E9), dataSource, stream2, streamIndex, this.localParticipant, format, clockRate);
    }

    public void dispose() {
        this.removeTargets("Quitting");
        this.done = true;
    }

    public Object getControl(String controlClass) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    protected void handleRTPPacket(byte[] data, int offset, int length) {
        try {
            this.globalReceptionStats.addPacketRecd();
            this.globalReceptionStats.addBytesRecd(length);
            RTPHeader header = new RTPHeader(data, offset, length);
            long ssrc = header.getSsrc();
            Integer packetType = (Integer)this.ignoredStreams.get(new Long(ssrc));
            if (packetType != null && packetType.intValue() != header.getPacketType()) {
                this.ignoredStreams.remove(new Long(ssrc));
                packetType = null;
            }
            if (packetType == null) {
                RTPReceiveStream stream = (RTPReceiveStream)this.receiveStreams.get(new Long(ssrc));
                if (stream == null) {
                    short type = header.getPacketType();
                    Format format = (Format)this.formatMap.get(new Integer(type));
                    if (format == null) {
                        this.globalReceptionStats.addUnknownType();
                        logger.warning("Unknown format identifier: " + type);
                        this.ignoredStreams.put(new Long(ssrc), new Integer(type));
                    } else {
                        RTPDataSource dataSource = new RTPDataSource(ssrc, format);
                        stream = new RTPReceiveStream(dataSource, ssrc);
                        this.receiveStreams.put(new Long(ssrc), stream);
                        NewReceiveStreamEvent event = new NewReceiveStreamEvent(this, stream);
                        new ReceiveStreamNotifier(this.receiveStreamListeners, event);
                    }
                }
                if (stream != null) {
                    RTPDataSource dataSource = (RTPDataSource)stream.getDataSource();
                    dataSource.handleRTPPacket(header, data, offset + header.getSize(), length - header.getSize());
                }
            }
        }
        catch (IOException e) {
            this.globalReceptionStats.addBadRTPkt();
        }
    }

    protected void handleRTCPPacket(byte[] data, int offset, int length) {
        try {
            int avgeRTCPSize = this.averageRTCPSize * this.globalReceptionStats.getRTCPRecd();
            this.globalReceptionStats.addRTCPRecd();
            this.globalReceptionStats.addBytesRecd(length);
            this.averageRTCPSize = (avgeRTCPSize + length + 28) / this.globalReceptionStats.getRTCPRecd();
            RTCPHeader header = new RTCPHeader(data, offset, length);
            long ssrc = header.getSsrc();
            RTPReceiveStream stream = (RTPReceiveStream)this.receiveStreams.get(new Long(ssrc));
            RTCPReport report = null;
            RemoteEvent remoteEvent = null;
            if (header.getPacketType() == 200) {
                report = new RTCPSenderReport(data, offset, length);
                ((RTCPSenderReport)report).setStream(stream);
                remoteEvent = new SenderReportEvent(this, (SenderReport)((Object)report));
                this.globalReceptionStats.addSRRecd();
            }
            if (header.getPacketType() == 201) {
                report = new RTCPReceiverReport(data, offset, length);
                remoteEvent = new ReceiverReportEvent(this, (RTCPReceiverReport)report);
            }
            if (report != null) {
                String cname = report.getCName();
                if (cname == null) {
                    cname = (String)this.senders.get(new Long(ssrc));
                }
                if (stream != null) {
                    stream.setReport(report);
                }
                if (cname != null) {
                    RTPEvent event;
                    this.senders.put(new Long(ssrc), cname);
                    RTPRemoteParticipant participant = (RTPRemoteParticipant)this.activeParticipants.get(cname);
                    if (participant == null) {
                        participant = (RTPRemoteParticipant)this.inactiveParticipants.get(cname);
                    }
                    if (participant == null) {
                        participant = new RTPRemoteParticipant(cname);
                        this.getEventLock();
                        event = new NewParticipantEvent(this, participant);
                        new SessionNotifier(this.sessionListeners, (SessionEvent)event);
                        this.inactiveParticipants.put(cname, participant);
                    }
                    report.setParticipant(participant);
                    participant.addReport(report);
                    if (report.isByePacket()) {
                        participant.removeStream(stream);
                        this.getEventLock();
                        new ReceiveStreamNotifier(this.receiveStreamListeners, new ByeEvent(this, participant, stream, report.getByeReason(), participant.getStreams().size() == 0));
                        if (participant.getStreams().size() == 0) {
                            this.activeParticipants.remove(cname);
                            this.inactiveParticipants.put(cname, participant);
                        }
                    } else if (stream != null) {
                        if (!this.activeParticipants.containsKey(cname)) {
                            this.inactiveParticipants.remove(cname);
                            this.activeParticipants.put(cname, participant);
                        }
                        if (stream.getParticipant() == null) {
                            participant.addStream(stream);
                            stream.setParticipant(participant);
                            this.getEventLock();
                            event = new StreamMappedEvent(this, stream, participant);
                            new ReceiveStreamNotifier(this.receiveStreamListeners, (ReceiveStreamEvent)event);
                        }
                    }
                }
            } else {
                throw new IOException("Unknown report type: " + header.getPacketType());
            }
            this.getEventLock();
            new RemoteNotifier(this.remoteListeners, remoteEvent);
        }
        catch (IOException e) {
            this.globalReceptionStats.addBadRTCPPkt();
        }
    }

    public int initSession(SessionAddress localAddress, long defaultSSRC, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        this.initialize(new SessionAddress[]{localAddress}, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction, null);
        return 0;
    }

    public int initSession(SessionAddress localAddress, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        this.initialize(new SessionAddress[]{localAddress}, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction, null);
        return 0;
    }

    public int startSession(SessionAddress destAddress, int mcastScope, EncryptionInfo encryptionInfo) throws IOException {
        this.addTarget(destAddress);
        return 0;
    }

    public int startSession(SessionAddress localReceiverAddress, SessionAddress localSenderAddress, SessionAddress remoteReceiverAddress, EncryptionInfo encryptionInfo) throws IOException {
        this.addTarget(remoteReceiverAddress);
        return 0;
    }

    public long getDefaultSSRC() {
        return 0L;
    }

    public RTPStream getStream(long filterssrc) {
        return null;
    }

    public int getMulticastScope() {
        return 127;
    }

    public void setMulticastScope(int multicastScope) {
    }

    public void closeSession(String reason) {
        this.removeTargets(reason);
    }

    public String generateCNAME() {
        return this.localParticipant.getCNAME();
    }

    public long generateSSRC() {
        return (long)(Math.random() * 2.147483647E9);
    }

    public SessionAddress getSessionAddress() {
        return null;
    }

    public SessionAddress getRemoteSessionAddress() {
        return null;
    }

    public SessionAddress getLocalSessionAddress() {
        return this.localAddress;
    }

    public SendStream createSendStream(int ssrc, DataSource ds, int streamindex) throws UnsupportedFormatException, IOException {
        return this.createSendStream(ds, streamindex);
    }

    public int startSession(int mcastScope, EncryptionInfo encryptionInfo) {
        return -1;
    }

    public void addPeer(SessionAddress peerAddress) throws IOException {
        this.addTarget(peerAddress);
    }

    public void removePeer(SessionAddress peerAddress) {
        this.removeTarget(peerAddress, "Leaving");
    }

    public void removeAllPeers() {
        this.removeTargets("Leaving");
    }

    public Vector getPeers() {
        return this.getAllParticipants();
    }

    public void start() {
        long delay = (long)(Math.random() * 1000.0) + 500L;
        this.rtcpTimer.schedule((TimerTask)new RTCPTimerTask(this), delay);
        this.globalReceptionStats.resetBytesRecd();
        this.lastRTCPSendTime = System.currentTimeMillis();
    }

    private long calculateRTCPDelay() {
        long delay = 5000L;
        double bandwidth = (double)this.globalReceptionStats.getBytesRecd() / (double)(System.currentTimeMillis() - this.lastRTCPSendTime);
        if (bandwidth < 0.1) {
            delay = 5000L;
        } else {
            double senderFraction = 0.0;
            if (this.activeParticipants.size() > 0 || this.inactiveParticipants.size() > 0) {
                senderFraction = this.activeParticipants.size() / (this.inactiveParticipants.size() + this.activeParticipants.size());
            }
            delay = this.activeParticipants.size() > 0 && senderFraction < 0.25 ? (this.localParticipant.getStreams().size() > 0 ? (long)((double)(this.averageRTCPSize * this.activeParticipants.size()) / (bandwidth * this.rtcpSenderBandwidthFraction)) : (long)((double)(this.averageRTCPSize * this.inactiveParticipants.size()) / (bandwidth * this.rtcpReceiverBandwidthFraction))) : (long)((double)(this.averageRTCPSize * (this.activeParticipants.size() + this.inactiveParticipants.size())) / (bandwidth * (this.rtcpSenderBandwidthFraction + this.rtcpReceiverBandwidthFraction)));
            if (delay < 5000L) {
                delay = 5000L;
            }
        }
        return delay;
    }

    private int writeSDESHeader(DataOutputStream output, int ssrcs, int size) throws IOException {
        int packetSize = size + 5 + 4 * ssrcs;
        int padding = 4 - packetSize % 4;
        if (padding == 4) {
            padding = 0;
        }
        packetSize += padding;
        int pBit = 0;
        if (padding > 0) {
            pBit = 32;
        }
        output.writeByte(0x80 | pBit | ssrcs & 0x1F);
        output.writeByte(202);
        output.writeShort(packetSize / 4 - 1);
        return padding;
    }

    private void writeSDES(DataOutputStream output, Vector sdesItems, long ssrc) throws IOException {
        output.writeInt((int)(ssrc & 0xFFFFFFFFFFFFFFFFL));
        for (int i = 0; i < sdesItems.size(); ++i) {
            SourceDescription sdes = (SourceDescription)sdesItems.get(i);
            int type = sdes.getType();
            String description = sdes.getDescription();
            byte[] desc = description.getBytes("UTF-8");
            output.writeByte(type & 0xFF);
            output.writeByte(desc.length & 0xFF);
            output.write(desc);
        }
        output.writeByte(0);
    }

    public void sendRTCPPacket() {
        int rc = this.receiveStreams.size();
        if (rc > 31) {
            rc = 31;
        }
        long delay = this.calculateRTCPDelay();
        long now = System.currentTimeMillis();
        if (now < this.lastRTCPSendTime + delay) {
            this.rtcpTimer.schedule((TimerTask)new RTCPTimerTask(this), this.lastRTCPSendTime + delay - now);
        } else {
            this.lastRTCPSendTime = System.currentTimeMillis();
            this.globalReceptionStats.resetBytesRecd();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(bytes);
            try {
                int packetType = 201;
                int packetSize = rc * 24 + 8;
                if (this.localParticipant.getStreams().size() > 0) {
                    packetType = 200;
                    packetSize += 20;
                }
                output.writeByte(0x80 | rc & 0x1F);
                output.writeByte(packetType & 0xFF);
                output.writeShort(packetSize / 4 - 1);
                output.writeInt((int)(ssrc & 0xFFFFFFFFFFFFFFFFL));
                if (this.localParticipant.getStreams().size() > 0) {
                    packetType = 200;
                    int senderIndex = (int)(Math.random() * (double)this.localParticipant.getStreams().size());
                    RTPSendStream sendStream = (RTPSendStream)this.localParticipant.getStreams().get(senderIndex);
                    TransmissionStats stats = sendStream.getSourceTransmissionStats();
                    long sendtime = sendStream.getLastSendTime();
                    long sendTimeSeconds = (sendtime += 22089888000000L) / 1000L;
                    long sendTimeFractions = (sendtime - sendTimeSeconds * 1000L) / 1000L * -2L;
                    long timestamp = sendStream.getLastTimestamp();
                    output.writeInt((int)(sendTimeSeconds & 0xFFFFFFFFFFFFFFFFL));
                    output.writeInt((int)(sendTimeFractions & 0xFFFFFFFFFFFFFFFFL));
                    output.writeInt((int)(timestamp & 0xFFFFFFFFFFFFFFFFL));
                    output.writeInt(stats.getPDUTransmitted());
                    output.writeInt(stats.getBytesTransmitted());
                }
                Vector streams = new Vector(this.receiveStreams.values());
                now = System.currentTimeMillis();
                for (int i = 0; i < rc; ++i) {
                    int pos = (int)(Math.random() * (double)streams.size());
                    RTPReceiveStream stream = (RTPReceiveStream)streams.get(pos);
                    RTPReceptionStats stats = (RTPReceptionStats)stream.getSourceReceptionStats();
                    RTPDataSource dataSource = (RTPDataSource)stream.getDataSource();
                    RTPDataStream dataStream = (RTPDataStream)dataSource.getStreams()[0];
                    long streamSSRC = stream.getSSRC();
                    int lossFraction = 0;
                    if (stats.getPDUProcessed() > 0) {
                        lossFraction = 256 * stats.getPDUlost() / stats.getPDUProcessed();
                    }
                    long lastESequence = (long)(stats.getSequenceWrap() * 65535) + dataStream.getLastSequence();
                    long packetsExpected = lastESequence - dataStream.getFirstSequence();
                    int cumulativePacketLoss = (int)(packetsExpected - (long)(stats.getPDUProcessed() + stats.getPDUDuplicate()));
                    long jitter = ((RTPDataSource)stream.getDataSource()).getJitter();
                    long lsrMSW = stream.getLastSRReportTimestampMSW();
                    long lsrLSW = stream.getLastSRReportTimestampLSW();
                    long DLSR = (now - stream.getLastSRReportTime()) * 1000L / 65536L;
                    if (stream.getLastSRReportTime() == 0L) {
                        DLSR = 0L;
                    }
                    output.writeInt((int)(streamSSRC & 0xFFFFFFFFFFFFFFFFL));
                    output.writeByte(lossFraction & 0xFF);
                    output.writeByte(cumulativePacketLoss >> 16 & 0xFF);
                    output.writeShort(cumulativePacketLoss & 0xFFFF);
                    output.writeInt((int)(lastESequence & 0xFFFFFFFFFFFFFFFFL));
                    output.writeInt((int)(jitter & 0xFFFFFFFFFFFFFFFFL));
                    output.writeShort((int)(lsrMSW & 0xFFFFL));
                    output.writeShort((int)(lsrLSW >> 16 & 0xFFFFL));
                    output.writeInt((int)(DLSR & 0xFFFFFFFFFFFFFFFFL));
                    streams.remove(pos);
                }
                if (this.localParticipant.getStreams().size() == 0) {
                    Vector sdesItems = this.localParticipant.getSourceDescription();
                    if (sdesItems.size() > 0) {
                        int padding = this.writeSDESHeader(output, 1, this.localParticipant.getSdesSize());
                        this.writeSDES(output, sdesItems, ssrc);
                        for (int i = 0; i < padding; ++i) {
                            output.writeByte(padding);
                        }
                    }
                } else {
                    int i;
                    Vector sendStreams = this.localParticipant.getStreams();
                    int totalSDES = 0;
                    for (int i2 = 0; i2 < sendStreams.size(); ++i2) {
                        totalSDES += ((RTPSendStream)sendStreams.get(i2)).getSdesSize();
                    }
                    int padding = this.writeSDESHeader(output, sendStreams.size(), totalSDES);
                    for (i = 0; i < sendStreams.size(); ++i) {
                        RTPSendStream sendStream = (RTPSendStream)sendStreams.get(i);
                        this.writeSDES(output, sendStream.getSourceDescription(), sendStream.getSSRC());
                    }
                    for (i = 0; i < padding; ++i) {
                        output.writeByte(padding);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            for (RTPConnector connector : this.targets.values()) {
                try {
                    OutputDataStream outputStream = connector.getControlOutputStream();
                    output.close();
                    bytes.close();
                    byte[] data = bytes.toByteArray();
                    outputStream.write(data, 0, data.length);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            if (!this.done) {
                this.rtcpTimer.schedule((TimerTask)new RTCPTimerTask(this), delay);
            }
        }
    }

    private class RTCPTimerTask
    extends TimerTask {
        private RTPSessionMgr rtpSessionManager = null;

        private RTCPTimerTask(RTPSessionMgr rtpSessionManager) {
            this.rtpSessionManager = rtpSessionManager;
        }

        public void run() {
            this.rtpSessionManager.sendRTCPPacket();
        }
    }

    private class RemoteNotifier
    extends Thread {
        private Vector listeners = null;
        private RemoteEvent event = null;

        private RemoteNotifier(Vector listeners, RemoteEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                RemoteListener listener = (RemoteListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class SessionNotifier
    extends Thread {
        private Vector listeners = null;
        private SessionEvent event = null;

        private SessionNotifier(Vector listeners, SessionEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                SessionListener listener = (SessionListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class ReceiveStreamNotifier
    extends Thread {
        private Vector listeners = null;
        private ReceiveStreamEvent event = null;

        private ReceiveStreamNotifier(Vector listeners, ReceiveStreamEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ReceiveStreamListener listener = (ReceiveStreamListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }
}

