/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.TimerTask;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.rtp.RTPDataStream;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPJitterBuffer;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPVideoDataStream
extends RTPDataStream
implements PushBufferStream {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int MIN_DELAY = 10;
    private static final int MAX_NEG_DELAY = -100;
    private static final int MAX_DROP = 5;
    private int bufferLength = 200;
    private RTPJitterBuffer buffer = null;
    private Buffer[] bufferBuffer = null;
    private int nextBuffer = 0;
    private long firstTimestamp = -1L;
    private long firstSendTime = -1L;
    private int packetsDropped = 0;

    public RTPVideoDataStream(long ssrc, Format format) {
        super(ssrc, format);
        if (format instanceof AudioFormat) {
            this.clockRate = ((AudioFormat)format).getSampleRate();
        }
        this.buffer = new RTPJitterBuffer(this.bufferLength);
        this.buffer.setStatistics(this.receptionStats);
        this.bufferBuffer = new Buffer[this.bufferLength + 1];
    }

    private long calculateDelay(long timestamp) {
        if (this.firstSendTime == -1L) {
            this.firstSendTime = System.currentTimeMillis() + (long)this.threshold;
            this.firstTimestamp = timestamp;
            return this.threshold;
        }
        if (this.firstTimestamp > timestamp) {
            this.firstSendTime = (long)((double)this.firstSendTime + -1000.0 / this.clockRate);
        }
        long delay = (long)((double)(timestamp - this.firstTimestamp) * 1000.0 / this.clockRate);
        return delay -= System.currentTimeMillis() - this.firstSendTime;
    }

    protected void addPacket(RTPHeader header, byte[] data, int offset, int length) {
        int sequence = header.getSequence();
        long timestamp = header.getTimestamp();
        this.calculateJitter(timestamp);
        if (this.firstSequence == -1L) {
            this.firstSequence = sequence;
        }
        if ((long)sequence < this.lastSequence && 65535L - this.lastSequence < 100L) {
            this.receptionStats.addSequenceWrap();
        }
        this.lastSequence = sequence;
        if (this.bufferBuffer[this.nextBuffer] == null) {
            this.bufferBuffer[this.nextBuffer] = new Buffer();
        }
        Buffer buffer = this.bufferBuffer[this.nextBuffer];
        this.nextBuffer = (this.nextBuffer + 1) % this.bufferBuffer.length;
        buffer.setData(data);
        buffer.setOffset(offset);
        buffer.setLength(length);
        buffer.setTimeStamp(timestamp);
        buffer.setSequenceNumber(sequence);
        int flags = 4352;
        if (header.getMarker() == 1) {
            flags |= 0x800;
        }
        buffer.setFlags(flags);
        if (this.buffer.add(buffer)) {
            this.packetsDropped = 0;
            if (this.buffer.size() == 1) {
                this.firstSendTime = System.currentTimeMillis() + (long)this.threshold;
                this.firstTimestamp = timestamp;
                this.timer.schedule((TimerTask)new RTPTimerTask(this), this.threshold);
            }
        } else {
            ++this.packetsDropped;
            if (this.packetsDropped == 5) {
                this.bufferLength *= 2;
                this.buffer = new RTPJitterBuffer(this.bufferLength);
                this.buffer.setStatistics(this.receptionStats);
                this.bufferBuffer = new Buffer[this.bufferLength + 1];
            }
            --this.nextBuffer;
            if (this.nextBuffer < 0) {
                this.nextBuffer = this.bufferBuffer.length - 1;
            }
        }
    }

    public void read(Buffer buffer) {
        Buffer data = this.buffer.remove();
        if (data != null && buffer != null) {
            buffer.setData(data.getData());
            buffer.setOffset(data.getOffset());
            buffer.setLength(data.getLength());
            buffer.setTimeStamp(data.getTimeStamp());
            buffer.setSequenceNumber(data.getSequenceNumber());
            buffer.setFlags(data.getFlags());
            buffer.setFormat(this.format);
        } else {
            logger.finer("Read Empty buffer");
            buffer.setOffset(0);
            buffer.setLength(0);
            buffer.setDiscard(true);
        }
    }

    private void dropPackets() {
        long nextTimestamp = this.buffer.peekTimeStamp();
        while (this.buffer.peekTimeStamp() != -1L && nextTimestamp >= this.buffer.peekTimeStamp()) {
            this.buffer.remove();
        }
    }

    private void sendData() {
        long nextTimestamp = this.buffer.peekTimeStamp();
        while (this.buffer.peekTimeStamp() != -1L && nextTimestamp >= this.buffer.peekTimeStamp()) {
            if (this.handler != null) {
                this.handler.transferData(this);
                continue;
            }
            this.buffer.remove();
        }
    }

    public void run() {
        this.sendData();
        boolean scheduled = false;
        boolean endofdata = false;
        while (!scheduled && !endofdata) {
            long timestamp = this.buffer.peekTimeStamp();
            if (timestamp != -1L) {
                long delay = this.calculateDelay(timestamp);
                if (delay > 10L) {
                    this.timer.schedule((TimerTask)new RTPTimerTask(this), delay);
                    scheduled = true;
                    continue;
                }
                if (delay < -100L) {
                    this.dropPackets();
                    continue;
                }
                this.sendData();
                continue;
            }
            endofdata = true;
        }
    }

    private class RTPTimerTask
    extends TimerTask {
        private RTPVideoDataStream stream;

        private RTPTimerTask(RTPVideoDataStream stream) {
            this.stream = stream;
        }

        public void run() {
            this.stream.run();
        }
    }
}

