/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;

public class SimpleSocketInputStream
extends Thread
implements PushSourceStream {
    private DatagramSocket socket = null;
    private boolean done = false;
    private SourceTransferHandler handler = null;
    private boolean dataRead = false;

    public SimpleSocketInputStream(DatagramSocket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] buffer, int offset, int length) {
        try {
            DatagramPacket packet = new DatagramPacket(buffer, offset, length);
            this.socket.receive(packet);
            SimpleSocketInputStream simpleSocketInputStream = this;
            synchronized (simpleSocketInputStream) {
                this.dataRead = true;
                this.notify();
            }
            return packet.getLength();
        }
        catch (IOException e) {
            SimpleSocketInputStream simpleSocketInputStream = this;
            synchronized (simpleSocketInputStream) {
                this.notify();
            }
            return 0;
        }
    }

    public int getMinimumTransferSize() {
        return 2048;
    }

    public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
        this.handler = transferHandler;
        if (this.handler != null) {
            this.dataRead = true;
            this.notify();
        }
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return this.done;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public void start() {
        super.start();
        if (this.handler != null) {
            this.dataRead = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            SimpleSocketInputStream simpleSocketInputStream = this;
            synchronized (simpleSocketInputStream) {
                while (!this.dataRead && !this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.dataRead = false;
                if (!this.done && this.handler != null) {
                    this.handler.transferData(this);
                }
            }
        }
    }

    public void kill() {
        this.done = true;
        this.socket.close();
    }
}

