/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;

public class ImageToBuffer {
    public static Buffer createBuffer(Image image, float frameRate) {
        int blue;
        int green;
        int red;
        int bitsPerPixel;
        Class dataType;
        int pixelsLength;
        Object[] pixels;
        BufferedImage bi = image instanceof BufferedImage ? (BufferedImage)image : ImageToBuffer.convert(image);
        DataBuffer dataBuffer = bi.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            int[] intPixels;
            pixels = intPixels = ((DataBufferInt)dataBuffer).getData();
            pixelsLength = intPixels.length;
            dataType = Format.intArray;
        } else if (dataBuffer instanceof DataBufferByte) {
            byte[] bytePixels = ((DataBufferByte)dataBuffer).getData();
            pixels = bytePixels;
            pixelsLength = bytePixels.length;
            dataType = Format.byteArray;
        } else {
            throw new IllegalArgumentException("Unknown or unsupported data buffer type: " + dataBuffer);
        }
        int bufferedImageType = bi.getType();
        Buffer result = new Buffer();
        Dimension size = new Dimension(bi.getWidth(), bi.getHeight());
        int maxDataLength = -1;
        if (bufferedImageType == 5) {
            bitsPerPixel = 24;
            red = 1;
            green = 2;
            blue = 3;
        } else if (bufferedImageType == 4) {
            bitsPerPixel = 32;
            red = 255;
            green = 65280;
            blue = 0xFF0000;
        } else if (bufferedImageType == 1) {
            bitsPerPixel = 32;
            red = 0xFF0000;
            green = 65280;
            blue = 255;
        } else if (bufferedImageType == 2) {
            bitsPerPixel = 32;
            red = 0xFF0000;
            green = 65280;
            blue = 255;
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type: " + bufferedImageType);
        }
        result.setFormat(new RGBFormat(size, -1, dataType, frameRate, bitsPerPixel, red, green, blue));
        result.setData(pixels);
        result.setLength(pixelsLength);
        result.setOffset(0);
        return result;
    }

    private static BufferedImage convert(Image im) {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }
}

