/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.qt.media.content.unknown;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.StandardControlPanel;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.qt.utils.QTSessionCheck;
import net.sf.fmj.utility.LoggerSingleton;
import quicktime.QTException;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTFactory;
import quicktime.app.view.QTJComponent;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.media.DataRef;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private Movie m;
    private MovieController mc;
    private QTJComponent qtcMovieController = null;
    private QTJComponent qtcMovie = null;

    public void createNewMovieFromURL(String theURL) throws QTException {
        logger.fine(theURL);
        DataRef urlMovie = new DataRef(theURL);
        this.m = Movie.fromDataRef((DataRef)urlMovie, (int)1);
        if (this.qtcMovie == null) {
            this.qtcMovie = QTFactory.makeQTJComponent((MoviePlayer)new MoviePlayer(this.m));
        } else {
            this.qtcMovie.setMoviePlayer(new MoviePlayer(this.m));
        }
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        try {
            QTSessionCheck.check();
            this.createNewMovieFromURL(source.getLocator().toExternalForm());
        }
        catch (QTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IncompatibleSourceException();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException();
        }
        super.setSource(source);
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime" + t);
        try {
            this.m.setTime(new TimeRecord(this.m.getTimeScale(), (long)(t.getSeconds() * (double)this.m.getTimeScale())));
        }
        catch (StdQTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
        catch (QTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
    }

    public float doPlayerSetRate(float rate) {
        logger.info("Handler.doPlayerSetRate " + rate);
        try {
            return rate;
        }
        catch (StdQTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            return this.getRate();
        }
    }

    public boolean doPlayerStop() {
        logger.info("Handler.doPlayerStop");
        try {
            if (this.m != null) {
                this.m.stop();
            }
        }
        catch (QTException err) {
            logger.log(Level.WARNING, "" + (Object)((Object)err), err);
            return false;
        }
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        logger.info("Handler.doPlayerSyncStart" + t);
        try {
            this.m.start();
        }
        catch (StdQTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            return false;
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        if (this.m != null) {
            try {
                double totalSeconds = (double)this.m.getDuration() / (double)this.m.getTimeScale();
                return new Time(totalSeconds);
            }
            catch (StdQTException e) {
                logger.log(Level.WARNING, "" + (Object)((Object)e), e);
                return DURATION_UNKNOWN;
            }
        }
        return DURATION_UNKNOWN;
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        if (this.m != null) {
            try {
                double totalSeconds = (double)this.m.getTime() / (double)this.m.getTimeScale();
                return new Time(totalSeconds);
            }
            catch (StdQTException e) {
                logger.log(Level.WARNING, "" + (Object)((Object)e), e);
                return super.getMediaTime();
            }
        }
        return super.getMediaTime();
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        if (this.qtcMovie == null) {
            return null;
        }
        return this.qtcMovie.asJComponent();
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = new StandardControlPanel(this, 67);
            this.setControlPanelComponent(c);
        }
        return c;
    }
}

