/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.theora_java;

import com.fluendo.jheora.Colorspace;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.util.ImageToBuffer;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.theora_java.jheora.utils.YUVConverter;

public class JavaOggParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean ENABLE_VIDEO = true;
    private static final boolean ENABLE_AUDIO = true;
    private final SyncState oy = new SyncState();
    private final Page og = new Page();
    private StreamState vo = new StreamState();
    private StreamState to = new StreamState();
    private final com.fluendo.jheora.Info ti = new com.fluendo.jheora.Info();
    private final com.fluendo.jheora.Comment tc = new com.fluendo.jheora.Comment();
    private final State td = new State();
    private final Info vi = new Info();
    private final DspState vd = new DspState();
    private final Block vb = new Block(this.vd);
    private Comment vc = new Comment();
    private int theora_p = 0;
    private int vorbis_p = 0;
    private int stateflag = 0;
    private int videobuf_ready = 0;
    private long videobuf_granulepos = -1L;
    private double videobuf_time = 0.0;
    private int audiobuf_fill = 0;
    private int audiobuf_ready = 0;
    private short[] audiobuf;
    private long audiobuf_granulepos = 0L;
    private int audiofd_fragsize;
    private final Packet op = new Packet();
    private final boolean USE_DATASOURCE_URL_ONLY = false;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.ogg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg"), new ContentDescriptor("application.x_ogg")};
    private static final Object OGG_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private FileInputStream infile;
    private PullSourceStream instream;
    private boolean eomAudio;
    private boolean eomVideo;
    private int videoFrameNo = -1;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    private int buffer_data(SyncState oy) throws IOException {
        return this.buffer_data(this.instream, oy);
    }

    private int buffer_data(FileInputStream in, SyncState oy) throws IOException {
        int BUFSIZE = 4096;
        byte[] buffer2 = oy.data;
        int fill = oy.buffer(4096);
        int bytes = in.read(buffer2, fill, 4096);
        if (bytes < 0) {
            return bytes;
        }
        oy.wrote(bytes);
        return bytes;
    }

    private int buffer_data(PullSourceStream in, SyncState oy) throws IOException {
        int BUFSIZE = 4096;
        byte[] buffer2 = oy.data;
        int fill = oy.buffer(4096);
        int bytes = in.read(buffer2, fill, 4096);
        if (bytes < 0) {
            return bytes;
        }
        oy.wrote(bytes);
        return bytes;
    }

    private static int dump_comments(com.fluendo.jheora.Comment tc) {
        logger.info("Encoded by " + tc.vendor);
        if (tc.user_comments != null && tc.user_comments.length > 0) {
            logger.info("theora comment header:");
            for (int i = 0; i < tc.user_comments.length; ++i) {
                if (tc.user_comments[i] == null) continue;
                String value = tc.user_comments[i];
                logger.info("\t" + value);
            }
        }
        return 0;
    }

    private static void report_colorspace(com.fluendo.jheora.Info ti) {
        if (ti.colorspace != Colorspace.UNSPECIFIED) {
            if (ti.colorspace == Colorspace.ITU_REC_470M) {
                logger.info("  encoder specified ITU Rec 470M (NTSC) color.");
            } else if (ti.colorspace == Colorspace.ITU_REC_470BG) {
                logger.info("  encoder specified ITU Rec 470BG (PAL) color.");
            } else {
                logger.warning("warning: encoder specified unknown colorspace (" + ti.colorspace + ")");
            }
        }
    }

    private int queue_page(Page page) {
        if (this.theora_p != 0) {
            this.to.pagein(this.og);
        }
        if (this.vorbis_p != 0) {
            this.vo.pagein(this.og);
        }
        return 0;
    }

    private void resetVars() {
        this.theora_p = 0;
        this.vorbis_p = 0;
        this.stateflag = 0;
        this.videobuf_ready = 0;
        this.videobuf_granulepos = -1L;
        this.videobuf_time = 0.0;
        this.audiobuf_fill = 0;
        this.audiobuf_ready = 0;
        this.audiobuf = null;
        this.audiobuf_granulepos = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        System.out.println("OPEN!");
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            this.resetVars();
            try {
                int ret;
                this.source.connect();
                this.source.start();
                this.instream = this.source.getStreams()[0];
                this.oy.init();
                this.vi.init();
                this.vc.init();
                block5: while (this.stateflag == 0 && (ret = this.buffer_data(this.oy)) > 0) {
                    while (this.oy.pageout(this.og) > 0) {
                        StreamState test = new StreamState();
                        if (this.og.bos() == 0) {
                            this.queue_page(this.og);
                            this.stateflag = 1;
                            continue block5;
                        }
                        test.init(this.og.serialno());
                        test.pagein(this.og);
                        test.packetout(this.op);
                        if (this.theora_p == 0 && this.ti.decodeHeader(this.tc, this.op) >= 0) {
                            this.to = test;
                            this.theora_p = 1;
                            continue;
                        }
                        if (this.vorbis_p == 0 && this.vi.synthesis_headerin(this.vc, this.op) >= 0) {
                            this.vo = test;
                            this.vorbis_p = 1;
                            continue;
                        }
                        test.clear();
                    }
                }
                while (this.theora_p != 0 && this.theora_p < 3 || this.vorbis_p != 0 && this.vorbis_p < 3) {
                    while (this.theora_p != 0 && this.theora_p < 3 && (ret = this.to.packetout(this.op)) != 0) {
                        if (ret < 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        if (this.ti.decodeHeader(this.tc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        ++this.theora_p;
                        if (this.theora_p != 3) continue;
                    }
                    while (this.vorbis_p != 0 && this.vorbis_p < 3 && (ret = this.vo.packetout(this.op)) != 0) {
                        if (ret < 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        if (this.vi.synthesis_headerin(this.vc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        ++this.vorbis_p;
                        if (this.vorbis_p != 3) continue;
                    }
                    if (this.oy.pageout(this.og) > 0) {
                        this.queue_page(this.og);
                        continue;
                    }
                    int ret2 = this.buffer_data(this.oy);
                    if (ret2 > 0) continue;
                    throw new ResourceUnavailableException("End of file while searching for codec headers.");
                }
                if (this.theora_p != 0) {
                    this.td.decodeInit(this.ti);
                    double fps = (double)this.ti.fps_numerator / (double)this.ti.fps_denominator;
                    logger.info("Ogg logical stream " + Integer.toHexString(JavaOggParser.getSerialNo(this.to)) + " is Theora " + this.ti.width + "x" + this.ti.height + " " + fps + " fps");
                    if (this.ti.width != this.ti.frame_width || this.ti.height != this.ti.frame_height) {
                        logger.warning("  Frame content is " + this.ti.frame_width + "x" + this.ti.frame_height + " with offset (" + this.ti.offset_x + "," + this.ti.offset_y + ").");
                    }
                    JavaOggParser.report_colorspace(this.ti);
                    JavaOggParser.dump_comments(this.tc);
                } else {
                    this.ti.clear();
                }
                if (this.vorbis_p != 0) {
                    this.vd.synthesis_init(this.vi);
                    this.vb.init(this.vd);
                    logger.info("Ogg logical stream " + Integer.toHexString(JavaOggParser.getSerialNo(this.vo)) + " is Vorbis " + this.vi.channels + " channel " + this.vi.rate + " Hz audio.");
                } else {
                    this.vi.clear();
                }
                this.stateflag = 0;
                VideoTrack videoTrack = null;
                AudioTrack audioTrack = null;
                if (this.theora_p != 0) {
                    videoTrack = new VideoTrack();
                }
                if (this.vorbis_p != 0) {
                    audioTrack = new AudioTrack();
                }
                if (audioTrack == null && videoTrack == null) {
                    throw new ResourceUnavailableException("No audio or video track found");
                }
                this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.vorbis_p != 0) {
                this.vo.clear();
                this.vb.clear();
                this.vd.clear();
                this.vi.clear();
            }
            if (this.theora_p != 0) {
                this.to.clear();
                this.td.clear();
                this.ti.clear();
            }
            this.oy.clear();
            try {
                if (this.infile != null) {
                    this.infile.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            this.resetVars();
        }
        super.close();
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public static VideoFormat convertCodecPixelFormat(com.fluendo.jheora.Info ti) {
        Dimension size = new Dimension(ti.width, ti.height);
        int maxDataLength = ti.width * ti.height;
        Class<int[]> dataType = int[].class;
        int bitsPerPixel = 32;
        float frameRate = (float)ti.fps_numerator / (float)ti.fps_denominator;
        int bufferedImageType = 2;
        int red = 0xFF0000;
        int green = 65280;
        int blue = 255;
        return new RGBFormat(size, maxDataLength, dataType, frameRate, 32, red, green, blue);
    }

    public static AudioFormat convertCodecAudioFormat(Info vi) {
        return new AudioFormat("LINEAR", vi.rate, 16, vi.channels, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextVideoBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            while (this.theora_p != 0 && this.videobuf_ready == 0 && this.to.packetout(this.op) > 0) {
                ++this.videoFrameNo;
                int ret = this.td.decodePacketin(this.op);
                if (ret < 0) {
                    throw new IOException("decodePacketin failed: " + ret);
                }
                this.videobuf_granulepos = this.td.granulepos;
                this.videobuf_time = this.td.granuleTime(this.videobuf_granulepos);
                if (this.videobuf_time == 0.0) {
                    this.videobuf_time = (double)this.videoFrameNo * (double)this.ti.fps_denominator / (double)this.ti.fps_numerator;
                }
                this.videobuf_ready = 1;
            }
            if (this.videobuf_ready == 0) {
                int bytes = this.buffer_data(this.oy);
                if (bytes < 0) {
                    this.eomVideo = true;
                }
                while (this.oy.pageout(this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.theora_p == 0 || this.videobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextAudioBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            while (this.vorbis_p != 0 && this.audiobuf_ready == 0) {
                float[][][] pcm = new float[1][][];
                int[] index = new int[this.vi.channels];
                int ret = this.vd.synthesis_pcmout((float[][][])pcm, index);
                if (ret > 0) {
                    int i;
                    float[][] floatArrays = pcm[0];
                    int count = this.audiobuf_fill / 2;
                    int maxsamples = (this.audiofd_fragsize - this.audiobuf_fill) / 2 / this.vi.channels;
                    for (i = 0; i < ret && i < maxsamples; ++i) {
                        for (int j = 0; j < this.vi.channels; ++j) {
                            int val = Math.round(floatArrays[j][index[j] + i] * 32767.0f);
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            }
                            if (val < Short.MIN_VALUE) {
                                val = Short.MIN_VALUE;
                            }
                            this.audiobuf[count++] = (short)val;
                        }
                    }
                    this.vd.synthesis_read(i);
                    this.audiobuf_fill += i * this.vi.channels * 2;
                    if (this.audiobuf_fill != this.audiofd_fragsize) continue;
                    this.audiobuf_ready = 1;
                    continue;
                }
                if (this.vo.packetout(this.op) <= 0) break;
                if (this.vb.synthesis(this.op) != 0) continue;
                this.vd.synthesis_blockin(this.vb);
            }
            if (this.audiobuf_ready == 0) {
                int bytes = this.buffer_data(this.oy);
                if (bytes < 0) {
                    this.eomAudio = true;
                }
                while (this.oy.pageout(this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.vorbis_p == 0 || this.audiobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    static int getSerialNo(StreamState ss) {
        return -1;
    }

    static /* synthetic */ short[] access$1102(JavaOggParser x0, short[] x1) {
        x0.audiobuf = x1;
        return x1;
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack() throws ResourceUnavailableException {
            JavaOggParser.this.audiofd_fragsize = 10000;
            JavaOggParser.access$1102(JavaOggParser.this, new short[JavaOggParser.this.audiofd_fragsize / 2]);
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = JavaOggParser.convertCodecAudioFormat(JavaOggParser.this.vi);
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    JavaOggParser.this.nextAudioBuffer();
                }
                catch (IOException e) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(e);
                }
                if (JavaOggParser.this.stateflag == 0) {
                    buffer.setEOM(JavaOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                if (JavaOggParser.this.audiobuf_ready == 0) {
                    buffer.setEOM(JavaOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                byte[] data = new byte[JavaOggParser.this.audiobuf.length * 2];
                for (int i = 0; i < JavaOggParser.this.audiobuf.length; ++i) {
                    data[i * 2] = (byte)(JavaOggParser.this.audiobuf[i] & 0xFF);
                    data[i * 2 + 1] = (byte)(JavaOggParser.this.audiobuf[i] >> 8 & 0xFF);
                }
                buffer.setData(data);
                buffer.setLength(data.length);
                buffer.setOffset(0);
                buffer.setEOM(false);
                buffer.setDiscard(false);
                buffer.setTimeStamp(System.currentTimeMillis());
                JavaOggParser.this.audiobuf_fill = 0;
                JavaOggParser.this.audiobuf_ready = 0;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final VideoFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack() throws ResourceUnavailableException {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = JavaOggParser.convertCodecPixelFormat(JavaOggParser.this.ti);
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    JavaOggParser.this.nextVideoBuffer();
                }
                catch (IOException e) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(e);
                }
                if (JavaOggParser.this.stateflag != 0 && JavaOggParser.this.videobuf_ready != 0) {
                    YUVBuffer yuv = new YUVBuffer();
                    JavaOggParser.this.td.decodeYUVout(yuv);
                    BufferedImage bi = YUVConverter.toBufferedImage((YUVBuffer)yuv, (com.fluendo.jheora.Info)JavaOggParser.this.ti);
                    Buffer b = ImageToBuffer.createBuffer(bi, this.format.getFrameRate());
                    buffer.setData(b.getData());
                    buffer.setLength(b.getLength());
                    buffer.setOffset(b.getOffset());
                    buffer.setEOM(false);
                    buffer.setDiscard(false);
                    buffer.setTimeStamp((long)JavaOggParser.secondsToNanos(JavaOggParser.this.videobuf_time));
                    JavaOggParser.this.videobuf_ready = 0;
                } else {
                    buffer.setEOM(JavaOggParser.this.eomVideo);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomVideo) {
                        buffer.setDiscard(true);
                    }
                }
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

