/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.theora_java;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.util.ImageToBuffer;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.theora_java.jna.OggLibrary;
import net.sf.theora_java.jna.TheoraLibrary;
import net.sf.theora_java.jna.VorbisLibrary;
import net.sf.theora_java.jna.XiphLibrary;
import net.sf.theora_java.jna.utils.YUVConverter;

public class NativeOggParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private final TheoraLibrary THEORA;
    private final OggLibrary OGG;
    private final VorbisLibrary VORBIS;
    private static final boolean ENABLE_VIDEO = true;
    private static final boolean ENABLE_AUDIO = true;
    private final OggLibrary.ogg_sync_state oy = new OggLibrary.ogg_sync_state();
    private final OggLibrary.ogg_page og = new OggLibrary.ogg_page();
    private OggLibrary.ogg_stream_state vo = new OggLibrary.ogg_stream_state();
    private OggLibrary.ogg_stream_state to = new OggLibrary.ogg_stream_state();
    private final TheoraLibrary.theora_info ti = new TheoraLibrary.theora_info();
    private final TheoraLibrary.theora_comment tc = new TheoraLibrary.theora_comment();
    private final TheoraLibrary.theora_state td = new TheoraLibrary.theora_state();
    private final VorbisLibrary.vorbis_info vi = new VorbisLibrary.vorbis_info();
    private final VorbisLibrary.vorbis_dsp_state vd = new VorbisLibrary.vorbis_dsp_state();
    private final VorbisLibrary.vorbis_block vb = new VorbisLibrary.vorbis_block();
    private VorbisLibrary.vorbis_comment vc = new VorbisLibrary.vorbis_comment();
    private int theora_p = 0;
    private int vorbis_p = 0;
    private int stateflag = 0;
    private int videobuf_ready = 0;
    private long videobuf_granulepos = -1L;
    private double videobuf_time = 0.0;
    private int audiobuf_fill = 0;
    private int audiobuf_ready = 0;
    private short[] audiobuf;
    private long audiobuf_granulepos = 0L;
    private int audiofd_fragsize;
    private final XiphLibrary.ogg_packet op = new XiphLibrary.ogg_packet();
    private final boolean USE_DATASOURCE_URL_ONLY = false;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.ogg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg"), new ContentDescriptor("application.x_ogg")};
    private static final Object OGG_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private FileInputStream infile;
    private PullSourceStream instream;
    private boolean eomAudio;
    private boolean eomVideo;
    private int videoFrameNo = -1;

    public NativeOggParser() {
        try {
            this.THEORA = TheoraLibrary.INSTANCE;
            this.OGG = OggLibrary.INSTANCE;
            this.VORBIS = VorbisLibrary.INSTANCE;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to initialize ffmpeg libraries: " + t);
            throw new RuntimeException(t);
        }
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    private int buffer_data(OggLibrary.ogg_sync_state oy) throws IOException {
        return this.buffer_data(this.instream, oy);
    }

    private int buffer_data(FileInputStream in, OggLibrary.ogg_sync_state oy) throws IOException {
        int BUFSIZE = 4096;
        Pointer buffer = this.OGG.ogg_sync_buffer(oy, new NativeLong(4096L));
        byte[] buffer2 = new byte[4096];
        int bytes = in.read(buffer2, 0, 4096);
        if (bytes < 0) {
            return bytes;
        }
        buffer.write(0, buffer2, 0, bytes);
        this.OGG.ogg_sync_wrote(oy, new NativeLong((long)bytes));
        return bytes;
    }

    private int buffer_data(PullSourceStream in, OggLibrary.ogg_sync_state oy) throws IOException {
        int BUFSIZE = 4096;
        Pointer buffer = this.OGG.ogg_sync_buffer(oy, new NativeLong(4096L));
        byte[] buffer2 = new byte[4096];
        int bytes = in.read(buffer2, 0, 4096);
        if (bytes < 0) {
            return bytes;
        }
        buffer.write(0, buffer2, 0, bytes);
        this.OGG.ogg_sync_wrote(oy, new NativeLong((long)bytes));
        return bytes;
    }

    int dump_comments(TheoraLibrary.theora_comment tc) {
        logger.info("Encoded by " + tc.vendor.getString(0));
        if (tc.comments > 0) {
            logger.info("theora comment header:");
            for (int i = 0; i < tc.comments; ++i) {
                Pointer[] user_comments = tc.user_comments.getPointerArray(0, tc.comments);
                int[] comment_lengths = tc.comment_lengths.getIntArray(0, tc.comments);
                if (user_comments[i] == null) continue;
                int len = comment_lengths[i];
                String value = new String(user_comments[i].getByteArray(0, len));
                logger.info("\t" + value);
            }
        }
        return 0;
    }

    static void report_colorspace(TheoraLibrary.theora_info ti) {
        switch (ti.colorspace) {
            case 0: {
                break;
            }
            case 1: {
                logger.info("  encoder specified ITU Rec 470M (NTSC) color.");
                break;
            }
            case 2: {
                logger.info("  encoder specified ITU Rec 470BG (PAL) color.");
                break;
            }
            default: {
                logger.warning("warning: encoder specified unknown colorspace (" + ti.colorspace + ")");
            }
        }
    }

    int queue_page(OggLibrary.ogg_page page) {
        if (this.theora_p != 0) {
            this.OGG.ogg_stream_pagein(this.to, this.og);
        }
        if (this.vorbis_p != 0) {
            this.OGG.ogg_stream_pagein(this.vo, this.og);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            try {
                int ret;
                this.source.connect();
                this.source.start();
                this.instream = this.source.getStreams()[0];
                this.OGG.ogg_sync_init(this.oy);
                this.VORBIS.vorbis_info_init(this.vi);
                this.VORBIS.vorbis_comment_init(this.vc);
                this.THEORA.theora_comment_init(this.tc);
                this.THEORA.theora_info_init(this.ti);
                block10: while (this.stateflag == 0 && (ret = this.buffer_data(this.oy)) > 0) {
                    while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                        OggLibrary.ogg_stream_state test = new OggLibrary.ogg_stream_state();
                        if (this.OGG.ogg_page_bos(this.og) == 0) {
                            this.queue_page(this.og);
                            this.stateflag = 1;
                            continue block10;
                        }
                        this.OGG.ogg_stream_init(test, this.OGG.ogg_page_serialno(this.og));
                        this.OGG.ogg_stream_pagein(test, this.og);
                        this.OGG.ogg_stream_packetout(test, this.op);
                        if (this.theora_p == 0 && this.THEORA.theora_decode_header(this.ti, this.tc, this.op) >= 0) {
                            this.to = test;
                            this.theora_p = 1;
                            continue;
                        }
                        if (this.vorbis_p == 0 && this.VORBIS.vorbis_synthesis_headerin(this.vi, this.vc, this.op) >= 0) {
                            this.vo = test;
                            this.vorbis_p = 1;
                            continue;
                        }
                        this.OGG.ogg_stream_clear(test);
                    }
                }
                while (this.theora_p != 0 && this.theora_p < 3 || this.vorbis_p != 0 && this.vorbis_p < 3) {
                    while (this.theora_p != 0 && this.theora_p < 3 && (ret = this.OGG.ogg_stream_packetout(this.to, this.op)) != 0) {
                        if (ret < 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        if (this.THEORA.theora_decode_header(this.ti, this.tc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        ++this.theora_p;
                        if (this.theora_p != 3) continue;
                    }
                    while (this.vorbis_p != 0 && this.vorbis_p < 3 && (ret = this.OGG.ogg_stream_packetout(this.vo, this.op)) != 0) {
                        if (ret < 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        if (this.VORBIS.vorbis_synthesis_headerin(this.vi, this.vc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        ++this.vorbis_p;
                        if (this.vorbis_p != 3) continue;
                    }
                    if (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                        this.queue_page(this.og);
                        continue;
                    }
                    int ret2 = this.buffer_data(this.oy);
                    if (ret2 > 0) continue;
                    throw new ResourceUnavailableException("End of file while searching for codec headers.");
                }
                if (this.theora_p != 0) {
                    this.THEORA.theora_decode_init(this.td, this.ti);
                    double fps = (double)this.ti.fps_numerator / (double)this.ti.fps_denominator;
                    logger.info("Ogg logical stream " + Integer.toHexString(this.to.serialno.intValue()) + " is Theora " + this.ti.width + "x" + this.ti.height + " " + fps + " fps");
                    switch (this.ti.pixelformat) {
                        case 0: {
                            logger.info(" 4:2:0 video");
                            break;
                        }
                        case 2: {
                            logger.info(" 4:2:2 video");
                            break;
                        }
                        case 3: {
                            logger.info(" 4:4:4 video");
                            break;
                        }
                        default: {
                            logger.info(" video\n  (UNKNOWN Chroma sampling!)");
                        }
                    }
                    if (this.ti.width != this.ti.frame_width || this.ti.height != this.ti.frame_height) {
                        logger.warning("  Frame content is " + this.ti.frame_width + "x" + this.ti.frame_height + " with offset (" + this.ti.offset_x + "," + this.ti.offset_y + ").");
                    }
                    NativeOggParser.report_colorspace(this.ti);
                    this.dump_comments(this.tc);
                } else {
                    this.THEORA.theora_info_clear(this.ti);
                    this.THEORA.theora_comment_clear(this.tc);
                }
                if (this.vorbis_p != 0) {
                    this.VORBIS.vorbis_synthesis_init(this.vd, this.vi);
                    this.VORBIS.vorbis_block_init(this.vd, this.vb);
                    logger.info("Ogg logical stream " + Integer.toHexString(this.vo.serialno.intValue()) + " is Vorbis " + this.vi.channels + " channel " + this.vi.rate.intValue() + " Hz audio.");
                } else {
                    this.VORBIS.vorbis_info_clear(this.vi);
                    this.VORBIS.vorbis_comment_clear(this.vc);
                }
                this.stateflag = 0;
                VideoTrack videoTrack = null;
                AudioTrack audioTrack = null;
                if (this.theora_p != 0) {
                    videoTrack = new VideoTrack();
                }
                if (this.vorbis_p != 0) {
                    audioTrack = new AudioTrack();
                }
                if (audioTrack == null && videoTrack == null) {
                    throw new ResourceUnavailableException("No audio or video track found");
                }
                this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.vorbis_p != 0) {
                this.OGG.ogg_stream_clear(this.vo);
                this.VORBIS.vorbis_block_clear(this.vb);
                this.VORBIS.vorbis_dsp_clear(this.vd);
                this.VORBIS.vorbis_comment_clear(this.vc);
                this.VORBIS.vorbis_info_clear(this.vi);
            }
            if (this.theora_p != 0) {
                this.OGG.ogg_stream_clear(this.to);
                this.THEORA.theora_clear(this.td);
                this.THEORA.theora_comment_clear(this.tc);
                this.THEORA.theora_info_clear(this.ti);
            }
            this.OGG.ogg_sync_clear(this.oy);
            try {
                if (this.infile != null) {
                    this.infile.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }
        super.close();
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public static VideoFormat convertCodecPixelFormat(TheoraLibrary.theora_info ti) {
        Dimension size = new Dimension(ti.width, ti.height);
        int maxDataLength = ti.width * ti.height;
        Class<int[]> dataType = int[].class;
        int bitsPerPixel = 32;
        float frameRate = (float)ti.fps_numerator / (float)ti.fps_denominator;
        boolean bufferedImageType = true;
        int red = 0xFF0000;
        int green = 65280;
        int blue = 255;
        return new RGBFormat(size, maxDataLength, dataType, frameRate, 32, red, green, blue);
    }

    public static AudioFormat convertCodecAudioFormat(VorbisLibrary.vorbis_info vi) {
        return new AudioFormat("LINEAR", vi.rate.floatValue(), 16, vi.channels, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextVideoBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            while (this.theora_p != 0 && this.videobuf_ready == 0 && this.OGG.ogg_stream_packetout(this.to, this.op) > 0) {
                ++this.videoFrameNo;
                int ret = this.THEORA.theora_decode_packetin(this.td, this.op);
                if (ret < 0) {
                    throw new IOException("theora_decode_packetin failed: " + ret);
                }
                this.videobuf_granulepos = this.td.granulepos;
                this.videobuf_time = this.THEORA.theora_granule_time(this.td, this.videobuf_granulepos);
                if (this.videobuf_time == 0.0) {
                    this.videobuf_time = (double)this.videoFrameNo * (double)this.ti.fps_denominator / (double)this.ti.fps_numerator;
                }
                this.videobuf_ready = 1;
            }
            if (this.videobuf_ready == 0) {
                int bytes = this.buffer_data(this.oy);
                if (bytes < 0) {
                    this.eomVideo = true;
                }
                while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.theora_p == 0 || this.videobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextAudioBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            while (this.vorbis_p != 0 && this.audiobuf_ready == 0) {
                PointerByReference pcm = new PointerByReference();
                int ret = this.VORBIS.vorbis_synthesis_pcmout(this.vd, pcm);
                if (ret > 0) {
                    int i;
                    Pointer ppChannels = pcm.getValue();
                    Pointer[] pChannels = ppChannels.getPointerArray(0, this.vi.channels);
                    float[][] floatArrays = new float[pChannels.length][];
                    for (int k = 0; k < pChannels.length; ++k) {
                        floatArrays[k] = pChannels[k].getFloatArray(0, ret);
                    }
                    int count = this.audiobuf_fill / 2;
                    int maxsamples = (this.audiofd_fragsize - this.audiobuf_fill) / 2 / this.vi.channels;
                    for (i = 0; i < ret && i < maxsamples; ++i) {
                        for (int j = 0; j < this.vi.channels; ++j) {
                            int val = Math.round(floatArrays[j][i] * 32767.0f);
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            }
                            if (val < Short.MIN_VALUE) {
                                val = Short.MIN_VALUE;
                            }
                            this.audiobuf[count++] = (short)val;
                        }
                    }
                    this.VORBIS.vorbis_synthesis_read(this.vd, i);
                    this.audiobuf_fill += i * this.vi.channels * 2;
                    if (this.audiobuf_fill == this.audiofd_fragsize) {
                        this.audiobuf_ready = 1;
                    }
                    if (this.vd.granulepos >= 0L) {
                        this.audiobuf_granulepos = this.vd.granulepos - (long)ret + (long)i;
                        continue;
                    }
                    this.audiobuf_granulepos += (long)i;
                    continue;
                }
                if (this.OGG.ogg_stream_packetout(this.vo, this.op) <= 0) break;
                if (this.VORBIS.vorbis_synthesis(this.vb, this.op) != 0) continue;
                this.VORBIS.vorbis_synthesis_blockin(this.vd, this.vb);
            }
            if (this.audiobuf_ready == 0) {
                int bytes = this.buffer_data(this.oy);
                if (bytes < 0) {
                    this.eomAudio = true;
                }
                while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.vorbis_p == 0 || this.audiobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    static /* synthetic */ short[] access$1202(NativeOggParser x0, short[] x1) {
        x0.audiobuf = x1;
        return x1;
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack() throws ResourceUnavailableException {
            NativeOggParser.this.audiofd_fragsize = 10000;
            NativeOggParser.access$1202(NativeOggParser.this, new short[NativeOggParser.this.audiofd_fragsize / 2]);
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = NativeOggParser.convertCodecAudioFormat(NativeOggParser.this.vi);
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    NativeOggParser.this.nextAudioBuffer();
                }
                catch (IOException e) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(e);
                }
                if (NativeOggParser.this.stateflag == 0) {
                    buffer.setEOM(NativeOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                if (NativeOggParser.this.audiobuf_ready == 0) {
                    buffer.setEOM(NativeOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                byte[] data = new byte[NativeOggParser.this.audiobuf.length * 2];
                for (int i = 0; i < NativeOggParser.this.audiobuf.length; ++i) {
                    data[i * 2] = (byte)(NativeOggParser.this.audiobuf[i] & 0xFF);
                    data[i * 2 + 1] = (byte)(NativeOggParser.this.audiobuf[i] >> 8 & 0xFF);
                }
                buffer.setData(data);
                buffer.setLength(data.length);
                buffer.setOffset(0);
                buffer.setEOM(false);
                buffer.setDiscard(false);
                buffer.setTimeStamp(System.currentTimeMillis());
                NativeOggParser.this.audiobuf_fill = 0;
                NativeOggParser.this.audiobuf_ready = 0;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final VideoFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack() throws ResourceUnavailableException {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = NativeOggParser.convertCodecPixelFormat(NativeOggParser.this.ti);
            }
        }

        public void deallocate() {
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    NativeOggParser.this.nextVideoBuffer();
                }
                catch (IOException e) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(e);
                }
                if (NativeOggParser.this.stateflag != 0 && NativeOggParser.this.videobuf_ready != 0) {
                    TheoraLibrary.yuv_buffer yuv = new TheoraLibrary.yuv_buffer();
                    NativeOggParser.this.THEORA.theora_decode_YUVout(NativeOggParser.this.td, yuv);
                    BufferedImage bi = YUVConverter.toBufferedImage((TheoraLibrary.yuv_buffer)yuv, (TheoraLibrary.theora_info)NativeOggParser.this.ti);
                    Buffer b = ImageToBuffer.createBuffer(bi, this.format.getFrameRate());
                    buffer.setData(b.getData());
                    buffer.setLength(b.getLength());
                    buffer.setOffset(b.getOffset());
                    buffer.setEOM(false);
                    buffer.setDiscard(false);
                    buffer.setTimeStamp((long)NativeOggParser.secondsToNanos(NativeOggParser.this.videobuf_time));
                    NativeOggParser.this.videobuf_ready = 0;
                } else {
                    buffer.setEOM(NativeOggParser.this.eomVideo);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomVideo) {
                        buffer.setDiscard(true);
                    }
                }
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

