/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui;

import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.ui.application.PlayerPanel;
import net.sf.fmj.ui.dialogs.AboutPanel;
import net.sf.fmj.ui.registry.RegistryEditorPanel;
import net.sf.fmj.utility.ClasspathChecker;
import net.sf.fmj.utility.JmfUtility;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.OSUtils;

public class FmjStudio {
    private static final Logger logger = LoggerSingleton.logger;
    private JFrame frame;
    private JFrame registryFrame;
    private PlayerPanel playerPanel;

    private void run(String[] args) {
        this.frame = new JFrame("FMJ Studio");
        this.frame.setSize(new Dimension(640, 480));
        this.frame.setDefaultCloseOperation(3);
        Container contentPane = this.frame.getContentPane();
        this.playerPanel = new PlayerPanel();
        contentPane.add(this.playerPanel);
        this.frame.setMenuBar(this.getMenuBar());
        this.playerPanel.getVideoPanel().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                FmjStudio.this.frame.pack();
            }

            public void componentRemoved(ContainerEvent e) {
                FmjStudio.this.frame.pack();
            }
        });
        this.frame.setVisible(true);
        if (args.length > 0) {
            String url = args[0];
            this.playerPanel.addMediaLocatorAndLoad(url);
        }
    }

    private final MenuBar getMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu();
        menuFile.setLabel("File");
        menuBar.add(menuFile);
        MenuItem menuItemOpenFile = new MenuItem("Open File...");
        menuItemOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onOpenFile();
            }
        });
        menuFile.add(menuItemOpenFile);
        MenuItem menuItemOpenURL = new MenuItem("Open URL...");
        menuItemOpenURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onOpenURL();
            }
        });
        menuFile.add(menuItemOpenURL);
        MenuItem menuItemReceiveRTP = new MenuItem("Open RTP Session...");
        menuItemReceiveRTP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onReceiveRTP();
            }
        });
        menuFile.add(menuItemReceiveRTP);
        MenuItem menuItemOpenCaptureDevice = new MenuItem("Capture...");
        menuItemOpenCaptureDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onOpenCaptureDevice();
            }
        });
        menuFile.add(menuItemOpenCaptureDevice);
        menuFile.addSeparator();
        MenuItem menuItemTransmitRTP = new MenuItem("Transmit RTP...");
        menuItemTransmitRTP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onTransmitRTP();
            }
        });
        menuFile.add(menuItemTransmitRTP);
        MenuItem menuItemTranscode = new MenuItem("Transcode...");
        menuItemTranscode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.playerPanel.onTranscode();
            }
        });
        menuFile.add(menuItemTranscode);
        menuFile.addSeparator();
        MenuItem menuItemRegistryEditor = new MenuItem("Registry Editor...");
        menuItemRegistryEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.onOpenRegistryEditor();
            }
        });
        menuFile.add(menuItemRegistryEditor);
        MenuItem menuItemExit = new MenuItem("Exit");
        menuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FmjStudio.this.onExit();
            }
        });
        menuFile.add(menuItemExit);
        Menu menuPlayer = new Menu();
        menuPlayer.setLabel("Player");
        menuBar.add(menuPlayer);
        final CheckboxMenuItem menuItemAutoPlay = new CheckboxMenuItem("Auto-play");
        menuItemAutoPlay.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FmjStudio.this.playerPanel.onAutoPlay(menuItemAutoPlay.getState());
            }
        });
        menuPlayer.add(menuItemAutoPlay);
        menuItemAutoPlay.setState(this.playerPanel.getPrefs().autoPlay);
        final CheckboxMenuItem menuItemAutoLoop = new CheckboxMenuItem("Auto-loop");
        menuItemAutoLoop.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FmjStudio.this.playerPanel.onAutoLoop(menuItemAutoLoop.getState());
            }
        });
        menuPlayer.add(menuItemAutoLoop);
        this.playerPanel.onAutoLoop(false);
        menuItemAutoLoop.setState(this.playerPanel.getPrefs().autoLoop);
        menuItemAutoLoop.setEnabled(false);
        Menu menuHelp = new Menu();
        menuHelp.setLabel("Help");
        menuBar.add(menuHelp);
        MenuItem menuItemHelpAbout = new MenuItem("About...");
        menuItemHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutPanel.run(FmjStudio.this.frame);
            }
        });
        menuHelp.add(menuItemHelpAbout);
        return menuBar;
    }

    private void onOpenRegistryEditor() {
        if (this.registryFrame == null) {
            this.registryFrame = new JFrame("Registry Editor");
            RegistryEditorPanel panel = new RegistryEditorPanel();
            Container contentPane = this.registryFrame.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)panel, "Center");
            this.registryFrame.setSize(640, 480);
        }
        this.registryFrame.setVisible(true);
    }

    private void onExit() {
        if (this.registryFrame != null) {
            this.registryFrame.dispose();
        }
        this.frame.dispose();
    }

    public static void main(String[] args) {
        try {
            System.setProperty("java.util.logging.config.file", "logging.properties");
            LogManager.getLogManager().readConfiguration();
            if (!ClasspathChecker.checkAndWarn()) {
                logger.info("Enabling JMF logging");
                if (!JmfUtility.enableLogging()) {
                    logger.warning("Failed to enable JMF logging");
                }
                logger.info("Registering FMJ prefixes and plugins with JMF");
                RegistryDefaults.registerAll(2);
            }
            if (OSUtils.isMacOSX()) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FMJ Studio");
            }
            FmjStudio main = new FmjStudio();
            main.run(args);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "" + t, t);
        }
    }
}

