/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.MediaTimeSetEvent;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;
import net.sf.fmj.ui.application.ContainerPlayerStatusListener;
import net.sf.fmj.ui.control.TransportControl;
import net.sf.fmj.ui.control.TransportControlListener;
import net.sf.fmj.ui.control.TransportControlState;
import net.sf.fmj.utility.ClasspathChecker;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class ContainerPlayer
implements TransportControl,
SourcedTimerListener,
TimeSource {
    private static final Logger logger = LoggerSingleton.logger;
    private Container container;
    private volatile Player player;
    private Component visualComponent;
    private boolean shouldStartOnRealize = false;
    private volatile boolean autoLoop = false;
    private MouseListener mouseListener;
    private String mediaLocation;
    private TransportControlState transportControlState = new TransportControlState();
    private SourcedTimer controlTimer;
    private static final int TIMER_TICK = 250;
    private ControllerListener controllerListener = new ControllerListener(){

        public void controllerUpdate(ControllerEvent event) {
            logger.fine("Got controller event: " + event);
            Player player = (Player)event.getSourceController();
            if (player != ContainerPlayer.this.player) {
                return;
            }
            if (event instanceof RealizeCompleteEvent) {
                ContainerPlayer.this.notifyStatusListener("Ready.");
                try {
                    ContainerPlayer.this.setVisualComponent(player.getVisualComponent());
                    if (ContainerPlayer.this.shouldStartOnRealize) {
                        ContainerPlayer.this.start();
                    }
                }
                catch (Exception e) {
                    ContainerPlayer.this.notifyStatusListener("Error displaying player.");
                    logger.log(Level.WARNING, "" + e, e);
                    JLabel label = new JLabel("");
                    ContainerPlayer.this.setVisualComponent(label);
                }
            } else if (event instanceof ResourceUnavailableEvent) {
                ContainerPlayer.this.notifyStatusListener("Error loading to media.");
                JLabel label = new JLabel("");
                ContainerPlayer.this.setVisualComponent(label);
            } else if (event instanceof StopEvent) {
                ContainerPlayer.this.notifyStatusListener("Stopped.");
                ContainerPlayer.this.transportControlState.setAllowPlay(true);
                ContainerPlayer.this.transportControlState.setAllowStop(false);
                ContainerPlayer.this.transportControlState.setAllowVolume(false);
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onStateChange(ContainerPlayer.this.transportControlState);
                }
            } else if (event instanceof StartEvent) {
                ContainerPlayer.this.notifyStatusListener("Playing...");
                ContainerPlayer.this.transportControlState.setAllowPlay(false);
                ContainerPlayer.this.transportControlState.setAllowStop(true);
                ContainerPlayer.this.transportControlState.setAllowVolume(player.getGainControl() != null);
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onStateChange(ContainerPlayer.this.transportControlState);
                }
            } else if (event instanceof ControllerErrorEvent) {
                ContainerPlayer.this.notifyStatusListener("Error: " + ((ControllerErrorEvent)event).getMessage());
            } else if (event instanceof ControllerClosedEvent) {
                // empty if block
            }
            if (event instanceof StartEvent || event instanceof RestartingEvent) {
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onDurationChange(player.getDuration().getNanoseconds());
                }
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onProgressChange(ContainerPlayer.this.getTime());
                }
                ContainerPlayer.this.controlTimer.start();
            } else if (event instanceof StopEvent || event instanceof ControllerErrorEvent) {
                ContainerPlayer.this.controlTimer.stop();
            } else if (event instanceof MediaTimeSetEvent) {
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onDurationChange(player.getDuration().getNanoseconds());
                }
                if (ContainerPlayer.this.transportControlListener != null) {
                    ContainerPlayer.this.transportControlListener.onProgressChange(ContainerPlayer.this.getTime());
                }
            }
            if (event instanceof EndOfMediaEvent) {
                ContainerPlayer.this.notifyStatusListener("End of media.");
                player.setMediaTime(new Time(0L));
                if (ContainerPlayer.this.autoLoop) {
                    ContainerPlayer.this.start();
                }
            }
        }
    };
    private TransportControlListener transportControlListener;
    private ContainerPlayerStatusListener statusListener;

    private void notifyStatusListener(String status) {
        if (this.statusListener != null) {
            this.statusListener.onStatusChange(status);
        }
    }

    public ContainerPlayer(Container container) {
        this.setContainer(container);
    }

    public void setMediaLocation(String mediaLocation, boolean startAutomatically) throws NoDataSourceException, NoPlayerException, IOException {
        logger.fine("setMediaLocation: " + mediaLocation + " startAutomatically=" + startAutomatically);
        try {
            MediaLocator locator = new MediaLocator(mediaLocation);
            this.stop();
            if (this.player != null) {
                this.player.close();
                this.player.deallocate();
                this.player = null;
            }
            this.notifyStatusListener("Loading...");
            if (startAutomatically) {
                this.shouldStartOnRealize = true;
            }
            this.createNewPlayer(locator);
        }
        catch (NoPlayerException e) {
            this.notifyStatusListener("Error loading media.");
            throw e;
        }
        catch (IOException e) {
            this.notifyStatusListener("Error loading media.");
            throw e;
        }
        catch (RuntimeException e) {
            this.notifyStatusListener("Error loading media.");
            throw e;
        }
    }

    public void setRealizedStartedProcessor(Processor p) {
        this.stop();
        if (this.player != null) {
            this.player.close();
            this.player.deallocate();
            this.player = null;
        }
        this.notifyStatusListener("Processing...");
        this.useExistingRealizedStartedPlayer(p);
    }

    public void start() {
        if (this.player != null) {
            this.shouldStartOnRealize = false;
            this.player.start();
        } else {
            this.shouldStartOnRealize = true;
        }
    }

    public void stop() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void setPosition(double seconds) {
        this.setMediaTime(new Time(seconds));
    }

    public void setRate(float rate) {
        if (this.player != null) {
            this.player.setRate(rate);
        }
    }

    public void deallocate() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.deallocate();
            this.player = null;
        }
    }

    public void close() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.close();
        }
    }

    public void setMediaTime(Time time) {
        if (this.player != null) {
            this.player.setMediaTime(time);
        }
    }

    private void createNewPlayer(MediaLocator source) throws NoPlayerException, IOException {
        String newUrl;
        if (!ClasspathChecker.check() && source.getProtocol().equals("file") && (newUrl = URLUtils.createAbsoluteFileUrl(source.toExternalForm())) != null) {
            MediaLocator newSource = new MediaLocator(newUrl);
            if (!source.toExternalForm().equals(newSource.toExternalForm())) {
                logger.warning("Changing file URL to absolute for JMF, from " + source.toExternalForm() + " to " + newSource);
                source = newSource;
            }
        }
        this.player = Manager.createPlayer(source);
        this.transportControlState.setAllowPlay(true);
        this.transportControlState.setAllowStop(false);
        this.transportControlState.setAllowVolume(false);
        if (this.transportControlListener != null) {
            this.transportControlListener.onStateChange(this.transportControlState);
        }
        this.controlTimer = new SourcedTimer((TimeSource)this, 250);
        this.controlTimer.addSourcedTimerListener(this);
        if (this.player.getState() == 600) {
            if (this.transportControlListener != null) {
                this.transportControlListener.onDurationChange(this.player.getDuration().getNanoseconds());
            }
            this.controlTimer.start();
        }
        this.player.addControllerListener(this.controllerListener);
        this.player.realize();
    }

    private void useExistingRealizedStartedPlayer(Player p) {
        this.player = p;
        this.transportControlState.setAllowPlay(false);
        this.transportControlState.setAllowStop(true);
        this.transportControlState.setAllowVolume(false);
        if (this.transportControlListener != null) {
            this.transportControlListener.onStateChange(this.transportControlState);
        }
        this.controlTimer = new SourcedTimer((TimeSource)this, 250);
        this.controlTimer.addSourcedTimerListener(this);
        if (this.player.getState() == 600) {
            if (this.transportControlListener != null) {
                this.transportControlListener.onDurationChange(this.player.getDuration().getNanoseconds());
            }
            this.controlTimer.start();
        }
        this.player.addControllerListener(this.controllerListener);
    }

    private void setVisualComponent(final Component newVisualComponent) {
        if (this.visualComponent == newVisualComponent) {
            return;
        }
        if (this.getMouseListener() != null) {
            newVisualComponent.addMouseListener(this.getMouseListener());
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ContainerPlayer.this.visualComponent != null) {
                    ContainerPlayer.this.getContainer().remove(ContainerPlayer.this.visualComponent);
                }
                ContainerPlayer.this.visualComponent = newVisualComponent;
                if (newVisualComponent != null) {
                    ContainerPlayer.this.getContainer().add(newVisualComponent);
                }
                ContainerPlayer.this.getContainer().validate();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setContainer(Container container) {
        this.container = container;
    }

    private Container getContainer() {
        return this.container;
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    private MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public void setTransportControlListener(TransportControlListener listener) {
        this.transportControlListener = listener;
    }

    public void setContainerPlayerStatusListener(ContainerPlayerStatusListener listener) {
        this.statusListener = listener;
    }

    public void timerUpdate(SourcedTimerEvent e) {
        if (this.transportControlListener != null) {
            this.transportControlListener.onProgressChange(this.getTime());
        }
    }

    public long getTime() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.getMediaNanoseconds();
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }

    public void setGain(float value) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setLevel(value);
        }
    }

    public void setMute(boolean value) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setMute(value);
        }
    }

    public boolean isAutoLoop() {
        return this.autoLoop;
    }

    public void setAutoLoop(boolean autoLoop) {
        this.autoLoop = autoLoop;
    }
}

