/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import javax.media.protocol.FileTypeDescriptor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.fmj.ui.application.CaptureDeviceBrowser;
import net.sf.fmj.ui.application.ContainerPlayer;
import net.sf.fmj.ui.application.ContainerPlayerStatusListener;
import net.sf.fmj.ui.application.PlayerPanelPrefs;
import net.sf.fmj.ui.control.TransportControlPanel;
import net.sf.fmj.ui.dialogs.RTPReceivePanel;
import net.sf.fmj.ui.dialogs.URLPanel;
import net.sf.fmj.ui.wizards.RTPTransmitWizard;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.TranscodeWizard;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.PathUtils;
import net.sf.fmj.utility.URLUtils;

public class PlayerPanel
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    private PlayerPanelPrefs prefs;
    private JToolBar playerToolBar = null;
    private JButton openButton = null;
    private JButton openCaptureDeviceButton = null;
    private TransportControlPanel transportControlPanel = null;
    private JLabel statusBar = null;
    private JPanel videoPanel = null;
    private JComboBox addressComboBox = null;
    private JButton loadButton = null;
    private JPanel addressPanel = null;
    private JLabel locationLabel = null;
    private ContainerPlayer containerPlayer = null;

    public void addMediaLocatorAndLoad(String url) {
        boolean alreadyThere = false;
        for (int i = 0; i < this.getAddressComboBox().getItemCount(); ++i) {
            if (!this.getAddressComboBox().getItemAt(i).equals(url)) continue;
            alreadyThere = true;
            break;
        }
        if (!alreadyThere) {
            this.getAddressComboBox().addItem(url);
        }
        if (this.getAddressComboBox().getSelectedItem() == null || !this.getAddressComboBox().getSelectedItem().equals(url)) {
            this.getAddressComboBox().setSelectedItem(url);
        } else {
            this.onLoadButtonClick();
        }
    }

    public JPanel getVideoPanel() {
        if (this.videoPanel == null) {
            this.videoPanel = new JPanel();
            this.videoPanel.setLayout(new BorderLayout());
            this.videoPanel.setBackground(SystemColor.controlShadow);
        }
        return this.videoPanel;
    }

    private JComboBox getAddressComboBox() {
        if (this.addressComboBox == null) {
            this.addressComboBox = new JComboBox();
            this.addressComboBox.setEditable(true);
            this.addressComboBox.setPreferredSize(new Dimension(160, 27));
            for (int i = 0; i < this.prefs.recentUrls.size(); ++i) {
                this.addressComboBox.addItem((String)this.prefs.recentUrls.get(i));
            }
            this.addressComboBox.setSelectedIndex(-1);
            this.addressComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    logger.fine("addressComboBox state change: " + e);
                    if (e.getStateChange() == 1) {
                        PlayerPanel.this.onLoadButtonClick();
                    }
                }
            });
        }
        return this.addressComboBox;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setToolTipText("Load selected location");
            this.loadButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/import_wiz.png")));
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PlayerPanel.this.onLoadButtonClick();
                }
            });
        }
        return this.loadButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadButtonClick() {
        String location = (String)this.getAddressComboBox().getSelectedItem();
        if (location.trim().equals("")) {
            this.showError("No URL specified");
            return;
        }
        this.setCursor(new Cursor(3));
        try {
            this.getContainerPlayer().setMediaLocation(location, this.prefs.autoPlay);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            this.showError("" + e);
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        if (!this.prefs.recentUrls.contains(location)) {
            this.prefs.recentUrls.add(0, location);
            this.savePrefs();
        } else if (!this.prefs.recentUrls.get(0).equals(location)) {
            this.prefs.recentUrls.remove(location);
            this.prefs.recentUrls.add(0, location);
            this.savePrefs();
        }
    }

    private void showError(String e) {
        JOptionPane.showConfirmDialog(this, e, "Error", -1, 0);
    }

    private JPanel getAddressPanel() {
        if (this.addressPanel == null) {
            this.locationLabel = new JLabel();
            this.locationLabel.setText("Location:");
            this.addressPanel = new JPanel();
            this.addressPanel.setLayout(new GridBagLayout());
            GridBagConstraints c1 = new GridBagConstraints();
            c1.insets = new Insets(0, 2, 0, 2);
            this.addressPanel.add((Component)this.locationLabel, c1);
            GridBagConstraints c2 = new GridBagConstraints();
            c2.fill = 2;
            c2.weightx = 1.0;
            c2.insets = new Insets(0, 2, 0, 2);
            this.addressPanel.add((Component)this.getAddressComboBox(), c2);
        }
        return this.addressPanel;
    }

    private ContainerPlayer getContainerPlayer() {
        if (this.containerPlayer == null) {
            this.containerPlayer = new ContainerPlayer(this.getVideoPanel());
            this.containerPlayer.setAutoLoop(this.prefs.autoLoop);
            this.containerPlayer.setContainerPlayerStatusListener(new ContainerPlayerStatusListener(){

                public void onStatusChange(final String newStatus) {
                    logger.fine("Status change: " + newStatus);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PlayerPanel.this.statusBar.setText(newStatus);
                        }
                    });
                }
            });
        }
        return this.containerPlayer;
    }

    public PlayerPanel() {
        this.initialize();
    }

    private void initialize() {
        this.loadPrefs();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(363, 218));
        this.add((Component)this.getPlayerToolBar(), "North");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        this.add((Component)southPanel, "South");
        southPanel.add((Component)this.getTransportControlPanel(), "North");
        southPanel.add((Component)this.getStatusBar(), "South");
        this.add((Component)this.getVideoPanel(), "Center");
    }

    private void loadPrefs() {
        try {
            File f = PlayerPanelPrefs.getFile();
            if (!f.exists()) {
                logger.fine("FMJStudio prefs file does not exist.  Using defaults.");
                this.setDefaultPrefs();
                return;
            }
            FileReader reader = new FileReader(f);
            this.prefs = new PlayerPanelPrefs();
            this.prefs.load(reader);
        }
        catch (Exception e) {
            logger.warning("Problem loading FMJStudio prefs: " + e + ".  Using defaults.");
            this.setDefaultPrefs();
        }
    }

    private void setDefaultPrefs() {
        this.prefs = new PlayerPanelPrefs();
        this.prefs.recentUrls.add("http://stream.lrz-muenchen.de:31337/m945-hq.ogg");
        this.prefs.recentUrls.add("http://stream.lrz-muenchen.de:31337/m945-hq.mp3");
        this.prefs.recentUrls.add("file://samplemedia/hen.mp3");
        this.prefs.recentUrls.add("file://samplemedia/lion_roar.mp3");
        this.prefs.recentUrls.add("file://samplemedia/betterway.wav");
        this.prefs.recentUrls.add("file://samplemedia/issues.au");
        this.prefs.recentUrls.add("file://samplemedia/gulp.wav");
        this.prefs.recentUrls.add("file://samplemedia/gulp2.wav");
        this.prefs.recentUrls.add("file://samplemedia/Gloria_Patri.ogg");
        this.prefs.recentUrls.add("file://samplemedia/safexmas.mov");
        this.prefs.recentUrls.add("http://fmj.larsontechnologies.com/samplemedia/Apollo_15_liftoff_from_inside_LM.ogg");
        this.prefs.recentUrls.add("http://www.surfshooterhawaii.com//cgi-bin/axispush555.cgi?dummy=garb");
        this.prefs.recentUrls.add("http://towercam.uu.edu/axis-cgi/mjpg/video.cgi");
        this.prefs.recentUrls.add("http://www.easylife.org/386dx/smells.mp3");
        this.prefs.rtpTransmitWizardConfig.url = "file://samplemedia/gulp2.wav";
        this.prefs.rtpTransmitWizardConfig.trackConfigs = new TrackConfig[]{new TrackConfig(true, new AudioFormat("ULAW/rtp", 8000.0, 8, 1, 0, 1))};
        this.prefs.rtpTransmitWizardConfig.destUrl = "rtp://192.168.1.4:8000/audio/16";
        this.prefs.transcodeWizardConfig.url = "file://samplemedia/gulp2.wav";
        this.prefs.transcodeWizardConfig.contentDescriptor = new FileTypeDescriptor("audio.x_wav");
        this.prefs.transcodeWizardConfig.trackConfigs = new TrackConfig[]{new TrackConfig(true, new AudioFormat("LINEAR", 8000.0, 8, 1, -1, 0))};
        this.prefs.transcodeWizardConfig.destUrl = URLUtils.createUrlStr(new File(PathUtils.getTempPath(), "gulp2-transcoded.wav"));
        this.savePrefs();
    }

    private void savePrefs() {
        try {
            FileWriter fileWriter = new FileWriter(PlayerPanelPrefs.getFile());
            this.prefs.write(fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "savePrefs failed: " + e, e);
        }
    }

    private JToolBar getPlayerToolBar() {
        if (this.playerToolBar == null) {
            this.playerToolBar = new JToolBar();
            this.playerToolBar.setFloatable(false);
            this.playerToolBar.add(this.getOpenButton());
            this.playerToolBar.add(this.getOpenCaptureDeviceButton());
            this.playerToolBar.add(this.getAddressPanel());
            this.playerToolBar.add(this.getLoadButton());
        }
        return this.playerToolBar;
    }

    private JButton getOpenButton() {
        if (this.openButton == null) {
            this.openButton = new JButton();
            this.openButton.setToolTipText("Browse for media file...");
            this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/cvs_folder_rep.png")));
            this.openButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PlayerPanel.this.onOpenFile();
                }
            });
        }
        return this.openButton;
    }

    public void onOpenFile() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) == 0) {
            String urlStr = URLUtils.createUrlStr(chooser.getSelectedFile());
            this.addMediaLocatorAndLoad(urlStr);
        }
    }

    private JButton getOpenCaptureDeviceButton() {
        if (this.openCaptureDeviceButton == null) {
            this.openCaptureDeviceButton = new JButton();
            this.openCaptureDeviceButton.setToolTipText("Select capture device...");
            this.openCaptureDeviceButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/webcam.png")));
            this.openCaptureDeviceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PlayerPanel.this.onOpenCaptureDevice();
                }
            });
        }
        return this.openCaptureDeviceButton;
    }

    public void onOpenCaptureDevice() {
        MediaLocator locator = CaptureDeviceBrowser.run(this.getParentFrame());
        if (locator != null) {
            this.addMediaLocatorAndLoad(locator.toExternalForm());
        }
    }

    private Frame getParentFrame() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        throw new RuntimeException("No parent frame");
    }

    public void onTransmitRTP() {
        RTPTransmitWizard w = new RTPTransmitWizard(this.getParentFrame(), this.prefs.rtpTransmitWizardConfig);
        boolean result = w.run();
        if (result) {
            this.containerPlayer.setRealizedStartedProcessor(w.getResult().processor);
            this.prefs.rtpTransmitWizardConfig = w.getConfig();
            this.savePrefs();
        }
    }

    public void onTranscode() {
        TranscodeWizard w = new TranscodeWizard(this.getParentFrame(), this.prefs.transcodeWizardConfig);
        boolean result = w.run();
        if (result) {
            this.containerPlayer.setRealizedStartedProcessor(w.getResult().processor);
            this.prefs.transcodeWizardConfig = w.getConfig();
            this.savePrefs();
        }
    }

    public void onReceiveRTP() {
        String url = RTPReceivePanel.run(this.getParentFrame());
        if (url == null) {
            return;
        }
        this.addMediaLocatorAndLoad(url);
    }

    public void onOpenURL() {
        String url = URLPanel.run(this.getParentFrame());
        if (url == null) {
            return;
        }
        this.addMediaLocatorAndLoad(url);
    }

    public void onAutoPlay(boolean value) {
        logger.fine("onAutoPlay: " + value);
        this.prefs.autoPlay = value;
        this.savePrefs();
    }

    public void onAutoLoop(boolean value) {
        this.prefs.autoLoop = value;
        if (this.containerPlayer != null) {
            this.containerPlayer.setAutoLoop(value);
        }
        this.savePrefs();
    }

    public PlayerPanelPrefs getPrefs() {
        return this.prefs;
    }

    private TransportControlPanel getTransportControlPanel() {
        if (this.transportControlPanel == null) {
            this.transportControlPanel = new TransportControlPanel();
            this.transportControlPanel.setPlayer(this.getContainerPlayer());
        }
        return this.transportControlPanel;
    }

    private JLabel getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JLabel();
            this.statusBar.setText(" ");
        }
        return this.statusBar;
    }
}

