/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.control;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Duration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.fmj.ui.control.FmjSlider;
import net.sf.fmj.ui.control.TransportControl;
import net.sf.fmj.ui.control.TransportControlListener;
import net.sf.fmj.ui.control.TransportControlState;
import net.sf.fmj.ui.images.Images;

public class TransportControlPanel
extends JPanel
implements TransportControlListener {
    private TransportControl player;
    private JButton playButton = null;
    private JButton stopButton = null;
    private JButton backButton = null;
    private JButton forwardButton = null;
    private JButton nextButton = null;
    private JButton previousButton = null;
    private JPanel positionPanel = null;
    private JSlider positionSlider = null;
    private JPanel buttonPanel = null;
    private JLabel positionLabel = null;
    private JLabel lengthLabel = null;
    private JPanel infoPanel = null;
    private JTextPane infoTextPane = null;
    private JPanel audioPanel = null;
    private JSlider volumeSlider = null;
    private JToggleButton muteButton = null;

    public TransportControlPanel() {
        this.initialize();
    }

    public void setPlayer(TransportControl player) {
        this.player = player;
        player.setTransportControlListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(553, 58));
        this.add((Component)this.getPositionPanel(), "North");
        this.add((Component)this.getButtonPanel(), "West");
        this.add((Component)this.getInfoTextPane(), "Center");
        this.add((Component)this.getAudioPanel(), "East");
        this.setAudioControlEnabled(false);
    }

    private void start() {
        if (this.player != null) {
            this.player.start();
        }
    }

    private void stop() {
        if (this.player != null) {
            this.player.stop();
            this.player.setPosition(0.0);
        }
    }

    private void setRate(float rate) {
        if (this.player != null) {
            this.player.setRate(rate);
        }
    }

    private void setGain(float gain) {
        if (this.player != null) {
            this.player.setGain(gain);
        }
    }

    private void setMute(boolean mute) {
        if (this.player != null) {
            this.player.setMute(mute);
        }
    }

    private JButton getPlayButton() {
        if (this.playButton == null) {
            this.playButton = new JButton();
            this.playButton.setOpaque(false);
            this.playButton.setIcon(Images.get("Play24.gif"));
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransportControlPanel.this.setRate(1.0f);
                    TransportControlPanel.this.start();
                }
            });
            this.playButton.setEnabled(false);
        }
        return this.playButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setOpaque(false);
            this.stopButton.setIcon(Images.get("Stop24.gif"));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransportControlPanel.this.stop();
                }
            });
            this.stopButton.setEnabled(false);
        }
        return this.stopButton;
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setOpaque(false);
            this.backButton.setIcon(Images.get("Rewind24.gif"));
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransportControlPanel.this.setRate(-2.0f);
                }
            });
        }
        return this.backButton;
    }

    private JButton getForwardButton() {
        if (this.forwardButton == null) {
            this.forwardButton = new JButton();
            this.forwardButton.setOpaque(false);
            this.forwardButton.setIcon(Images.get("FastForward24.gif"));
            this.forwardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransportControlPanel.this.setRate(2.0f);
                }
            });
        }
        return this.forwardButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setIcon(Images.get("StepForward24.gif"));
            this.nextButton.setOpaque(false);
        }
        return this.nextButton;
    }

    private JButton getPreviousButton() {
        if (this.previousButton == null) {
            this.previousButton = new JButton();
            this.previousButton.setOpaque(false);
            this.previousButton.setIcon(Images.get("StepBack24.gif"));
        }
        return this.previousButton;
    }

    private JPanel getPositionPanel() {
        if (this.positionPanel == null) {
            this.lengthLabel = new JLabel();
            this.lengthLabel.setText(TransportControlPanel.nanosToString(0L));
            this.lengthLabel.setOpaque(false);
            this.positionLabel = new JLabel();
            this.positionLabel.setText(TransportControlPanel.nanosToString(0L));
            this.positionLabel.setOpaque(false);
            this.positionPanel = new JPanel();
            this.positionPanel.setOpaque(false);
            this.positionPanel.setLayout(new BorderLayout());
            this.positionPanel.add((Component)this.getPositionSlider(), "Center");
            this.positionPanel.add((Component)this.positionLabel, "West");
            this.positionPanel.add((Component)this.lengthLabel, "East");
        }
        return this.positionPanel;
    }

    private JSlider getPositionSlider() {
        if (this.positionSlider == null) {
            this.positionSlider = new FmjSlider();
            this.positionSlider.setOpaque(false);
            this.positionSlider.setValue(0);
            this.positionSlider.setMinimum(0);
            this.positionSlider.setMaximum(60000);
            this.positionSlider.setEnabled(false);
        }
        return this.positionSlider;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setOpaque(false);
            this.buttonPanel.add((Component)this.getPreviousButton(), new GridBagConstraints());
            this.buttonPanel.add((Component)this.getBackButton(), new GridBagConstraints());
            this.buttonPanel.add((Component)this.getStopButton(), new GridBagConstraints());
            this.buttonPanel.add((Component)this.getPlayButton(), new GridBagConstraints());
            this.buttonPanel.add((Component)this.getForwardButton(), new GridBagConstraints());
            this.buttonPanel.add((Component)this.getNextButton(), new GridBagConstraints());
        }
        return this.buttonPanel;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new BorderLayout());
            this.infoPanel.setOpaque(false);
            this.infoPanel.add((Component)this.getInfoTextPane(), "Center");
        }
        return this.infoPanel;
    }

    private JTextPane getInfoTextPane() {
        if (this.infoTextPane == null) {
            this.infoTextPane = new JTextPane();
            this.infoTextPane.setText("<html><body><center>Artist - Album - Title</center></body></html>");
            this.infoTextPane.setContentType("text/html");
            this.infoTextPane.setOpaque(false);
            this.infoTextPane.setFont(new Font("Arial", 0, 13));
            this.infoTextPane.setEditable(false);
        }
        return this.infoTextPane;
    }

    private JPanel getAudioPanel() {
        if (this.audioPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 1.0;
            this.audioPanel = new JPanel();
            this.audioPanel.setLayout(new GridBagLayout());
            this.audioPanel.setOpaque(false);
            this.audioPanel.add((Component)this.getVolumeSlider(), gridBagConstraints);
            this.audioPanel.add((Component)this.getMuteButton(), new GridBagConstraints());
        }
        return this.audioPanel;
    }

    public void setAudioControlEnabled(boolean enabled) {
        this.getVolumeSlider().setEnabled(enabled);
        this.getMuteButton().setEnabled(enabled);
    }

    private JSlider getVolumeSlider() {
        if (this.volumeSlider == null) {
            this.volumeSlider = new JSlider();
            this.volumeSlider.setMinimum(0);
            this.volumeSlider.setMaximum(100);
            this.volumeSlider.setValue(70);
            this.volumeSlider.setPreferredSize(new Dimension(100, 29));
            this.volumeSlider.setOpaque(false);
            this.volumeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!TransportControlPanel.this.volumeSlider.getValueIsAdjusting()) {
                        float newValue = (float)TransportControlPanel.this.volumeSlider.getValue() / 100.0f;
                        TransportControlPanel.this.setGain(newValue);
                    }
                }
            });
        }
        return this.volumeSlider;
    }

    private JToggleButton getMuteButton() {
        if (this.muteButton == null) {
            this.muteButton = new JToggleButton();
            this.muteButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/Volume24.gif")));
            this.muteButton.setOpaque(false);
            this.muteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransportControlPanel.this.setMute(TransportControlPanel.this.muteButton.isSelected());
                }
            });
        }
        return this.muteButton;
    }

    public void onStateChange(TransportControlState state) {
        this.getStopButton().setEnabled(state.isAllowStop());
        this.getPlayButton().setEnabled(state.isAllowPlay());
        this.setAudioControlEnabled(state.isAllowVolume());
    }

    private static int nanosToMillis(long nanos) {
        return (int)(nanos / 1000000L);
    }

    public void onDurationChange(long nanos) {
        if (nanos == Duration.DURATION_UNKNOWN.getNanoseconds() || nanos == Duration.DURATION_UNBOUNDED.getNanoseconds()) {
            this.positionSlider.setEnabled(false);
            this.lengthLabel.setText("");
        } else {
            this.positionSlider.setEnabled(true);
            this.positionSlider.setMinimum(0);
            this.positionSlider.setMaximum(TransportControlPanel.nanosToMillis(nanos));
            this.lengthLabel.setText(TransportControlPanel.nanosToString(nanos));
        }
    }

    public void onProgressChange(long nanos) {
        if (this.positionSlider.isEnabled()) {
            this.positionSlider.setValue(TransportControlPanel.nanosToMillis(nanos));
        }
        this.positionLabel.setText(TransportControlPanel.nanosToString(nanos));
    }

    private static String zeroPad(int i, int len) {
        String result = Integer.toString(i);
        while (result.length() < len) {
            result = "0" + result;
        }
        return result;
    }

    private static String nanosToString(long nanos) {
        long seconds = nanos / 1000000000L;
        long minutes = seconds / 60L;
        return "" + TransportControlPanel.zeroPad((int)minutes, 2) + ":" + TransportControlPanel.zeroPad((int)(seconds % 60L), 2);
    }
}

