/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import net.sf.fmj.ui.control.FmjSlider;
import net.sf.fmj.ui.images.Images;

public class FmjSliderUI
extends BasicSliderUI {
    private final ImageIcon vertIcon;
    private final ImageIcon horizIcon;
    private Dimension vertIconSize = new Dimension(20, 20);
    private Dimension horizIconSize = new Dimension(20, 20);

    public static ComponentUI createUI(JComponent component) {
        return new FmjSliderUI((JSlider)component);
    }

    private FmjSliderUI(JSlider component) {
        super(component);
        this.horizIcon = Images.get("slider_thumb_horiz.png");
        this.horizIconSize = new Dimension(this.horizIcon.getIconWidth(), this.horizIcon.getIconHeight());
        this.vertIcon = Images.get("slider_thumb_vert.png");
        this.vertIconSize = new Dimension(this.vertIcon.getIconWidth(), this.vertIcon.getIconHeight());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void paintThumb(Graphics g) {
        Image image;
        Graphics2D g2d = (Graphics2D)g;
        int orientation = this.slider.getOrientation();
        switch (orientation) {
            case 1: {
                image = this.vertIcon.getImage();
                break;
            }
            default: {
                image = this.horizIcon.getImage();
            }
        }
        g2d.drawImage(image, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, null);
    }

    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.LIGHT_GRAY);
        float x = this.trackRect.x;
        float y = this.trackRect.y;
        float w = this.trackRect.width;
        float h = this.trackRect.height;
        int orientation = this.slider.getOrientation();
        if (orientation == 0) {
            x -= (float)this.trackBuffer;
            w += (float)(2 * this.trackBuffer - 1);
        } else {
            y -= (float)this.trackBuffer;
            h += (float)(2 * this.trackBuffer - 1);
        }
        float arcw = 20.0f;
        float arch = 20.0f;
        RoundRectangle2D.Float rectangle = new RoundRectangle2D.Float(x, y, w, h, arcw, arch);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fill(rectangle);
        g2d.setColor(this.getShadowColor());
        if (orientation == 0) {
            rectangle.setFrame(x, y, w - 1.0f, h - 1.0f);
        } else {
            rectangle.setFrame(x, y, w - 1.0f, h - 1.0f);
        }
        g2d.draw(rectangle);
    }

    public void paintFocus(Graphics g) {
        if (((FmjSlider)this.slider).getPaintFocus()) {
            super.paintFocus(g);
        }
    }

    protected Dimension getThumbSize() {
        int orientation = this.slider.getOrientation();
        if (orientation == 0) {
            return this.horizIconSize;
        }
        return this.vertIconSize;
    }
}

