/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.registry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.PlugInManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.ui.registry.DetailsListener;
import net.sf.fmj.utility.LoggerSingleton;

public class EntryPanel
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    public static final int TYPE_DEMUX = 1;
    public static final int TYPE_CODEC = 2;
    public static final int TYPE_EFFECT = 3;
    public static final int TYPE_RENDERER = 4;
    public static final int TYPE_MUX = 5;
    public static final int TYPE_CONTENT = 10001;
    public static final int TYPE_PROTOCOL = 10002;
    public static final int TYPE_CAPTURE_DEVICE = 10003;
    public static final int TYPE_MIME_TYPES = 10004;
    private final int type;
    private JPanel actionPanel = null;
    private JButton addButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton removeButton = null;
    private JButton commitButton = null;
    private JPanel entryPanel = null;
    private JPanel entryTopPanel = null;
    private JLabel entryLabel = null;
    private JTextField entryTextField = null;
    private JTextField entryTextField2 = null;
    private JList entryList = null;
    private DefaultComboBoxModel entryListModel = null;
    private JScrollPane listScrollPane = null;
    private DetailsListener detailsListener;

    public EntryPanel(int type) {
        this.type = type;
        this.initialize();
    }

    public void setTitle(String title) {
        this.getEntryLabel().setText(title);
    }

    private void addEntry(String entry, String value2) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Format[] in = null;
                Format[] out = null;
                boolean added = PlugInManager.addPlugIn(entry, in, out, this.type);
                if (!added) break;
                this.getEntryListModel().addElement(entry);
                break;
            }
            case 10001: {
                Vector contentList = PackageManager.getContentPrefixList();
                if (contentList.contains(entry)) break;
                contentList.add(entry);
                PackageManager.setContentPrefixList(contentList);
                this.getEntryListModel().addElement(entry);
                break;
            }
            case 10002: {
                Vector protocolList = PackageManager.getProtocolPrefixList();
                if (protocolList.contains(entry)) break;
                protocolList.add(entry);
                PackageManager.setContentPrefixList(protocolList);
                this.getEntryListModel().addElement(entry);
                break;
            }
            case 10003: {
                break;
            }
            case 10004: {
                List<String> existingExtensions = MimeManager.getExtensions(entry);
                if (existingExtensions.contains(value2)) break;
                MimeManager.addMimeType(value2, entry);
                this.getEntryListModel().addElement(entry);
            }
        }
    }

    private void removeEntry(String entry) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Object in = null;
                Object out = null;
                boolean removed = PlugInManager.removePlugIn(entry, this.type);
                if (!removed) break;
                this.getEntryListModel().removeElement(entry);
                break;
            }
            case 10001: {
                Vector contentList = PackageManager.getContentPrefixList();
                if (!contentList.remove(entry)) break;
                PackageManager.setContentPrefixList(contentList);
                this.getEntryListModel().removeElement(entry);
                break;
            }
            case 10002: {
                Vector protocolList = PackageManager.getProtocolPrefixList();
                if (!protocolList.remove(entry)) break;
                PackageManager.setProtocolPrefixList(protocolList);
                this.getEntryListModel().removeElement(entry);
                break;
            }
            case 10003: {
                break;
            }
            case 10004: {
                List<String> extensions = MimeManager.getExtensions(entry);
                int numRemoved = 0;
                if (extensions.size() > 0) {
                    for (int i = 0; i < extensions.size(); ++i) {
                        if (!MimeManager.removeMimeType(extensions.get(i))) continue;
                        ++numRemoved;
                    }
                }
                if (numRemoved <= 0) break;
                this.getEntryListModel().removeElement(entry);
            }
        }
    }

    private void commit() {
        try {
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Vector plugins = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object value = this.getEntryListModel().getElementAt(i);
                        plugins.add(value);
                    }
                    PlugInManager.setPlugInList(plugins, this.type);
                    PlugInManager.commit();
                    break;
                }
                case 10001: {
                    Vector contentPrefixes = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object value = this.getEntryListModel().getElementAt(i);
                        contentPrefixes.add(value);
                    }
                    PackageManager.setContentPrefixList(contentPrefixes);
                    PackageManager.commitContentPrefixList();
                    break;
                }
                case 10002: {
                    Vector protocolPrefixes = new Vector();
                    for (int i = 0; i < this.getEntryListModel().getSize(); ++i) {
                        Object value = this.getEntryListModel().getElementAt(i);
                        protocolPrefixes.add(value);
                    }
                    PackageManager.setProtocolPrefixList(protocolPrefixes);
                    PackageManager.commitProtocolPrefixList();
                    break;
                }
                case 10003: {
                    CaptureDeviceManager.commit();
                    break;
                }
                case 10004: {
                    MimeManager.commit();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    void load() {
        Vector list = null;
        this.getEntryListModel().removeAllElements();
        switch (this.type) {
            case 1: {
                list = PlugInManager.getPlugInList(null, null, 1);
                this.setTitle("Demultiplexer");
                break;
            }
            case 2: {
                list = PlugInManager.getPlugInList(null, null, 2);
                this.setTitle("Codec");
                break;
            }
            case 3: {
                list = PlugInManager.getPlugInList(null, null, 3);
                this.setTitle("Effect");
                break;
            }
            case 4: {
                list = PlugInManager.getPlugInList(null, null, 4);
                this.setTitle("Renderer");
                break;
            }
            case 5: {
                list = PlugInManager.getPlugInList(null, null, 5);
                this.setTitle("Multiplexer");
                break;
            }
            case 10001: {
                list = PackageManager.getContentPrefixList();
                this.setTitle("Content Prefix List");
                break;
            }
            case 10002: {
                list = PackageManager.getProtocolPrefixList();
                this.setTitle("Protocol Prefix List");
                break;
            }
            case 10003: {
                list = new Vector();
                Vector captureDeviceList = CaptureDeviceManager.getDeviceList(null);
                for (int i = 0; i < captureDeviceList.size(); ++i) {
                    CaptureDeviceInfo info = (CaptureDeviceInfo)captureDeviceList.get(i);
                    list.add(info.getLocator().toString());
                }
                this.setTitle("Capture Devices");
                break;
            }
            case 10004: {
                list = new Vector();
                HashSet<String> s = new HashSet<String>();
                s.addAll(MimeManager.getMimeTable().values());
                list.addAll(s);
                Collections.sort(list);
                this.setTitle("MIME Types");
                break;
            }
            default: {
                list = new Vector();
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            this.getEntryListModel().addElement(list.get(i));
        }
    }

    private void updateDetailsPane(int selectedIndex, Object selectedValue) {
        if (this.detailsListener == null) {
            return;
        }
        if (selectedValue == null) {
            this.detailsListener.onDetails("");
            return;
        }
        StringBuffer b = new StringBuffer();
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int i;
                String plugIn = (String)selectedValue;
                Format[] inputFormats = PlugInManager.getSupportedInputFormats(plugIn, this.type);
                Format[] outputFormats = PlugInManager.getSupportedOutputFormats(plugIn, this.type);
                b.append("Input Formats ---->\n\n");
                if (inputFormats != null) {
                    for (i = 0; i < inputFormats.length; ++i) {
                        b.append(i + ". " + inputFormats[i].getClass().getName() + "\n " + inputFormats[i] + "\n");
                    }
                }
                b.append("\n\n");
                b.append("Output Formats ---->\n\n");
                if (outputFormats != null) {
                    for (i = 0; i < outputFormats.length; ++i) {
                        b.append(i + ". " + outputFormats[i].getClass().getName() + "\n " + outputFormats[i] + "\n");
                    }
                }
            }
            case 10004: {
                String mimeType = (String)selectedValue;
                List<String> extensions = MimeManager.getExtensions(mimeType);
                for (int i = 0; i < extensions.size(); ++i) {
                    b.append(extensions.get(i) + "\n");
                }
                break;
            }
        }
        this.detailsListener.onDetails(b.toString());
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(313, 280));
        this.add((Component)this.getActionPanel(), "East");
        this.add((Component)this.getEntryPanel(), "Center");
        this.load();
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = insets;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.fill = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = insets;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = insets;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = insets;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = insets;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new GridBagLayout());
            this.actionPanel.add((Component)this.getAddButton(), gridBagConstraints);
            if (this.canMoveItems()) {
                this.actionPanel.add((Component)this.getMoveUpButton(), gridBagConstraints1);
                this.actionPanel.add((Component)this.getMoveDownButton(), gridBagConstraints2);
            }
            this.actionPanel.add((Component)this.getRemoveButton(), gridBagConstraints3);
            this.actionPanel.add((Component)this.getCommitButton(), gridBagConstraints4);
        }
        return this.actionPanel;
    }

    private boolean canMoveItems() {
        return this.type != 10004;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String value1 = EntryPanel.this.getEntryTextField().getText();
                    String value2 = EntryPanel.this.getEntryTextField2() != null ? EntryPanel.this.getEntryTextField2().getText() : null;
                    EntryPanel.this.addEntry(value1, value2);
                }
            });
        }
        return this.addButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index;
                    int[] selectedIndices = EntryPanel.this.getEntryList().getSelectedIndices();
                    int i = 0;
                    while (i < selectedIndices.length && (index = selectedIndices[i]) != 0) {
                        Object entry = EntryPanel.this.getEntryListModel().getElementAt(index);
                        EntryPanel.this.getEntryListModel().removeElementAt(index);
                        EntryPanel.this.getEntryListModel().insertElementAt(entry, index - 1);
                        int n = i++;
                        selectedIndices[n] = selectedIndices[n] - 1;
                    }
                    EntryPanel.this.getEntryList().setSelectedIndices(selectedIndices);
                }
            });
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedIndices = EntryPanel.this.getEntryList().getSelectedIndices();
                    int i = selectedIndices.length - 1;
                    while (i >= 0) {
                        int index = selectedIndices[i];
                        if (index == EntryPanel.this.getEntryListModel().getSize() - 1) {
                            return;
                        }
                        Object entry = EntryPanel.this.getEntryListModel().getElementAt(index);
                        EntryPanel.this.getEntryListModel().removeElementAt(index);
                        EntryPanel.this.getEntryListModel().insertElementAt(entry, index + 1);
                        int n = i--;
                        selectedIndices[n] = selectedIndices[n] + 1;
                    }
                    EntryPanel.this.getEntryList().setSelectedIndices(selectedIndices);
                }
            });
        }
        return this.moveDownButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedIndices = EntryPanel.this.getEntryList().getSelectedIndices();
                    for (int i = selectedIndices.length - 1; i >= 0; --i) {
                        int index = selectedIndices[i];
                        Object entry = EntryPanel.this.getEntryListModel().getElementAt(index);
                        String value = (String)EntryPanel.this.getEntryListModel().getElementAt(index);
                        EntryPanel.this.removeEntry(value);
                    }
                }
            });
        }
        return this.removeButton;
    }

    private JButton getCommitButton() {
        if (this.commitButton == null) {
            this.commitButton = new JButton();
            this.commitButton.setText("Commit");
            this.commitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EntryPanel.this.commit();
                }
            });
        }
        return this.commitButton;
    }

    private JPanel getEntryPanel() {
        if (this.entryPanel == null) {
            this.entryPanel = new JPanel();
            this.entryPanel.setLayout(new BorderLayout());
            this.entryPanel.add((Component)this.getEntryTopPanel(), "North");
            this.entryPanel.add((Component)this.getListScrollPane(), "Center");
        }
        return this.entryPanel;
    }

    private JPanel getEntryTopPanel() {
        if (this.entryTopPanel == null) {
            this.entryTopPanel = new JPanel();
            int rows = this.usesSecondEntryTextField() ? 3 : 2;
            this.entryTopPanel.setLayout(new GridLayout(rows, 1));
            this.entryTopPanel.add(this.getEntryLabel());
            this.entryTopPanel.add(this.getEntryTextField());
            if (this.usesSecondEntryTextField()) {
                this.entryTopPanel.add(this.getEntryTextField2());
            }
        }
        return this.entryTopPanel;
    }

    private boolean usesSecondEntryTextField() {
        return this.type == 10004;
    }

    private JLabel getEntryLabel() {
        if (this.entryLabel == null) {
            this.entryLabel = new JLabel();
            this.entryLabel.setText("Title");
        }
        return this.entryLabel;
    }

    private JTextField getEntryTextField() {
        if (this.entryTextField == null) {
            this.entryTextField = new JTextField();
            this.entryTextField.setEditable(true);
        }
        return this.entryTextField;
    }

    private JTextField getEntryTextField2() {
        if (this.type != 10004) {
            return null;
        }
        if (this.entryTextField2 == null) {
            this.entryTextField2 = new JTextField();
            this.entryTextField2.setEditable(true);
        }
        return this.entryTextField2;
    }

    private JList getEntryList() {
        if (this.entryList == null) {
            this.entryList = new JList(this.getEntryListModel());
            this.entryList.setDragEnabled(true);
            this.entryList.setSelectionMode(0);
            this.entryList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        EntryPanel.this.updateDetailsPane(EntryPanel.this.entryList.getSelectedIndex(), EntryPanel.this.entryList.getSelectedValue());
                    }
                }
            });
        }
        return this.entryList;
    }

    private DefaultComboBoxModel getEntryListModel() {
        if (this.entryListModel == null) {
            this.entryListModel = new DefaultComboBoxModel();
        }
        return this.entryListModel;
    }

    private JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane(this.getEntryList());
        }
        return this.listScrollPane;
    }

    public DetailsListener getDetailsListener() {
        return this.detailsListener;
    }

    public void setDetailsListener(DetailsListener detailsListener) {
        this.detailsListener = detailsListener;
    }
}

