/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.net.FileNameMap;
import java.util.HashMap;
import java.util.Map;
import net.sf.fmj.utility.PathUtils;

public class CustomFileNameMap
implements FileNameMap {
    private final Map map = new HashMap();

    public void map(String[] exts, String type) {
        for (int i = 0; i < exts.length; ++i) {
            this.map(exts[i], type);
        }
    }

    public void map(String ext, String type) {
        if (ext.startsWith(".")) {
            throw new IllegalArgumentException("Extension should not include dot");
        }
        this.map.put(ext.toLowerCase(), type);
    }

    public String getType(String ext) {
        if (ext == null) {
            return null;
        }
        return (String)this.map.get(ext.toLowerCase());
    }

    public String getContentTypeFor(String fileName) {
        return this.getType(PathUtils.extractExtension(fileName));
    }
}

