/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RegistryContents;
import net.sf.fmj.utility.RegistryIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final Logger logger = LoggerSingleton.logger;
    private static final Registry registry = new Registry();
    private final RegistryContents registryContents = new RegistryContents();

    public static Registry getInstance() {
        return registry;
    }

    private Registry() {
        try {
            if (System.getProperty("net.sf.fmj.utility.JmfRegistry.disableLoad", "false").equals("true")) {
                this.setDefaults();
                return;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            File f = this.getRegistryFile();
            if (!f.exists()) {
                logger.fine("JMF registry file does not exist.  Using defaults.");
                this.setDefaults();
                return;
            }
            FileReader reader = new FileReader(f);
            new RegistryIO(this.registryContents).load(reader);
        }
        catch (Throwable e) {
            logger.warning("Problem loading JMF registry: " + e.getMessage() + ".  Using defaults.");
            this.setDefaults();
        }
    }

    public synchronized void commit() throws IOException {
        FileWriter fileWriter = new FileWriter(this.getRegistryFile());
        new RegistryIO(this.registryContents).write(fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    public synchronized List<String> getPluginList(int pluginType) {
        Vector<String> pluginList = this.registryContents.plugins[pluginType - 1];
        return (List)pluginList.clone();
    }

    public synchronized void setPluginList(int pluginType, List<String> plugins) {
        Vector<String> pluginList = this.registryContents.plugins[pluginType - 1];
        pluginList.clear();
        pluginList.addAll(plugins);
    }

    public synchronized void setProtocolPrefixList(List<String> list) {
        if (!list.contains("javax")) {
            list.add("javax");
        }
        this.registryContents.protocolPrefixList.clear();
        this.registryContents.protocolPrefixList.addAll(list);
    }

    public synchronized Vector<String> getProtocolPrefixList() {
        return (Vector)this.registryContents.protocolPrefixList.clone();
    }

    public synchronized void setContentPrefixList(List<String> list) {
        if (!list.contains("javax")) {
            list.add("javax");
        }
        this.registryContents.contentPrefixList.clear();
        this.registryContents.contentPrefixList.addAll(list);
    }

    public synchronized Vector<String> getContentPrefixList() {
        return (Vector)this.registryContents.contentPrefixList.clone();
    }

    public synchronized void addMimeType(String extension, String type) {
        this.registryContents.mimeTable.addMimeType(extension, type);
    }

    public synchronized String getMimeType(String extension) {
        return this.registryContents.mimeTable.getMimeType(extension);
    }

    public synchronized String getDefaultExtension(String mimeType) {
        return this.registryContents.mimeTable.getDefaultExtension(mimeType);
    }

    public synchronized Hashtable getMimeTable() {
        return this.registryContents.mimeTable.getMimeTable();
    }

    public synchronized boolean removeMimeType(String fileExtension) {
        return this.registryContents.mimeTable.removeMimeType(fileExtension);
    }

    public synchronized List getExtensions(String mimeType) {
        return this.registryContents.mimeTable.getExtensions(mimeType);
    }

    public synchronized Vector<CaptureDeviceInfo> getDeviceList() {
        return (Vector)this.registryContents.captureDeviceInfoList.clone();
    }

    public synchronized boolean addDevice(CaptureDeviceInfo newDevice) {
        return this.registryContents.captureDeviceInfoList.add(newDevice);
    }

    public synchronized boolean removeDevice(CaptureDeviceInfo device) {
        return this.registryContents.captureDeviceInfoList.remove(device);
    }

    private void setDefaults() {
        boolean jmfDefaults = false;
        try {
            jmfDefaults = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int flags = jmfDefaults ? 1 : 7;
        this.registryContents.protocolPrefixList.addAll(RegistryDefaults.protocolPrefixList(flags));
        this.registryContents.contentPrefixList.addAll(RegistryDefaults.contentPrefixList(flags));
    }

    private File getRegistryFile() {
        String filename = System.getProperty("net.sf.fmj.utility.JmfRegistry.filename", ".fmj.registry.xml");
        String home = System.getProperty("user.home");
        return new File(home + File.separator + filename);
    }
}

