/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RegistryContents;
import net.sf.fmj.utility.SerializationUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class RegistryIO {
    private static final Logger logger = LoggerSingleton.logger;
    private final RegistryContents registryContents;
    private static final String version = "0.1";
    private static final String ELEMENT_REGISTRY = "registry";
    private static final String ATTR_VERSION = "version";
    private static final String ELEMENT_PROTO_PREFIX = "protocol-prefixes";
    private static final String ELEMENT_CONTENT_PREFIX = "content-prefixes";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ELEMENT_MIMETYPES = "mime-types";
    private static final String ELEMENT_MIMETYPE = "type";
    private static final String ELEMENT_CAPTURE_DEVICES = "capture-devices";
    private static final String ELEMENT_CODECS = "codecs";
    private static final String ELEMENT_DEMUXES = "demuxes";
    private static final String ELEMENT_MUXES = "muxes";
    private static final String ELEMENT_EFFECTS = "effects";
    private static final String ELEMENT_RENDERERS = "renderers";
    private static final String ELEMENT_PREFIX = "prefix";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_DEVICE = "device";
    private static final String ELEMENT_DEVICE_NAME = "name";
    private static final String ELEMENT_DEVICE_LOCATOR = "locator";
    private static final String ELEMENT_DEVICE_FORMAT = "format";
    private static final String ELEMENT_DEVICE_FORMAT_CLASS = "class";
    private static final String ELEMENT_DEVICE_FORMAT_DESCRIPTION = "description";
    private static final String ELEMENT_DEVICE_FORMAT_SERIALIZED = "serialized";

    public RegistryIO(RegistryContents registryContents) {
        this.registryContents = registryContents;
    }

    public void load(Reader reader) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(reader);
            this.loadDocument(document);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.buildDocument();
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(org.jdom.output.Format.getPrettyFormat());
        xmlOutputter.output(document, writer);
    }

    private void loadDocument(Document document) throws IOException {
        Element rootElement = document.getRootElement();
        String versionString = rootElement.getAttributeValue(ATTR_VERSION);
        logger.info("FMJ registry document version " + versionString);
        Element pluginsElement = rootElement.getChild(ELEMENT_PLUGINS);
        this.loadPlugins(pluginsElement);
        Element contentPrefixesElement = rootElement.getChild(ELEMENT_CONTENT_PREFIX);
        this.loadContentPrefixes(contentPrefixesElement);
        Element protocolPrefixesElement = rootElement.getChild(ELEMENT_PROTO_PREFIX);
        this.loadProtocolPrefixes(protocolPrefixesElement);
        Element mimetypesElement = rootElement.getChild(ELEMENT_MIMETYPES);
        this.loadMimeTypes(mimetypesElement);
        Element captureDevicesElement = rootElement.getChild(ELEMENT_CAPTURE_DEVICES);
        try {
            this.loadCaptureDevices(captureDevicesElement);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void loadPlugins(Element element) {
        Element codecsElement = element.getChild(ELEMENT_CODECS);
        this.loadPlugins(codecsElement, 2);
        Element effectsElement = element.getChild(ELEMENT_EFFECTS);
        this.loadPlugins(effectsElement, 3);
        Element renderersElement = element.getChild(ELEMENT_RENDERERS);
        this.loadPlugins(renderersElement, 4);
        Element muxesElement = element.getChild(ELEMENT_MUXES);
        this.loadPlugins(muxesElement, 5);
        Element demuxesElement = element.getChild(ELEMENT_DEMUXES);
        this.loadPlugins(demuxesElement, 1);
    }

    private void loadPlugins(Element element, int type) {
        if (element == null) {
            return;
        }
        Vector<String> vector = this.registryContents.plugins[type - 1];
        List pluginElements = element.getChildren("class");
        for (int i = 0; i < pluginElements.size(); ++i) {
            Element pluginElement = (Element)pluginElements.get(i);
            String classname = pluginElement.getTextTrim();
            vector.add(classname);
        }
    }

    private void loadProtocolPrefixes(Element element) {
        this.registryContents.protocolPrefixList.clear();
        List list = element.getChildren(ELEMENT_PREFIX);
        for (int i = 0; i < list.size(); ++i) {
            Element prefixElement = (Element)list.get(i);
            this.registryContents.protocolPrefixList.add(prefixElement.getTextTrim());
        }
    }

    private void loadContentPrefixes(Element element) {
        this.registryContents.contentPrefixList.clear();
        List list = element.getChildren(ELEMENT_PREFIX);
        for (int i = 0; i < list.size(); ++i) {
            Element prefixElement = (Element)list.get(i);
            this.registryContents.contentPrefixList.add(prefixElement.getTextTrim());
        }
    }

    private Document buildDocument() throws IOException {
        Document document = new Document();
        Element rootElement = new Element(ELEMENT_REGISTRY);
        rootElement.setAttribute(ATTR_VERSION, version);
        document.setRootElement(rootElement);
        rootElement.addContent((Content)this.getPluginsElement());
        rootElement.addContent((Content)this.getContentElement());
        rootElement.addContent((Content)this.getProtocolElement());
        rootElement.addContent((Content)this.getMimeElement());
        rootElement.addContent((Content)this.getCaptureDeviceElement());
        return document;
    }

    private Element getPluginsElement() {
        Element pluginElement = new Element(ELEMENT_PLUGINS);
        pluginElement.addContent((Content)this.getCodecElement());
        pluginElement.addContent((Content)this.getDemuxElement());
        pluginElement.addContent((Content)this.getEffectElement());
        pluginElement.addContent((Content)this.getMuxElement());
        pluginElement.addContent((Content)this.getRendererElement());
        return pluginElement;
    }

    private Element getCodecElement() {
        return this.getPluginElement(2, ELEMENT_CODECS);
    }

    private Element getDemuxElement() {
        return this.getPluginElement(1, ELEMENT_DEMUXES);
    }

    private Element getEffectElement() {
        return this.getPluginElement(3, ELEMENT_EFFECTS);
    }

    private Element getMuxElement() {
        return this.getPluginElement(5, ELEMENT_MUXES);
    }

    private Element getRendererElement() {
        return this.getPluginElement(4, ELEMENT_RENDERERS);
    }

    private Element getPluginElement(int pluginType, String typeName) {
        Element pluginsElement = new Element(typeName);
        Vector<String> plugins = this.registryContents.plugins[pluginType - 1];
        if (plugins != null) {
            for (String classname : plugins) {
                Element pluginElement = new Element("class");
                pluginElement.setText(classname);
                pluginsElement.addContent((Content)pluginElement);
            }
        }
        return pluginsElement;
    }

    private Element getContentElement() {
        Element contentElement = new Element(ELEMENT_CONTENT_PREFIX);
        for (String prefix : this.registryContents.contentPrefixList) {
            Element prefixElement = new Element(ELEMENT_PREFIX);
            prefixElement.setText(prefix);
            contentElement.addContent((Content)prefixElement);
        }
        return contentElement;
    }

    private Element getProtocolElement() {
        Element protocolElement = new Element(ELEMENT_PROTO_PREFIX);
        for (String prefix : this.registryContents.protocolPrefixList) {
            Element prefixElement = new Element(ELEMENT_PREFIX);
            prefixElement.setText(prefix);
            protocolElement.addContent((Content)prefixElement);
        }
        return protocolElement;
    }

    private void loadMimeTypes(Element element) {
        this.registryContents.mimeTable.clear();
        List list = element.getChildren(ELEMENT_MIMETYPE);
        for (int i = 0; i < list.size(); ++i) {
            Element typeElement = (Element)list.get(i);
            String type = typeElement.getAttributeValue("value");
            String defaultExtension = typeElement.getAttributeValue("default-ext");
            List list2 = typeElement.getChildren("ext");
            for (int j = 0; j < list2.size(); ++j) {
                Element extElement = (Element)list2.get(j);
                String ext = extElement.getText();
                this.registryContents.mimeTable.addMimeType(ext, type);
            }
            this.registryContents.mimeTable.addMimeType(defaultExtension, type);
        }
    }

    private Element getMimeElement() {
        Element mimeElement = new Element(ELEMENT_MIMETYPES);
        for (String type : this.registryContents.mimeTable.getMimeTypes()) {
            List<String> extensions = this.registryContents.mimeTable.getExtensions(type);
            Element typeElement = new Element(ELEMENT_MIMETYPE);
            typeElement.setAttribute("value", type);
            typeElement.setAttribute("default-ext", this.registryContents.mimeTable.getDefaultExtension(type));
            mimeElement.addContent((Content)typeElement);
            for (int i = 0; i < extensions.size(); ++i) {
                String ext = extensions.get(i);
                Element extElement = new Element("ext");
                extElement.setText(ext);
                typeElement.addContent((Content)extElement);
            }
        }
        return mimeElement;
    }

    private void loadCaptureDevices(Element element) throws IOException, ClassNotFoundException {
        this.registryContents.captureDeviceInfoList.clear();
        List list = element.getChildren(ELEMENT_DEVICE);
        for (int i = 0; i < list.size(); ++i) {
            Element deviceElement = (Element)list.get(i);
            Element deviceNameElement = deviceElement.getChild(ELEMENT_DEVICE_NAME);
            Element deviceLocatorElement = deviceElement.getChild(ELEMENT_DEVICE_LOCATOR);
            List formatElementsList = deviceElement.getChildren(ELEMENT_DEVICE_FORMAT);
            Format[] formats = new Format[formatElementsList.size()];
            for (int j = 0; j < formatElementsList.size(); ++j) {
                Element formatElement = (Element)formatElementsList.get(j);
                Element serializedElement = formatElement.getChild(ELEMENT_DEVICE_FORMAT_SERIALIZED);
                formats[j] = SerializationUtils.deserialize(serializedElement.getTextTrim());
            }
            CaptureDeviceInfo info = new CaptureDeviceInfo(deviceNameElement.getTextTrim(), new MediaLocator(deviceLocatorElement.getTextTrim()), formats);
            this.registryContents.captureDeviceInfoList.add(info);
        }
    }

    private Element getCaptureDeviceElement() throws IOException {
        Element captureDeviceElement = new Element(ELEMENT_CAPTURE_DEVICES);
        for (CaptureDeviceInfo info : this.registryContents.captureDeviceInfoList) {
            if (info.getLocator() == null) continue;
            Element deviceElement = new Element(ELEMENT_DEVICE);
            Element deviceNameElement = new Element(ELEMENT_DEVICE_NAME);
            deviceNameElement.setText(info.getName());
            deviceElement.addContent((Content)deviceNameElement);
            Element e = new Element(ELEMENT_DEVICE_LOCATOR);
            e.setText(info.getLocator().toExternalForm());
            deviceElement.addContent((Content)e);
            Format[] formats = info.getFormats();
            for (int i = 0; i < formats.length; ++i) {
                Element formatElement = new Element(ELEMENT_DEVICE_FORMAT);
                Element e2 = new Element("class");
                e2.setText(formats[i].getClass().getName());
                formatElement.addContent((Content)e2);
                e2 = new Element(ELEMENT_DEVICE_FORMAT_DESCRIPTION);
                e2.setText(formats[i].toString());
                formatElement.addContent((Content)e2);
                e2 = new Element(ELEMENT_DEVICE_FORMAT_SERIALIZED);
                e2.setText(SerializationUtils.serialize(formats[i]));
                formatElement.addContent((Content)e2);
                deviceElement.addContent((Content)formatElement);
            }
            captureDeviceElement.addContent((Content)deviceElement);
        }
        return captureDeviceElement;
    }
}

