/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import net.sf.fmj.utility.ByteUtils;
import sun.misc.BASE64Encoder;

public final class StringUtils {
    private static final int MAX_STANDARD_ASCII = 255;
    private static final int RADIX_16 = 16;

    public static String byteToHexString_ZeroPad(byte b) {
        String s = Integer.toHexString(ByteUtils.uByteToInt(b));
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static String replaceSpecialUrlChars(String raw) {
        return StringUtils.replaceSpecialUrlChars(raw, false);
    }

    public static String replaceSpecialUrlChars(String raw, boolean isPath) {
        if (raw == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == '~' || isPath && (c == '/' || c == ':' || c == '\\')) {
                buf.append(c);
                continue;
            }
            if (i > 255) {
                throw new IllegalArgumentException();
            }
            buf.append('%');
            buf.append(StringUtils.byteToHexString_ZeroPad((byte)c));
        }
        return buf.toString();
    }

    public static String restoreSpecialURLChars(String cooked) {
        if (cooked == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer hexValueBuf = new StringBuffer();
        boolean state = false;
        for (int i = 0; i < cooked.length(); ++i) {
            char c = cooked.charAt(i);
            if (!state) {
                if (c == '%') {
                    state = true;
                    hexValueBuf = new StringBuffer();
                    continue;
                }
                buf.append(c);
                continue;
            }
            hexValueBuf.append(c);
            if (hexValueBuf.length() == 2) {
                String token = hexValueBuf.toString();
                int value = Integer.parseInt(token, 16);
                buf.append((char)value);
                state = false;
                continue;
            }
            if (hexValueBuf.length() != 1 || hexValueBuf.charAt(0) != '%') continue;
            buf.append('%');
            state = false;
        }
        if (state) {
            buf.append("&" + hexValueBuf.toString());
        }
        return buf.toString();
    }

    public static String dump(byte[] bytes, int offset, int byteslen) {
        StringBuffer b = new StringBuffer();
        int width = 32;
        int len = 32;
        while (offset < byteslen) {
            int i;
            int remainder = 0;
            if (offset + len > byteslen) {
                len = byteslen - offset;
                remainder = 32 - len;
            }
            b.append(StringUtils.byteArrayToHexString(bytes, len, offset));
            for (i = 0; i < remainder; ++i) {
                b.append("  ");
            }
            b.append(" | ");
            for (i = 0; i < len; ++i) {
                byte c = bytes[offset + i];
                if (c >= 32 && c <= 126) {
                    b.append((char)c);
                    continue;
                }
                b.append('.');
            }
            b.append('\n');
            offset += len;
        }
        return b.toString();
    }

    public static String byteArrayToHexString(byte[] array, int len, int offset) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String byteStr = Integer.toHexString(ByteUtils.uByteToInt(array[offset + i]));
            if (byteStr.length() == 1) {
                byteStr = "0" + byteStr;
            }
            b.append(byteStr);
        }
        return b.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] array = new byte[s.length() / 2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtils.hexStringToByte(s.substring(i * 2, i * 2 + 2));
        }
        return array;
    }

    public static byte hexStringToByte(String s) {
        return (byte)Integer.parseInt(s, 16);
    }

    public static String byteArrayToBase64String(byte[] value) {
        BASE64Encoder base64Encoder = new BASE64Encoder();
        return base64Encoder.encode(value);
    }
}

