/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.File;
import net.sf.fmj.utility.OSUtils;
import net.sf.fmj.utility.StringUtils;

public final class URLUtils {
    private URLUtils() {
    }

    public static String createAbsoluteFileUrl(String urlStr) {
        String path = URLUtils.extractValidPathFromFileUrl(urlStr);
        if (path == null) {
            return null;
        }
        return URLUtils.createUrlStr(new File(path));
    }

    public static String createUrlStr(File file) {
        String path = file.getAbsolutePath();
        String prefix = path.startsWith("/") ? "file://" : "file:///";
        if (OSUtils.isWindows()) {
            path = path.replaceAll("\\\\", "/");
        }
        return prefix + StringUtils.replaceSpecialUrlChars(path, true);
    }

    public static String extractValidPathFromFileUrl(String url) {
        return URLUtils.extractValidPathFromFileUrl(url, false);
    }

    public static String extractValidNewFilePathFromFileUrl(String url) {
        return URLUtils.extractValidPathFromFileUrl(url, true);
    }

    private static boolean exists(String path, boolean checkParentDirOnly) {
        if (checkParentDirOnly) {
            return new File(path).getParentFile().exists();
        }
        return new File(path).exists();
    }

    private static String extractValidPathFromFileUrl(String url, boolean checkParentDirOnly) {
        String result;
        if (!url.startsWith("file:")) {
            return null;
        }
        String remainder = url.substring("file:".length());
        if (!(remainder = StringUtils.restoreSpecialURLChars(remainder)).startsWith("/")) {
            return remainder;
        }
        if (remainder.startsWith("//") && URLUtils.exists(result = remainder.substring(2), checkParentDirOnly)) {
            return result;
        }
        result = remainder;
        while (result.startsWith("//")) {
            result = result.substring(1);
        }
        if (URLUtils.exists(result, checkParentDirOnly)) {
            return result;
        }
        while (result.startsWith("/")) {
            if (!URLUtils.exists(result = result.substring(1), checkParentDirOnly)) continue;
            return result;
        }
        return null;
    }
}

