/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PTR_PCF_PATHWAY;
import ca.uhn.hl7v2.model.v23.group.PTR_PCF_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTR_PCF_PATIENT
extends AbstractGroup {
    public PTR_PCF_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PTR_PCF_PATIENT_VISIT.class, false, false, false);
            this.add(PTR_PCF_PATHWAY.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PTR_PCF_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PTR_PCF_PATIENT_VISIT getPATIENT_VISIT() {
        PTR_PCF_PATIENT_VISIT retVal = (PTR_PCF_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PTR_PCF_PATIENT_VISIT.class);
        return retVal;
    }

    public PTR_PCF_PATHWAY getPATHWAY() {
        PTR_PCF_PATHWAY retVal = (PTR_PCF_PATHWAY)this.getTyped("PATHWAY", PTR_PCF_PATHWAY.class);
        return retVal;
    }

    public PTR_PCF_PATHWAY getPATHWAY(int rep) {
        PTR_PCF_PATHWAY retVal = (PTR_PCF_PATHWAY)this.getTyped("PATHWAY", rep, PTR_PCF_PATHWAY.class);
        return retVal;
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PTR_PCF_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PTR_PCF_PATHWAY.class);
    }

    public void insertPATHWAY(PTR_PCF_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PTR_PCF_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PTR_PCF_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

