/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.VXU_V04_OBSERVATION;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.model.v23.segment.RXA;
import ca.uhn.hl7v2.model.v23.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXU_V04_ORDER
extends AbstractGroup {
    public VXU_V04_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(RXA.class, true, false, false);
            this.add(RXR.class, false, false, false);
            this.add(VXU_V04_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RXA getRXA() {
        RXA retVal = (RXA)this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public VXU_V04_OBSERVATION getOBSERVATION() {
        VXU_V04_OBSERVATION retVal = (VXU_V04_OBSERVATION)this.getTyped("OBSERVATION", VXU_V04_OBSERVATION.class);
        return retVal;
    }

    public VXU_V04_OBSERVATION getOBSERVATION(int rep) {
        VXU_V04_OBSERVATION retVal = (VXU_V04_OBSERVATION)this.getTyped("OBSERVATION", rep, VXU_V04_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<VXU_V04_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", VXU_V04_OBSERVATION.class);
    }

    public void insertOBSERVATION(VXU_V04_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public VXU_V04_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public VXU_V04_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (VXU_V04_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

