/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.b.j;
import java.io.Serializable;

public class Coordinate
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 6683108902428366910L;
    public double x;
    public double y;
    public double z;

    public Coordinate(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(Coordinate coordinate) {
        this(coordinate.x, coordinate.y, coordinate.z);
    }

    public Coordinate(double d2, double d3) {
        this(d2, d3, Double.NaN);
    }

    public void setCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public boolean equals2D(Coordinate coordinate) {
        if (this.x != coordinate.x) {
            return false;
        }
        return this.y == coordinate.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)object);
    }

    public int compareTo(Object object) {
        object = (Coordinate)object;
        if (this.x < ((Coordinate)object).x) {
            return -1;
        }
        if (this.x > ((Coordinate)object).x) {
            return 1;
        }
        if (this.y < ((Coordinate)object).y) {
            return -1;
        }
        if (this.y > ((Coordinate)object).y) {
            return 1;
        }
        return 0;
    }

    public boolean equals3D(Coordinate coordinate) {
        return this.x == coordinate.x && this.y == coordinate.y && (this.z == coordinate.z || Double.isNaN(this.z) && Double.isNaN(coordinate.z));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Object clone() {
        try {
            Coordinate coordinate = (Coordinate)super.clone();
            return coordinate;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            j.a("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public double distance(Coordinate coordinate) {
        double d2 = this.x - coordinate.x;
        double d3 = this.y - coordinate.y;
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public int hashCode() {
        int n2 = 629 + Coordinate.hashCode(this.x);
        n2 = n2 * 37 + Coordinate.hashCode(this.y);
        return n2;
    }

    public static int hashCode(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }
}

