/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.b.j;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.b;
import com.vividsolutions.jts.geom.e;
import com.vividsolutions.jts.geom.g;
import com.vividsolutions.jts.geom.h;
import com.vividsolutions.jts.geom.k;
import com.vividsolutions.jts.geom.t;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometryArray, t t2, int n2) {
        this(geometryArray, new GeometryFactory(t2, n2));
    }

    public GeometryCollection(Geometry[] geometryArray, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (geometryArray == null) {
            geometryArray = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometryArray)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometryArray;
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n2 = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            Coordinate[] coordinateArray2 = this.geometries[i2].getCoordinates();
            for (int i3 = 0; i3 < coordinateArray2.length; ++i3) {
                coordinateArray[++n2] = coordinateArray2[i3];
            }
        }
        return coordinateArray;
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getDimension() {
        int n2 = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            n2 = Math.max(n2, this.geometries[i2].getDimension());
        }
        return n2;
    }

    public int getBoundaryDimension() {
        int n2 = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            n2 = Math.max(n2, this.geometries[i2].getBoundaryDimension());
        }
        return n2;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n2) {
        return this.geometries[n2];
    }

    public int getNumPoints() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            n2 += this.geometries[i2].getNumPoints();
        }
        return n2;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        j.a(null);
        return null;
    }

    public double getArea() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            d2 += this.geometries[i2].getArea();
        }
        return d2;
    }

    public double getLength() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            d2 += this.geometries[i2].getLength();
        }
        return d2;
    }

    public boolean equalsExact(Geometry geometry, double d2) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        geometry = (GeometryCollection)geometry;
        if (this.geometries.length != ((GeometryCollection)geometry).geometries.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].equalsExact(((GeometryCollection)geometry).geometries[i2], d2)) continue;
            return false;
        }
        return true;
    }

    public void apply(b b2) {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(b2);
        }
    }

    public void apply(g g2) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(g2);
            if (g2.a()) break;
        }
        if (g2.b()) {
            this.geometryChanged();
        }
    }

    public void apply$6f9a9d12(k k2) {
        k2.a(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply$6f9a9d12(k2);
        }
    }

    public void apply(k k2) {
        k2.a(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(k2);
        }
    }

    public Object clone() {
        GeometryCollection geometryCollection = (GeometryCollection)super.clone();
        ((GeometryCollection)super.clone()).geometries = new Geometry[this.geometries.length];
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            geometryCollection.geometries[i2] = (Geometry)this.geometries[i2].clone();
        }
        return geometryCollection;
    }

    public void normalize() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].normalize();
        }
        Arrays.sort(this.geometries);
    }

    protected h computeEnvelopeInternal() {
        h h2 = new h();
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            h2.a(this.geometries[i2].getEnvelopeInternal());
        }
        return h2;
    }

    protected int compareToSameClass(Object treeSet) {
        TreeSet<Geometry> treeSet2 = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        treeSet = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)((Object)treeSet)).geometries));
        return this.compare(treeSet2, treeSet);
    }

    protected int compareToSameClass(Object object, e e2) {
        int n2;
        object = (GeometryCollection)object;
        int n3 = this.getNumGeometries();
        int n4 = ((GeometryCollection)object).getNumGeometries();
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            Geometry geometry;
            Geometry geometry2 = this.getGeometryN(n2);
            int n5 = geometry2.compareToSameClass(geometry = ((GeometryCollection)object).getGeometryN(n2), e2);
            if (n5 == 0) continue;
            return n5;
        }
        if (n2 < n3) {
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        return 0;
    }
}

